<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Receipt Information
 * @subpackage Structs
 */
class Receipt_Response_DataType extends AbstractStructBase
{
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - documentation: Receipt
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReceiptType[]
     */
    public $Receipt;
    /**
     * Constructor method for Receipt_Response_DataType
     * @uses Receipt_Response_DataType::setReceipt()
     * @param \StructType\ReceiptType[] $receipt
     */
    public function __construct(array $receipt = array())
    {
        $this
            ->setReceipt($receipt);
    }
    /**
     * Get Receipt value
     * @return \StructType\ReceiptType[]|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptForArrayConstraintsFromSetReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Response_DataTypeReceiptItem) {
            // validation for constraint: itemType
            if (!$receipt_Response_DataTypeReceiptItem instanceof \StructType\ReceiptType) {
                $invalidValues[] = is_object($receipt_Response_DataTypeReceiptItem) ? get_class($receipt_Response_DataTypeReceiptItem) : sprintf('%s(%s)', gettype($receipt_Response_DataTypeReceiptItem), var_export($receipt_Response_DataTypeReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt property can only contain items of type \StructType\ReceiptType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt value
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptType[] $receipt
     * @return \StructType\Receipt_Response_DataType
     */
    public function setReceipt(array $receipt = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptArrayErrorMessage = self::validateReceiptForArrayConstraintsFromSetReceipt($receipt))) {
            throw new \InvalidArgumentException($receiptArrayErrorMessage, __LINE__);
        }
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Add item to Receipt value
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptType $item
     * @return \StructType\Receipt_Response_DataType
     */
    public function addToReceipt(\StructType\ReceiptType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReceiptType) {
            throw new \InvalidArgumentException(sprintf('The Receipt property can only contain items of type \StructType\ReceiptType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt[] = $item;
        return $this;
    }
}
