<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Sheet_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Role Standard Cost Rate request criteria
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Sheet_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Project_Rate_Sheet_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Project_Rate_Sheet_Currency_Reference;
    /**
     * The Project_Rate_Sheet_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Rate_Sheet_Effective_Date;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Sheet_Request_CriteriaType
     * @uses Project_Standard_Cost_Rate_Sheet_Request_CriteriaType::setProject_Rate_Sheet_Currency_Reference()
     * @uses Project_Standard_Cost_Rate_Sheet_Request_CriteriaType::setProject_Rate_Sheet_Effective_Date()
     * @param \StructType\CurrencyObjectType $project_Rate_Sheet_Currency_Reference
     * @param string $project_Rate_Sheet_Effective_Date
     */
    public function __construct(\StructType\CurrencyObjectType $project_Rate_Sheet_Currency_Reference = null, $project_Rate_Sheet_Effective_Date = null)
    {
        $this
            ->setProject_Rate_Sheet_Currency_Reference($project_Rate_Sheet_Currency_Reference)
            ->setProject_Rate_Sheet_Effective_Date($project_Rate_Sheet_Effective_Date);
    }
    /**
     * Get Project_Rate_Sheet_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getProject_Rate_Sheet_Currency_Reference()
    {
        return $this->Project_Rate_Sheet_Currency_Reference;
    }
    /**
     * Set Project_Rate_Sheet_Currency_Reference value
     * @param \StructType\CurrencyObjectType $project_Rate_Sheet_Currency_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Request_CriteriaType
     */
    public function setProject_Rate_Sheet_Currency_Reference(\StructType\CurrencyObjectType $project_Rate_Sheet_Currency_Reference = null)
    {
        $this->Project_Rate_Sheet_Currency_Reference = $project_Rate_Sheet_Currency_Reference;
        return $this;
    }
    /**
     * Get Project_Rate_Sheet_Effective_Date value
     * @return string|null
     */
    public function getProject_Rate_Sheet_Effective_Date()
    {
        return $this->Project_Rate_Sheet_Effective_Date;
    }
    /**
     * Set Project_Rate_Sheet_Effective_Date value
     * @param string $project_Rate_Sheet_Effective_Date
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Request_CriteriaType
     */
    public function setProject_Rate_Sheet_Effective_Date($project_Rate_Sheet_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($project_Rate_Sheet_Effective_Date) && !is_string($project_Rate_Sheet_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Rate_Sheet_Effective_Date, true), gettype($project_Rate_Sheet_Effective_Date)), __LINE__);
        }
        $this->Project_Rate_Sheet_Effective_Date = $project_Rate_Sheet_Effective_Date;
        return $this;
    }
}
