<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_CodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code
 * @subpackage Structs
 */
class Commodity_CodeType extends AbstractStructBase
{
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Commodity Code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Commodity_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Data Element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Commodity_Code_DataType[]
     */
    public $Commodity_Code_Data;
    /**
     * Constructor method for Commodity_CodeType
     * @uses Commodity_CodeType::setCommodity_Code_Reference()
     * @uses Commodity_CodeType::setCommodity_Code_Data()
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Commodity_Code_DataType[] $commodity_Code_Data
     */
    public function __construct(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, array $commodity_Code_Data = array())
    {
        $this
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setCommodity_Code_Data($commodity_Code_Data);
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Commodity_CodeType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Data value
     * @return \StructType\Commodity_Code_DataType[]|null
     */
    public function getCommodity_Code_Data()
    {
        return $this->Commodity_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_DataForArrayConstraintsFromSetCommodity_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_CodeTypeCommodity_Code_DataItem) {
            // validation for constraint: itemType
            if (!$commodity_CodeTypeCommodity_Code_DataItem instanceof \StructType\Commodity_Code_DataType) {
                $invalidValues[] = is_object($commodity_CodeTypeCommodity_Code_DataItem) ? get_class($commodity_CodeTypeCommodity_Code_DataItem) : sprintf('%s(%s)', gettype($commodity_CodeTypeCommodity_Code_DataItem), var_export($commodity_CodeTypeCommodity_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Data property can only contain items of type \StructType\Commodity_Code_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_DataType[] $commodity_Code_Data
     * @return \StructType\Commodity_CodeType
     */
    public function setCommodity_Code_Data(array $commodity_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_DataArrayErrorMessage = self::validateCommodity_Code_DataForArrayConstraintsFromSetCommodity_Code_Data($commodity_Code_Data))) {
            throw new \InvalidArgumentException($commodity_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Data = $commodity_Code_Data;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_DataType $item
     * @return \StructType\Commodity_CodeType
     */
    public function addToCommodity_Code_Data(\StructType\Commodity_Code_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_Code_DataType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Data property can only contain items of type \StructType\Commodity_Code_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Data[] = $item;
        return $this;
    }
}
