<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Asset_In_Service_Date_Update_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Business Asset 'In Service Date' update details.
 * @subpackage Structs
 */
class Business_Asset_In_Service_Date_Update_DataType extends AbstractStructBase
{
    /**
     * The Adjust_In_Service_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter a Date Placed in Service that starts asset depreciation on or before the supplier contract end date. | Enter a Date Placed in Service for an existing ledger period. | Enter a Date Placed in Service that is different from the
     * current date placed in service. | Enter a Date Placed in Service that isn't earlier than the transaction effective date of a post-acquisition adjustment. | Enter a Date Placed in Service that isn't earlier than the transaction effective date of a
     * useful life adjustment. | Enter a Date Placed in Service that isn't in the future. | Enter a Date Placed in Service that isn't before the date acquired. | New value to adjust in service date.
     * - maxOccurs: 1
     * @var string
     */
    public $Adjust_In_Service_Date;
    /**
     * The Restricted_to_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to asset books used by business asset. Enter asset books if you want to restrict in service date adjustment to specific books. To update in service date for all asset books, leave this field blank.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_to_Books_Reference;
    /**
     * Constructor method for Business_Asset_In_Service_Date_Update_DataType
     * @uses Business_Asset_In_Service_Date_Update_DataType::setAdjust_In_Service_Date()
     * @uses Business_Asset_In_Service_Date_Update_DataType::setRestricted_to_Books_Reference()
     * @param string $adjust_In_Service_Date
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     */
    public function __construct($adjust_In_Service_Date = null, array $restricted_to_Books_Reference = array())
    {
        $this
            ->setAdjust_In_Service_Date($adjust_In_Service_Date)
            ->setRestricted_to_Books_Reference($restricted_to_Books_Reference);
    }
    /**
     * Get Adjust_In_Service_Date value
     * @return string|null
     */
    public function getAdjust_In_Service_Date()
    {
        return $this->Adjust_In_Service_Date;
    }
    /**
     * Set Adjust_In_Service_Date value
     * @param string $adjust_In_Service_Date
     * @return \StructType\Business_Asset_In_Service_Date_Update_DataType
     */
    public function setAdjust_In_Service_Date($adjust_In_Service_Date = null)
    {
        // validation for constraint: string
        if (!is_null($adjust_In_Service_Date) && !is_string($adjust_In_Service_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjust_In_Service_Date, true), gettype($adjust_In_Service_Date)), __LINE__);
        }
        $this->Adjust_In_Service_Date = $adjust_In_Service_Date;
        return $this;
    }
    /**
     * Get Restricted_to_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_to_Books_Reference()
    {
        return $this->Restricted_to_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem) ? get_class($business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem) : sprintf('%s(%s)', gettype($business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem), var_export($business_Asset_In_Service_Date_Update_DataTypeRestricted_to_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @return \StructType\Business_Asset_In_Service_Date_Update_DataType
     */
    public function setRestricted_to_Books_Reference(array $restricted_to_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Books_ReferenceArrayErrorMessage = self::validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference($restricted_to_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Books_Reference = $restricted_to_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Business_Asset_In_Service_Date_Update_DataType
     */
    public function addToRestricted_to_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Books_Reference[] = $item;
        return $this;
    }
}
