<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ticket Details Data for a Credit Card Transaction of Air Travel.
 * @subpackage Structs
 */
class Ticket_Details_DataType extends AbstractStructBase
{
    /**
     * The Ticket_Details_Id
     * Meta information extracted from the WSDL
     * - documentation: Ticket ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Details_Id;
    /**
     * The Booking_Date
     * Meta information extracted from the WSDL
     * - documentation: Booking Date for Ticket Details
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Booking_Date;
    /**
     * The Commodity_Code
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commodity_Code;
    /**
     * The Computer_Reservation_System
     * Meta information extracted from the WSDL
     * - documentation: Computer Reservation System
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Computer_Reservation_System;
    /**
     * The Customer_Code
     * Meta information extracted from the WSDL
     * - documentation: Customer Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Code;
    /**
     * The Departure_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Departure Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Departure_Tax_Amount;
    /**
     * The Domestic_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Domestic Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Domestic_Indicator;
    /**
     * The Exchange_Fee_Amount
     * Meta information extracted from the WSDL
     * - documentation: Exchange Fee Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Exchange_Fee_Amount;
    /**
     * The Exchange_Ticket_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Exchange Ticket Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exchange_Ticket_Indicator;
    /**
     * The Exchange_Ticket_Amount
     * Meta information extracted from the WSDL
     * - documentation: Exchange Ticket Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Exchange_Ticket_Amount;
    /**
     * The Exchange_Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Exchange Ticket Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Exchange_Ticket_Number;
    /**
     * The Exchange_Ticket_Number_2
     * Meta information extracted from the WSDL
     * - documentation: Exchange Ticket Number 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Exchange_Ticket_Number_2;
    /**
     * The Fare_Block_One
     * Meta information extracted from the WSDL
     * - documentation: Fare Block One
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Block_One;
    /**
     * The Fare_Block_Two
     * Meta information extracted from the WSDL
     * - documentation: Fare Block Two
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Block_Two;
    /**
     * The Fare_Block_Three
     * Meta information extracted from the WSDL
     * - documentation: Fare Block Three
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Block_Three;
    /**
     * The Fare_Block_Four
     * Meta information extracted from the WSDL
     * - documentation: Fare Block Four
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Block_Four;
    /**
     * The Fare_Calculation_Mode_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Fare Calculation Mode Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fare_Calculation_Mode_Indicator;
    /**
     * The Final_Destination_City
     * Meta information extracted from the WSDL
     * - documentation: Final Destination City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Final_Destination_City;
    /**
     * The IATA_Client_Code
     * Meta information extracted from the WSDL
     * - documentation: IATA Client Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATA_Client_Code;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date for Ticket Details
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Issue_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the Ticket was issued.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Issue_Date;
    /**
     * The Issuing_Carrier
     * Meta information extracted from the WSDL
     * - documentation: Issuing Carrier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Issuing_Carrier;
    /**
     * The Number_of_Legs
     * Meta information extracted from the WSDL
     * - documentation: Total number of legs for the ticket.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Number_of_Legs;
    /**
     * The Original_Issue_Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: The original issued ticket number if the ticket was exchanged a multiple times.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Original_Issue_Ticket_Number;
    /**
     * The Passenger_Name
     * Meta information extracted from the WSDL
     * - documentation: Passenger Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Passenger_Name;
    /**
     * The PNR_Record_Locator
     * Meta information extracted from the WSDL
     * - documentation: This is a 6 digit PNR (Passenger Name Record) record locator.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PNR_Record_Locator;
    /**
     * The Refund_Indicator
     * Meta information extracted from the WSDL
     * - documentation: This field indicates the ticket refund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Refund_Indicator;
    /**
     * The Refund_Number
     * Meta information extracted from the WSDL
     * - documentation: The reference number for the refund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Number;
    /**
     * The Restricted_Ticket_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Restricted Ticket Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Restricted_Ticket_Indicator;
    /**
     * The Tax_Exempt_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Tax Exempt Indicator
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Tax_Exempt_Indicator;
    /**
     * The Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Ticket Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Number;
    /**
     * The Ticket_Type
     * Meta information extracted from the WSDL
     * - documentation: Ticket Type
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Type;
    /**
     * The Ticket_Routing_Type
     * Meta information extracted from the WSDL
     * - documentation: Ticket Routing Type
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Routing_Type;
    /**
     * The TMC_Client_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: TMC Client Account Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TMC_Client_Account_Number;
    /**
     * The TMC_Is_Merchant
     * Meta information extracted from the WSDL
     * - documentation: An indicator if TMC is the merchant.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TMC_Is_Merchant;
    /**
     * The Total_Fare
     * Meta information extracted from the WSDL
     * - documentation: Total Fare
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Total_Fare;
    /**
     * The Total_Fees
     * Meta information extracted from the WSDL
     * - documentation: Total Fees
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Total_Fees;
    /**
     * The Total_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Total_Tax_Amount;
    /**
     * The Travel_Agency_Code
     * Meta information extracted from the WSDL
     * - documentation: Travel Agency Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Agency_Code;
    /**
     * The Travel_Agency_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Travel Agency Invoice Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Agency_Invoice_Number;
    /**
     * The Travel_Agency_Name
     * Meta information extracted from the WSDL
     * - documentation: Travel Agency Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Agency_Name;
    /**
     * The Travel_Agency_Product_Code
     * Meta information extracted from the WSDL
     * - documentation: Travel Agency Product Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Agency_Product_Code;
    /**
     * The Travel_Authorization_Code
     * Meta information extracted from the WSDL
     * - documentation: Travel Authorization Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Authorization_Code;
    /**
     * The Trip_Leg_Details_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Trip_Leg_Details_DataType[]
     */
    public $Trip_Leg_Details_Data;
    /**
     * Constructor method for Ticket_Details_DataType
     * @uses Ticket_Details_DataType::setTicket_Details_Id()
     * @uses Ticket_Details_DataType::setBooking_Date()
     * @uses Ticket_Details_DataType::setCommodity_Code()
     * @uses Ticket_Details_DataType::setComputer_Reservation_System()
     * @uses Ticket_Details_DataType::setCustomer_Code()
     * @uses Ticket_Details_DataType::setDeparture_Tax_Amount()
     * @uses Ticket_Details_DataType::setDomestic_Indicator()
     * @uses Ticket_Details_DataType::setExchange_Fee_Amount()
     * @uses Ticket_Details_DataType::setExchange_Ticket_Indicator()
     * @uses Ticket_Details_DataType::setExchange_Ticket_Amount()
     * @uses Ticket_Details_DataType::setExchange_Ticket_Number()
     * @uses Ticket_Details_DataType::setExchange_Ticket_Number_2()
     * @uses Ticket_Details_DataType::setFare_Block_One()
     * @uses Ticket_Details_DataType::setFare_Block_Two()
     * @uses Ticket_Details_DataType::setFare_Block_Three()
     * @uses Ticket_Details_DataType::setFare_Block_Four()
     * @uses Ticket_Details_DataType::setFare_Calculation_Mode_Indicator()
     * @uses Ticket_Details_DataType::setFinal_Destination_City()
     * @uses Ticket_Details_DataType::setIATA_Client_Code()
     * @uses Ticket_Details_DataType::setInvoice_Date()
     * @uses Ticket_Details_DataType::setIssue_Date()
     * @uses Ticket_Details_DataType::setIssuing_Carrier()
     * @uses Ticket_Details_DataType::setNumber_of_Legs()
     * @uses Ticket_Details_DataType::setOriginal_Issue_Ticket_Number()
     * @uses Ticket_Details_DataType::setPassenger_Name()
     * @uses Ticket_Details_DataType::setPNR_Record_Locator()
     * @uses Ticket_Details_DataType::setRefund_Indicator()
     * @uses Ticket_Details_DataType::setRefund_Number()
     * @uses Ticket_Details_DataType::setRestricted_Ticket_Indicator()
     * @uses Ticket_Details_DataType::setTax_Exempt_Indicator()
     * @uses Ticket_Details_DataType::setTicket_Number()
     * @uses Ticket_Details_DataType::setTicket_Type()
     * @uses Ticket_Details_DataType::setTicket_Routing_Type()
     * @uses Ticket_Details_DataType::setTMC_Client_Account_Number()
     * @uses Ticket_Details_DataType::setTMC_Is_Merchant()
     * @uses Ticket_Details_DataType::setTotal_Fare()
     * @uses Ticket_Details_DataType::setTotal_Fees()
     * @uses Ticket_Details_DataType::setTotal_Tax_Amount()
     * @uses Ticket_Details_DataType::setTravel_Agency_Code()
     * @uses Ticket_Details_DataType::setTravel_Agency_Invoice_Number()
     * @uses Ticket_Details_DataType::setTravel_Agency_Name()
     * @uses Ticket_Details_DataType::setTravel_Agency_Product_Code()
     * @uses Ticket_Details_DataType::setTravel_Authorization_Code()
     * @uses Ticket_Details_DataType::setTrip_Leg_Details_Data()
     * @param string $ticket_Details_Id
     * @param string $booking_Date
     * @param string $commodity_Code
     * @param string $computer_Reservation_System
     * @param string $customer_Code
     * @param float $departure_Tax_Amount
     * @param bool $domestic_Indicator
     * @param float $exchange_Fee_Amount
     * @param bool $exchange_Ticket_Indicator
     * @param float $exchange_Ticket_Amount
     * @param string $exchange_Ticket_Number
     * @param string $exchange_Ticket_Number_2
     * @param string $fare_Block_One
     * @param string $fare_Block_Two
     * @param string $fare_Block_Three
     * @param string $fare_Block_Four
     * @param string $fare_Calculation_Mode_Indicator
     * @param string $final_Destination_City
     * @param string $iATA_Client_Code
     * @param string $invoice_Date
     * @param string $issue_Date
     * @param string $issuing_Carrier
     * @param float $number_of_Legs
     * @param string $original_Issue_Ticket_Number
     * @param string $passenger_Name
     * @param string $pNR_Record_Locator
     * @param bool $refund_Indicator
     * @param string $refund_Number
     * @param bool $restricted_Ticket_Indicator
     * @param bool $tax_Exempt_Indicator
     * @param string $ticket_Number
     * @param string $ticket_Type
     * @param string $ticket_Routing_Type
     * @param string $tMC_Client_Account_Number
     * @param bool $tMC_Is_Merchant
     * @param float $total_Fare
     * @param float $total_Fees
     * @param float $total_Tax_Amount
     * @param string $travel_Agency_Code
     * @param string $travel_Agency_Invoice_Number
     * @param string $travel_Agency_Name
     * @param string $travel_Agency_Product_Code
     * @param string $travel_Authorization_Code
     * @param \StructType\Trip_Leg_Details_DataType[] $trip_Leg_Details_Data
     */
    public function __construct($ticket_Details_Id = null, $booking_Date = null, $commodity_Code = null, $computer_Reservation_System = null, $customer_Code = null, $departure_Tax_Amount = null, $domestic_Indicator = null, $exchange_Fee_Amount = null, $exchange_Ticket_Indicator = null, $exchange_Ticket_Amount = null, $exchange_Ticket_Number = null, $exchange_Ticket_Number_2 = null, $fare_Block_One = null, $fare_Block_Two = null, $fare_Block_Three = null, $fare_Block_Four = null, $fare_Calculation_Mode_Indicator = null, $final_Destination_City = null, $iATA_Client_Code = null, $invoice_Date = null, $issue_Date = null, $issuing_Carrier = null, $number_of_Legs = null, $original_Issue_Ticket_Number = null, $passenger_Name = null, $pNR_Record_Locator = null, $refund_Indicator = null, $refund_Number = null, $restricted_Ticket_Indicator = null, $tax_Exempt_Indicator = null, $ticket_Number = null, $ticket_Type = null, $ticket_Routing_Type = null, $tMC_Client_Account_Number = null, $tMC_Is_Merchant = null, $total_Fare = null, $total_Fees = null, $total_Tax_Amount = null, $travel_Agency_Code = null, $travel_Agency_Invoice_Number = null, $travel_Agency_Name = null, $travel_Agency_Product_Code = null, $travel_Authorization_Code = null, array $trip_Leg_Details_Data = array())
    {
        $this
            ->setTicket_Details_Id($ticket_Details_Id)
            ->setBooking_Date($booking_Date)
            ->setCommodity_Code($commodity_Code)
            ->setComputer_Reservation_System($computer_Reservation_System)
            ->setCustomer_Code($customer_Code)
            ->setDeparture_Tax_Amount($departure_Tax_Amount)
            ->setDomestic_Indicator($domestic_Indicator)
            ->setExchange_Fee_Amount($exchange_Fee_Amount)
            ->setExchange_Ticket_Indicator($exchange_Ticket_Indicator)
            ->setExchange_Ticket_Amount($exchange_Ticket_Amount)
            ->setExchange_Ticket_Number($exchange_Ticket_Number)
            ->setExchange_Ticket_Number_2($exchange_Ticket_Number_2)
            ->setFare_Block_One($fare_Block_One)
            ->setFare_Block_Two($fare_Block_Two)
            ->setFare_Block_Three($fare_Block_Three)
            ->setFare_Block_Four($fare_Block_Four)
            ->setFare_Calculation_Mode_Indicator($fare_Calculation_Mode_Indicator)
            ->setFinal_Destination_City($final_Destination_City)
            ->setIATA_Client_Code($iATA_Client_Code)
            ->setInvoice_Date($invoice_Date)
            ->setIssue_Date($issue_Date)
            ->setIssuing_Carrier($issuing_Carrier)
            ->setNumber_of_Legs($number_of_Legs)
            ->setOriginal_Issue_Ticket_Number($original_Issue_Ticket_Number)
            ->setPassenger_Name($passenger_Name)
            ->setPNR_Record_Locator($pNR_Record_Locator)
            ->setRefund_Indicator($refund_Indicator)
            ->setRefund_Number($refund_Number)
            ->setRestricted_Ticket_Indicator($restricted_Ticket_Indicator)
            ->setTax_Exempt_Indicator($tax_Exempt_Indicator)
            ->setTicket_Number($ticket_Number)
            ->setTicket_Type($ticket_Type)
            ->setTicket_Routing_Type($ticket_Routing_Type)
            ->setTMC_Client_Account_Number($tMC_Client_Account_Number)
            ->setTMC_Is_Merchant($tMC_Is_Merchant)
            ->setTotal_Fare($total_Fare)
            ->setTotal_Fees($total_Fees)
            ->setTotal_Tax_Amount($total_Tax_Amount)
            ->setTravel_Agency_Code($travel_Agency_Code)
            ->setTravel_Agency_Invoice_Number($travel_Agency_Invoice_Number)
            ->setTravel_Agency_Name($travel_Agency_Name)
            ->setTravel_Agency_Product_Code($travel_Agency_Product_Code)
            ->setTravel_Authorization_Code($travel_Authorization_Code)
            ->setTrip_Leg_Details_Data($trip_Leg_Details_Data);
    }
    /**
     * Get Ticket_Details_Id value
     * @return string|null
     */
    public function getTicket_Details_Id()
    {
        return $this->Ticket_Details_Id;
    }
    /**
     * Set Ticket_Details_Id value
     * @param string $ticket_Details_Id
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTicket_Details_Id($ticket_Details_Id = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Details_Id) && !is_string($ticket_Details_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Details_Id, true), gettype($ticket_Details_Id)), __LINE__);
        }
        $this->Ticket_Details_Id = $ticket_Details_Id;
        return $this;
    }
    /**
     * Get Booking_Date value
     * @return string|null
     */
    public function getBooking_Date()
    {
        return $this->Booking_Date;
    }
    /**
     * Set Booking_Date value
     * @param string $booking_Date
     * @return \StructType\Ticket_Details_DataType
     */
    public function setBooking_Date($booking_Date = null)
    {
        // validation for constraint: string
        if (!is_null($booking_Date) && !is_string($booking_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($booking_Date, true), gettype($booking_Date)), __LINE__);
        }
        $this->Booking_Date = $booking_Date;
        return $this;
    }
    /**
     * Get Commodity_Code value
     * @return string|null
     */
    public function getCommodity_Code()
    {
        return $this->Commodity_Code;
    }
    /**
     * Set Commodity_Code value
     * @param string $commodity_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setCommodity_Code($commodity_Code = null)
    {
        // validation for constraint: string
        if (!is_null($commodity_Code) && !is_string($commodity_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodity_Code, true), gettype($commodity_Code)), __LINE__);
        }
        $this->Commodity_Code = $commodity_Code;
        return $this;
    }
    /**
     * Get Computer_Reservation_System value
     * @return string|null
     */
    public function getComputer_Reservation_System()
    {
        return $this->Computer_Reservation_System;
    }
    /**
     * Set Computer_Reservation_System value
     * @param string $computer_Reservation_System
     * @return \StructType\Ticket_Details_DataType
     */
    public function setComputer_Reservation_System($computer_Reservation_System = null)
    {
        // validation for constraint: string
        if (!is_null($computer_Reservation_System) && !is_string($computer_Reservation_System)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($computer_Reservation_System, true), gettype($computer_Reservation_System)), __LINE__);
        }
        $this->Computer_Reservation_System = $computer_Reservation_System;
        return $this;
    }
    /**
     * Get Customer_Code value
     * @return string|null
     */
    public function getCustomer_Code()
    {
        return $this->Customer_Code;
    }
    /**
     * Set Customer_Code value
     * @param string $customer_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setCustomer_Code($customer_Code = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Code) && !is_string($customer_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Code, true), gettype($customer_Code)), __LINE__);
        }
        $this->Customer_Code = $customer_Code;
        return $this;
    }
    /**
     * Get Departure_Tax_Amount value
     * @return float|null
     */
    public function getDeparture_Tax_Amount()
    {
        return $this->Departure_Tax_Amount;
    }
    /**
     * Set Departure_Tax_Amount value
     * @param float $departure_Tax_Amount
     * @return \StructType\Ticket_Details_DataType
     */
    public function setDeparture_Tax_Amount($departure_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($departure_Tax_Amount) && !(is_float($departure_Tax_Amount) || is_numeric($departure_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($departure_Tax_Amount, true), gettype($departure_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($departure_Tax_Amount) && mb_strlen(mb_substr($departure_Tax_Amount, false !== mb_strpos($departure_Tax_Amount, '.') ? mb_strpos($departure_Tax_Amount, '.') + 1 : mb_strlen($departure_Tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($departure_Tax_Amount, true), mb_strlen(mb_substr($departure_Tax_Amount, mb_strpos($departure_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($departure_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $departure_Tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($departure_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $departure_Tax_Amount))), __LINE__);
        }
        $this->Departure_Tax_Amount = $departure_Tax_Amount;
        return $this;
    }
    /**
     * Get Domestic_Indicator value
     * @return bool|null
     */
    public function getDomestic_Indicator()
    {
        return $this->Domestic_Indicator;
    }
    /**
     * Set Domestic_Indicator value
     * @param bool $domestic_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setDomestic_Indicator($domestic_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($domestic_Indicator) && !is_bool($domestic_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($domestic_Indicator, true), gettype($domestic_Indicator)), __LINE__);
        }
        $this->Domestic_Indicator = $domestic_Indicator;
        return $this;
    }
    /**
     * Get Exchange_Fee_Amount value
     * @return float|null
     */
    public function getExchange_Fee_Amount()
    {
        return $this->Exchange_Fee_Amount;
    }
    /**
     * Set Exchange_Fee_Amount value
     * @param float $exchange_Fee_Amount
     * @return \StructType\Ticket_Details_DataType
     */
    public function setExchange_Fee_Amount($exchange_Fee_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($exchange_Fee_Amount) && !(is_float($exchange_Fee_Amount) || is_numeric($exchange_Fee_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchange_Fee_Amount, true), gettype($exchange_Fee_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($exchange_Fee_Amount) && mb_strlen(mb_substr($exchange_Fee_Amount, false !== mb_strpos($exchange_Fee_Amount, '.') ? mb_strpos($exchange_Fee_Amount, '.') + 1 : mb_strlen($exchange_Fee_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($exchange_Fee_Amount, true), mb_strlen(mb_substr($exchange_Fee_Amount, mb_strpos($exchange_Fee_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($exchange_Fee_Amount) && mb_strlen(preg_replace('/(\D)/', '', $exchange_Fee_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($exchange_Fee_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $exchange_Fee_Amount))), __LINE__);
        }
        $this->Exchange_Fee_Amount = $exchange_Fee_Amount;
        return $this;
    }
    /**
     * Get Exchange_Ticket_Indicator value
     * @return bool|null
     */
    public function getExchange_Ticket_Indicator()
    {
        return $this->Exchange_Ticket_Indicator;
    }
    /**
     * Set Exchange_Ticket_Indicator value
     * @param bool $exchange_Ticket_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setExchange_Ticket_Indicator($exchange_Ticket_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchange_Ticket_Indicator) && !is_bool($exchange_Ticket_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchange_Ticket_Indicator, true), gettype($exchange_Ticket_Indicator)), __LINE__);
        }
        $this->Exchange_Ticket_Indicator = $exchange_Ticket_Indicator;
        return $this;
    }
    /**
     * Get Exchange_Ticket_Amount value
     * @return float|null
     */
    public function getExchange_Ticket_Amount()
    {
        return $this->Exchange_Ticket_Amount;
    }
    /**
     * Set Exchange_Ticket_Amount value
     * @param float $exchange_Ticket_Amount
     * @return \StructType\Ticket_Details_DataType
     */
    public function setExchange_Ticket_Amount($exchange_Ticket_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($exchange_Ticket_Amount) && !(is_float($exchange_Ticket_Amount) || is_numeric($exchange_Ticket_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchange_Ticket_Amount, true), gettype($exchange_Ticket_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($exchange_Ticket_Amount) && mb_strlen(mb_substr($exchange_Ticket_Amount, false !== mb_strpos($exchange_Ticket_Amount, '.') ? mb_strpos($exchange_Ticket_Amount, '.') + 1 : mb_strlen($exchange_Ticket_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($exchange_Ticket_Amount, true), mb_strlen(mb_substr($exchange_Ticket_Amount, mb_strpos($exchange_Ticket_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($exchange_Ticket_Amount) && mb_strlen(preg_replace('/(\D)/', '', $exchange_Ticket_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($exchange_Ticket_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $exchange_Ticket_Amount))), __LINE__);
        }
        $this->Exchange_Ticket_Amount = $exchange_Ticket_Amount;
        return $this;
    }
    /**
     * Get Exchange_Ticket_Number value
     * @return string|null
     */
    public function getExchange_Ticket_Number()
    {
        return $this->Exchange_Ticket_Number;
    }
    /**
     * Set Exchange_Ticket_Number value
     * @param string $exchange_Ticket_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setExchange_Ticket_Number($exchange_Ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($exchange_Ticket_Number) && !is_string($exchange_Ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchange_Ticket_Number, true), gettype($exchange_Ticket_Number)), __LINE__);
        }
        $this->Exchange_Ticket_Number = $exchange_Ticket_Number;
        return $this;
    }
    /**
     * Get Exchange_Ticket_Number value
     * @return string|null
     */
    public function getExchange_Ticket_Number_2()
    {
        return $this->Exchange_Ticket_Number_2;
    }
    /**
     * Set Exchange_Ticket_Number value
     * @param string $exchange_Ticket_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setExchange_Ticket_Number_2($exchange_Ticket_Number_2 = null)
    {
        // validation for constraint: string
        if (!is_null($exchange_Ticket_Number_2) && !is_string($exchange_Ticket_Number_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchange_Ticket_Number_2, true), gettype($exchange_Ticket_Number_2)), __LINE__);
        }
        $this->Exchange_Ticket_Number_2 = $exchange_Ticket_Number_2;
        return $this;
    }
    /**
     * Get Fare_Block_One value
     * @return string|null
     */
    public function getFare_Block_One()
    {
        return $this->Fare_Block_One;
    }
    /**
     * Set Fare_Block_One value
     * @param string $fare_Block_One
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFare_Block_One($fare_Block_One = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Block_One) && !is_string($fare_Block_One)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Block_One, true), gettype($fare_Block_One)), __LINE__);
        }
        $this->Fare_Block_One = $fare_Block_One;
        return $this;
    }
    /**
     * Get Fare_Block_Two value
     * @return string|null
     */
    public function getFare_Block_Two()
    {
        return $this->Fare_Block_Two;
    }
    /**
     * Set Fare_Block_Two value
     * @param string $fare_Block_Two
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFare_Block_Two($fare_Block_Two = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Block_Two) && !is_string($fare_Block_Two)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Block_Two, true), gettype($fare_Block_Two)), __LINE__);
        }
        $this->Fare_Block_Two = $fare_Block_Two;
        return $this;
    }
    /**
     * Get Fare_Block_Three value
     * @return string|null
     */
    public function getFare_Block_Three()
    {
        return $this->Fare_Block_Three;
    }
    /**
     * Set Fare_Block_Three value
     * @param string $fare_Block_Three
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFare_Block_Three($fare_Block_Three = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Block_Three) && !is_string($fare_Block_Three)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Block_Three, true), gettype($fare_Block_Three)), __LINE__);
        }
        $this->Fare_Block_Three = $fare_Block_Three;
        return $this;
    }
    /**
     * Get Fare_Block_Four value
     * @return string|null
     */
    public function getFare_Block_Four()
    {
        return $this->Fare_Block_Four;
    }
    /**
     * Set Fare_Block_Four value
     * @param string $fare_Block_Four
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFare_Block_Four($fare_Block_Four = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Block_Four) && !is_string($fare_Block_Four)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Block_Four, true), gettype($fare_Block_Four)), __LINE__);
        }
        $this->Fare_Block_Four = $fare_Block_Four;
        return $this;
    }
    /**
     * Get Fare_Calculation_Mode_Indicator value
     * @return string|null
     */
    public function getFare_Calculation_Mode_Indicator()
    {
        return $this->Fare_Calculation_Mode_Indicator;
    }
    /**
     * Set Fare_Calculation_Mode_Indicator value
     * @param string $fare_Calculation_Mode_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFare_Calculation_Mode_Indicator($fare_Calculation_Mode_Indicator = null)
    {
        // validation for constraint: string
        if (!is_null($fare_Calculation_Mode_Indicator) && !is_string($fare_Calculation_Mode_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fare_Calculation_Mode_Indicator, true), gettype($fare_Calculation_Mode_Indicator)), __LINE__);
        }
        $this->Fare_Calculation_Mode_Indicator = $fare_Calculation_Mode_Indicator;
        return $this;
    }
    /**
     * Get Final_Destination_City value
     * @return string|null
     */
    public function getFinal_Destination_City()
    {
        return $this->Final_Destination_City;
    }
    /**
     * Set Final_Destination_City value
     * @param string $final_Destination_City
     * @return \StructType\Ticket_Details_DataType
     */
    public function setFinal_Destination_City($final_Destination_City = null)
    {
        // validation for constraint: string
        if (!is_null($final_Destination_City) && !is_string($final_Destination_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($final_Destination_City, true), gettype($final_Destination_City)), __LINE__);
        }
        $this->Final_Destination_City = $final_Destination_City;
        return $this;
    }
    /**
     * Get IATA_Client_Code value
     * @return string|null
     */
    public function getIATA_Client_Code()
    {
        return $this->IATA_Client_Code;
    }
    /**
     * Set IATA_Client_Code value
     * @param string $iATA_Client_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setIATA_Client_Code($iATA_Client_Code = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_Client_Code) && !is_string($iATA_Client_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_Client_Code, true), gettype($iATA_Client_Code)), __LINE__);
        }
        $this->IATA_Client_Code = $iATA_Client_Code;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Ticket_Details_DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Issue_Date value
     * @return string|null
     */
    public function getIssue_Date()
    {
        return $this->Issue_Date;
    }
    /**
     * Set Issue_Date value
     * @param string $issue_Date
     * @return \StructType\Ticket_Details_DataType
     */
    public function setIssue_Date($issue_Date = null)
    {
        // validation for constraint: string
        if (!is_null($issue_Date) && !is_string($issue_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issue_Date, true), gettype($issue_Date)), __LINE__);
        }
        $this->Issue_Date = $issue_Date;
        return $this;
    }
    /**
     * Get Issuing_Carrier value
     * @return string|null
     */
    public function getIssuing_Carrier()
    {
        return $this->Issuing_Carrier;
    }
    /**
     * Set Issuing_Carrier value
     * @param string $issuing_Carrier
     * @return \StructType\Ticket_Details_DataType
     */
    public function setIssuing_Carrier($issuing_Carrier = null)
    {
        // validation for constraint: string
        if (!is_null($issuing_Carrier) && !is_string($issuing_Carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuing_Carrier, true), gettype($issuing_Carrier)), __LINE__);
        }
        $this->Issuing_Carrier = $issuing_Carrier;
        return $this;
    }
    /**
     * Get Number_of_Legs value
     * @return float|null
     */
    public function getNumber_of_Legs()
    {
        return $this->Number_of_Legs;
    }
    /**
     * Set Number_of_Legs value
     * @param float $number_of_Legs
     * @return \StructType\Ticket_Details_DataType
     */
    public function setNumber_of_Legs($number_of_Legs = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Legs) && !(is_float($number_of_Legs) || is_numeric($number_of_Legs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Legs, true), gettype($number_of_Legs)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Legs) && mb_strlen(mb_substr($number_of_Legs, false !== mb_strpos($number_of_Legs, '.') ? mb_strpos($number_of_Legs, '.') + 1 : mb_strlen($number_of_Legs))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Legs, true), mb_strlen(mb_substr($number_of_Legs, mb_strpos($number_of_Legs, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Legs) && $number_of_Legs < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Legs, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($number_of_Legs) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Legs)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($number_of_Legs, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Legs))), __LINE__);
        }
        $this->Number_of_Legs = $number_of_Legs;
        return $this;
    }
    /**
     * Get Original_Issue_Ticket_Number value
     * @return string|null
     */
    public function getOriginal_Issue_Ticket_Number()
    {
        return $this->Original_Issue_Ticket_Number;
    }
    /**
     * Set Original_Issue_Ticket_Number value
     * @param string $original_Issue_Ticket_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setOriginal_Issue_Ticket_Number($original_Issue_Ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($original_Issue_Ticket_Number) && !is_string($original_Issue_Ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($original_Issue_Ticket_Number, true), gettype($original_Issue_Ticket_Number)), __LINE__);
        }
        $this->Original_Issue_Ticket_Number = $original_Issue_Ticket_Number;
        return $this;
    }
    /**
     * Get Passenger_Name value
     * @return string|null
     */
    public function getPassenger_Name()
    {
        return $this->Passenger_Name;
    }
    /**
     * Set Passenger_Name value
     * @param string $passenger_Name
     * @return \StructType\Ticket_Details_DataType
     */
    public function setPassenger_Name($passenger_Name = null)
    {
        // validation for constraint: string
        if (!is_null($passenger_Name) && !is_string($passenger_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passenger_Name, true), gettype($passenger_Name)), __LINE__);
        }
        $this->Passenger_Name = $passenger_Name;
        return $this;
    }
    /**
     * Get PNR_Record_Locator value
     * @return string|null
     */
    public function getPNR_Record_Locator()
    {
        return $this->PNR_Record_Locator;
    }
    /**
     * Set PNR_Record_Locator value
     * @param string $pNR_Record_Locator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setPNR_Record_Locator($pNR_Record_Locator = null)
    {
        // validation for constraint: string
        if (!is_null($pNR_Record_Locator) && !is_string($pNR_Record_Locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pNR_Record_Locator, true), gettype($pNR_Record_Locator)), __LINE__);
        }
        $this->PNR_Record_Locator = $pNR_Record_Locator;
        return $this;
    }
    /**
     * Get Refund_Indicator value
     * @return bool|null
     */
    public function getRefund_Indicator()
    {
        return $this->Refund_Indicator;
    }
    /**
     * Set Refund_Indicator value
     * @param bool $refund_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setRefund_Indicator($refund_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($refund_Indicator) && !is_bool($refund_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refund_Indicator, true), gettype($refund_Indicator)), __LINE__);
        }
        $this->Refund_Indicator = $refund_Indicator;
        return $this;
    }
    /**
     * Get Refund_Number value
     * @return string|null
     */
    public function getRefund_Number()
    {
        return $this->Refund_Number;
    }
    /**
     * Set Refund_Number value
     * @param string $refund_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setRefund_Number($refund_Number = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Number) && !is_string($refund_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Number, true), gettype($refund_Number)), __LINE__);
        }
        $this->Refund_Number = $refund_Number;
        return $this;
    }
    /**
     * Get Restricted_Ticket_Indicator value
     * @return bool|null
     */
    public function getRestricted_Ticket_Indicator()
    {
        return $this->Restricted_Ticket_Indicator;
    }
    /**
     * Set Restricted_Ticket_Indicator value
     * @param bool $restricted_Ticket_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setRestricted_Ticket_Indicator($restricted_Ticket_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restricted_Ticket_Indicator) && !is_bool($restricted_Ticket_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restricted_Ticket_Indicator, true), gettype($restricted_Ticket_Indicator)), __LINE__);
        }
        $this->Restricted_Ticket_Indicator = $restricted_Ticket_Indicator;
        return $this;
    }
    /**
     * Get Tax_Exempt_Indicator value
     * @return bool|null
     */
    public function getTax_Exempt_Indicator()
    {
        return $this->Tax_Exempt_Indicator;
    }
    /**
     * Set Tax_Exempt_Indicator value
     * @param bool $tax_Exempt_Indicator
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTax_Exempt_Indicator($tax_Exempt_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($tax_Exempt_Indicator) && !is_bool($tax_Exempt_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tax_Exempt_Indicator, true), gettype($tax_Exempt_Indicator)), __LINE__);
        }
        $this->Tax_Exempt_Indicator = $tax_Exempt_Indicator;
        return $this;
    }
    /**
     * Get Ticket_Number value
     * @return string|null
     */
    public function getTicket_Number()
    {
        return $this->Ticket_Number;
    }
    /**
     * Set Ticket_Number value
     * @param string $ticket_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTicket_Number($ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Number) && !is_string($ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Number, true), gettype($ticket_Number)), __LINE__);
        }
        $this->Ticket_Number = $ticket_Number;
        return $this;
    }
    /**
     * Get Ticket_Type value
     * @return string|null
     */
    public function getTicket_Type()
    {
        return $this->Ticket_Type;
    }
    /**
     * Set Ticket_Type value
     * @param string $ticket_Type
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTicket_Type($ticket_Type = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Type) && !is_string($ticket_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Type, true), gettype($ticket_Type)), __LINE__);
        }
        $this->Ticket_Type = $ticket_Type;
        return $this;
    }
    /**
     * Get Ticket_Routing_Type value
     * @return string|null
     */
    public function getTicket_Routing_Type()
    {
        return $this->Ticket_Routing_Type;
    }
    /**
     * Set Ticket_Routing_Type value
     * @param string $ticket_Routing_Type
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTicket_Routing_Type($ticket_Routing_Type = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Routing_Type) && !is_string($ticket_Routing_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Routing_Type, true), gettype($ticket_Routing_Type)), __LINE__);
        }
        $this->Ticket_Routing_Type = $ticket_Routing_Type;
        return $this;
    }
    /**
     * Get TMC_Client_Account_Number value
     * @return string|null
     */
    public function getTMC_Client_Account_Number()
    {
        return $this->TMC_Client_Account_Number;
    }
    /**
     * Set TMC_Client_Account_Number value
     * @param string $tMC_Client_Account_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTMC_Client_Account_Number($tMC_Client_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($tMC_Client_Account_Number) && !is_string($tMC_Client_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tMC_Client_Account_Number, true), gettype($tMC_Client_Account_Number)), __LINE__);
        }
        $this->TMC_Client_Account_Number = $tMC_Client_Account_Number;
        return $this;
    }
    /**
     * Get TMC_Is_Merchant value
     * @return bool|null
     */
    public function getTMC_Is_Merchant()
    {
        return $this->TMC_Is_Merchant;
    }
    /**
     * Set TMC_Is_Merchant value
     * @param bool $tMC_Is_Merchant
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTMC_Is_Merchant($tMC_Is_Merchant = null)
    {
        // validation for constraint: boolean
        if (!is_null($tMC_Is_Merchant) && !is_bool($tMC_Is_Merchant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tMC_Is_Merchant, true), gettype($tMC_Is_Merchant)), __LINE__);
        }
        $this->TMC_Is_Merchant = $tMC_Is_Merchant;
        return $this;
    }
    /**
     * Get Total_Fare value
     * @return float|null
     */
    public function getTotal_Fare()
    {
        return $this->Total_Fare;
    }
    /**
     * Set Total_Fare value
     * @param float $total_Fare
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTotal_Fare($total_Fare = null)
    {
        // validation for constraint: float
        if (!is_null($total_Fare) && !(is_float($total_Fare) || is_numeric($total_Fare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Fare, true), gettype($total_Fare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($total_Fare) && mb_strlen(mb_substr($total_Fare, false !== mb_strpos($total_Fare, '.') ? mb_strpos($total_Fare, '.') + 1 : mb_strlen($total_Fare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($total_Fare, true), mb_strlen(mb_substr($total_Fare, mb_strpos($total_Fare, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($total_Fare) && mb_strlen(preg_replace('/(\D)/', '', $total_Fare)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($total_Fare, true), mb_strlen(preg_replace('/(\D)/', '', $total_Fare))), __LINE__);
        }
        $this->Total_Fare = $total_Fare;
        return $this;
    }
    /**
     * Get Total_Fees value
     * @return float|null
     */
    public function getTotal_Fees()
    {
        return $this->Total_Fees;
    }
    /**
     * Set Total_Fees value
     * @param float $total_Fees
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTotal_Fees($total_Fees = null)
    {
        // validation for constraint: float
        if (!is_null($total_Fees) && !(is_float($total_Fees) || is_numeric($total_Fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Fees, true), gettype($total_Fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($total_Fees) && mb_strlen(mb_substr($total_Fees, false !== mb_strpos($total_Fees, '.') ? mb_strpos($total_Fees, '.') + 1 : mb_strlen($total_Fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($total_Fees, true), mb_strlen(mb_substr($total_Fees, mb_strpos($total_Fees, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($total_Fees) && mb_strlen(preg_replace('/(\D)/', '', $total_Fees)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($total_Fees, true), mb_strlen(preg_replace('/(\D)/', '', $total_Fees))), __LINE__);
        }
        $this->Total_Fees = $total_Fees;
        return $this;
    }
    /**
     * Get Total_Tax_Amount value
     * @return float|null
     */
    public function getTotal_Tax_Amount()
    {
        return $this->Total_Tax_Amount;
    }
    /**
     * Set Total_Tax_Amount value
     * @param float $total_Tax_Amount
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTotal_Tax_Amount($total_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Tax_Amount) && !(is_float($total_Tax_Amount) || is_numeric($total_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Tax_Amount, true), gettype($total_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($total_Tax_Amount) && mb_strlen(mb_substr($total_Tax_Amount, false !== mb_strpos($total_Tax_Amount, '.') ? mb_strpos($total_Tax_Amount, '.') + 1 : mb_strlen($total_Tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($total_Tax_Amount, true), mb_strlen(mb_substr($total_Tax_Amount, mb_strpos($total_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($total_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($total_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Tax_Amount))), __LINE__);
        }
        $this->Total_Tax_Amount = $total_Tax_Amount;
        return $this;
    }
    /**
     * Get Travel_Agency_Code value
     * @return string|null
     */
    public function getTravel_Agency_Code()
    {
        return $this->Travel_Agency_Code;
    }
    /**
     * Set Travel_Agency_Code value
     * @param string $travel_Agency_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTravel_Agency_Code($travel_Agency_Code = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Agency_Code) && !is_string($travel_Agency_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Agency_Code, true), gettype($travel_Agency_Code)), __LINE__);
        }
        $this->Travel_Agency_Code = $travel_Agency_Code;
        return $this;
    }
    /**
     * Get Travel_Agency_Invoice_Number value
     * @return string|null
     */
    public function getTravel_Agency_Invoice_Number()
    {
        return $this->Travel_Agency_Invoice_Number;
    }
    /**
     * Set Travel_Agency_Invoice_Number value
     * @param string $travel_Agency_Invoice_Number
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTravel_Agency_Invoice_Number($travel_Agency_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Agency_Invoice_Number) && !is_string($travel_Agency_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Agency_Invoice_Number, true), gettype($travel_Agency_Invoice_Number)), __LINE__);
        }
        $this->Travel_Agency_Invoice_Number = $travel_Agency_Invoice_Number;
        return $this;
    }
    /**
     * Get Travel_Agency_Name value
     * @return string|null
     */
    public function getTravel_Agency_Name()
    {
        return $this->Travel_Agency_Name;
    }
    /**
     * Set Travel_Agency_Name value
     * @param string $travel_Agency_Name
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTravel_Agency_Name($travel_Agency_Name = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Agency_Name) && !is_string($travel_Agency_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Agency_Name, true), gettype($travel_Agency_Name)), __LINE__);
        }
        $this->Travel_Agency_Name = $travel_Agency_Name;
        return $this;
    }
    /**
     * Get Travel_Agency_Product_Code value
     * @return string|null
     */
    public function getTravel_Agency_Product_Code()
    {
        return $this->Travel_Agency_Product_Code;
    }
    /**
     * Set Travel_Agency_Product_Code value
     * @param string $travel_Agency_Product_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTravel_Agency_Product_Code($travel_Agency_Product_Code = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Agency_Product_Code) && !is_string($travel_Agency_Product_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Agency_Product_Code, true), gettype($travel_Agency_Product_Code)), __LINE__);
        }
        $this->Travel_Agency_Product_Code = $travel_Agency_Product_Code;
        return $this;
    }
    /**
     * Get Travel_Authorization_Code value
     * @return string|null
     */
    public function getTravel_Authorization_Code()
    {
        return $this->Travel_Authorization_Code;
    }
    /**
     * Set Travel_Authorization_Code value
     * @param string $travel_Authorization_Code
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTravel_Authorization_Code($travel_Authorization_Code = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Authorization_Code) && !is_string($travel_Authorization_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Authorization_Code, true), gettype($travel_Authorization_Code)), __LINE__);
        }
        $this->Travel_Authorization_Code = $travel_Authorization_Code;
        return $this;
    }
    /**
     * Get Trip_Leg_Details_Data value
     * @return \StructType\Trip_Leg_Details_DataType[]|null
     */
    public function getTrip_Leg_Details_Data()
    {
        return $this->Trip_Leg_Details_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTrip_Leg_Details_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrip_Leg_Details_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrip_Leg_Details_DataForArrayConstraintsFromSetTrip_Leg_Details_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticket_Details_DataTypeTrip_Leg_Details_DataItem) {
            // validation for constraint: itemType
            if (!$ticket_Details_DataTypeTrip_Leg_Details_DataItem instanceof \StructType\Trip_Leg_Details_DataType) {
                $invalidValues[] = is_object($ticket_Details_DataTypeTrip_Leg_Details_DataItem) ? get_class($ticket_Details_DataTypeTrip_Leg_Details_DataItem) : sprintf('%s(%s)', gettype($ticket_Details_DataTypeTrip_Leg_Details_DataItem), var_export($ticket_Details_DataTypeTrip_Leg_Details_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Trip_Leg_Details_Data property can only contain items of type \StructType\Trip_Leg_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Trip_Leg_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Trip_Leg_Details_DataType[] $trip_Leg_Details_Data
     * @return \StructType\Ticket_Details_DataType
     */
    public function setTrip_Leg_Details_Data(array $trip_Leg_Details_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($trip_Leg_Details_DataArrayErrorMessage = self::validateTrip_Leg_Details_DataForArrayConstraintsFromSetTrip_Leg_Details_Data($trip_Leg_Details_Data))) {
            throw new \InvalidArgumentException($trip_Leg_Details_DataArrayErrorMessage, __LINE__);
        }
        $this->Trip_Leg_Details_Data = $trip_Leg_Details_Data;
        return $this;
    }
    /**
     * Add item to Trip_Leg_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Trip_Leg_Details_DataType $item
     * @return \StructType\Ticket_Details_DataType
     */
    public function addToTrip_Leg_Details_Data(\StructType\Trip_Leg_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Trip_Leg_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Trip_Leg_Details_Data property can only contain items of type \StructType\Trip_Leg_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Trip_Leg_Details_Data[] = $item;
        return $this;
    }
}
