<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Lease_Amendment_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Supplier Contract Lease Amendment Request
 * @subpackage Structs
 */
class Supplier_Contract_Lease_Amendment_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Lease_Amendment
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Lease Amendment
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Lease_AmendmentType[]
     */
    public $Supplier_Contract_Lease_Amendment;
    /**
     * Constructor method for Supplier_Contract_Lease_Amendment_Response_DataType
     * @uses Supplier_Contract_Lease_Amendment_Response_DataType::setSupplier_Contract_Lease_Amendment()
     * @param \StructType\Supplier_Contract_Lease_AmendmentType[] $supplier_Contract_Lease_Amendment
     */
    public function __construct(array $supplier_Contract_Lease_Amendment = array())
    {
        $this
            ->setSupplier_Contract_Lease_Amendment($supplier_Contract_Lease_Amendment);
    }
    /**
     * Get Supplier_Contract_Lease_Amendment value
     * @return \StructType\Supplier_Contract_Lease_AmendmentType[]|null
     */
    public function getSupplier_Contract_Lease_Amendment()
    {
        return $this->Supplier_Contract_Lease_Amendment;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Lease_Amendment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Lease_Amendment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Lease_AmendmentForArrayConstraintsFromSetSupplier_Contract_Lease_Amendment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem instanceof \StructType\Supplier_Contract_Lease_AmendmentType) {
                $invalidValues[] = is_object($supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem) ? get_class($supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem) : sprintf('%s(%s)', gettype($supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem), var_export($supplier_Contract_Lease_Amendment_Response_DataTypeSupplier_Contract_Lease_AmendmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Lease_Amendment property can only contain items of type \StructType\Supplier_Contract_Lease_AmendmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Lease_Amendment value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Lease_AmendmentType[] $supplier_Contract_Lease_Amendment
     * @return \StructType\Supplier_Contract_Lease_Amendment_Response_DataType
     */
    public function setSupplier_Contract_Lease_Amendment(array $supplier_Contract_Lease_Amendment = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Lease_AmendmentArrayErrorMessage = self::validateSupplier_Contract_Lease_AmendmentForArrayConstraintsFromSetSupplier_Contract_Lease_Amendment($supplier_Contract_Lease_Amendment))) {
            throw new \InvalidArgumentException($supplier_Contract_Lease_AmendmentArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Lease_Amendment = $supplier_Contract_Lease_Amendment;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Lease_Amendment value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Lease_AmendmentType $item
     * @return \StructType\Supplier_Contract_Lease_Amendment_Response_DataType
     */
    public function addToSupplier_Contract_Lease_Amendment(\StructType\Supplier_Contract_Lease_AmendmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Lease_AmendmentType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Lease_Amendment property can only contain items of type \StructType\Supplier_Contract_Lease_AmendmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Lease_Amendment[] = $item;
        return $this;
    }
}
