<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Report Reference element contains the specific instance set containing the requested Expense Report. The ID is the value and the Type attribute is either the Lookup ID type or the Workday ID (GUID) for the instance of Expense
 * Report.
 * @subpackage Structs
 */
class Receivable_Repayment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Receivable_Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Expense Report object.
     * - maxOccurs: unbounded
     * @var \StructType\Receivable_RepaymentObjectType[]
     */
    public $Receivable_Repayment_Reference;
    /**
     * Constructor method for Receivable_Repayment_Request_ReferencesType
     * @uses Receivable_Repayment_Request_ReferencesType::setReceivable_Repayment_Reference()
     * @param \StructType\Receivable_RepaymentObjectType[] $receivable_Repayment_Reference
     */
    public function __construct(array $receivable_Repayment_Reference = array())
    {
        $this
            ->setReceivable_Repayment_Reference($receivable_Repayment_Reference);
    }
    /**
     * Get Receivable_Repayment_Reference value
     * @return \StructType\Receivable_RepaymentObjectType[]|null
     */
    public function getReceivable_Repayment_Reference()
    {
        return $this->Receivable_Repayment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceivable_Repayment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceivable_Repayment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceivable_Repayment_ReferenceForArrayConstraintsFromSetReceivable_Repayment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem instanceof \StructType\Receivable_RepaymentObjectType) {
                $invalidValues[] = is_object($receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem) ? get_class($receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem), var_export($receivable_Repayment_Request_ReferencesTypeReceivable_Repayment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receivable_Repayment_Reference property can only contain items of type \StructType\Receivable_RepaymentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receivable_Repayment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_RepaymentObjectType[] $receivable_Repayment_Reference
     * @return \StructType\Receivable_Repayment_Request_ReferencesType
     */
    public function setReceivable_Repayment_Reference(array $receivable_Repayment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receivable_Repayment_ReferenceArrayErrorMessage = self::validateReceivable_Repayment_ReferenceForArrayConstraintsFromSetReceivable_Repayment_Reference($receivable_Repayment_Reference))) {
            throw new \InvalidArgumentException($receivable_Repayment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receivable_Repayment_Reference = $receivable_Repayment_Reference;
        return $this;
    }
    /**
     * Add item to Receivable_Repayment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_RepaymentObjectType $item
     * @return \StructType\Receivable_Repayment_Request_ReferencesType
     */
    public function addToReceivable_Repayment_Reference(\StructType\Receivable_RepaymentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receivable_RepaymentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receivable_Repayment_Reference property can only contain items of type \StructType\Receivable_RepaymentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receivable_Repayment_Reference[] = $item;
        return $this;
    }
}
