<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Plan_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Put operation.
 * @subpackage Structs
 */
class Put_Project_Plan_RequestType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Reference
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: This is wrapper element for project plan data
     * - minOccurs: 0
     * @var \StructType\Project_Plan_DataType
     */
    public $Project_Plan_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: A Condition Rule cannot already exist for the Reference or Description if the "Add Only" element is TRUE.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Plan_RequestType
     * @uses Put_Project_Plan_RequestType::setProject_Reference()
     * @uses Put_Project_Plan_RequestType::setProject_Plan_Data()
     * @uses Put_Project_Plan_RequestType::setAdd_Only()
     * @uses Put_Project_Plan_RequestType::setVersion()
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Project_Plan_DataType $project_Plan_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\ProjectObjectType $project_Reference = null, \StructType\Project_Plan_DataType $project_Plan_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setProject_Plan_Data($project_Plan_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Put_Project_Plan_RequestType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Data value
     * @return \StructType\Project_Plan_DataType|null
     */
    public function getProject_Plan_Data()
    {
        return $this->Project_Plan_Data;
    }
    /**
     * Set Project_Plan_Data value
     * @param \StructType\Project_Plan_DataType $project_Plan_Data
     * @return \StructType\Put_Project_Plan_RequestType
     */
    public function setProject_Plan_Data(\StructType\Project_Plan_DataType $project_Plan_Data = null)
    {
        $this->Project_Plan_Data = $project_Plan_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Plan_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Plan_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
