<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This validation prevents entering a customer contract template without project lines. | Confirms that the default related worktags are valid for use with the company. | Added Validation to check the balancing worktag is valid to use
 * with the company. | Added Validation to check the optional balancing worktags are valid to use with the company. | Added validation to require the user to specify a value for Optional Balancing Worktags that were set as Default Required. | Added
 * validation to check that a project template cannot be marked with an optional balancing worktag of type Project. | Added a new validation to recommend that workers should remove the reference to a worktag to delete it instead of selecting the Delete
 * option. | Added new validation to prevent entries to fields other than Default Worktags. | Added validation to check that a project template cannot have 2 Optional Balancing Worktags of the same Worktag Type. | Added validation to check that the
 * Optional Balancing Worktag types are among the allowed Worktag Types specified by the Maintain Worktag Balancing Configuration task. | Added a validation to check that the Optional Balancing Worktag can only be entered for a capital project template
 * if the tenant is configured for optional balancing worktags. | Specify a value in the worktag balancing field only if worktag balancing is configured and the project is a capital project. | Specify a percentage between 0 and 100. | Select just 1
 * worktag for each type on each document line. | Contains the detailed information about a project template.
 * @subpackage Structs
 */
class Project_Template_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Contains a unique identifier for an instance of project template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Template_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the project template.
     * - maxOccurs: 1
     * @var string
     */
    public $Template_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description details related to the project template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Percent_Complete
     * Meta information extracted from the WSDL
     * - documentation: The percent complete for the project plan template. | The percent complete for the project template. | Decimal value for Proposed Percent Complete of the Project Task selected. This value can be set via the Timesheet under certain
     * condition and is then copied to the Project Task on Approval of the Timesheet. | The value for Percent Complete Proposed can only be set where the Task is not 100% already on the Project and that Task is directly assigned to the worker. | Proposed
     * Percent Complete Complete cannot be greater than 100%. Percent complete is in decimal format value can not be greater than 1.00. | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Complete;
    /**
     * The Risk_Level_Reference
     * Meta information extracted from the WSDL
     * - documentation: The risk level for the project template.
     * - minOccurs: 0
     * @var \StructType\Risk_LevelObjectType
     */
    public $Risk_Level_Reference;
    /**
     * The Problem_Statement
     * Meta information extracted from the WSDL
     * - documentation: Problem Statement details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Problem_Statement;
    /**
     * The Objective
     * Meta information extracted from the WSDL
     * - documentation: Project Objective details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Objective;
    /**
     * The In_Scope
     * Meta information extracted from the WSDL
     * - documentation: In Scope details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Scope;
    /**
     * The Out_of_Scope
     * Meta information extracted from the WSDL
     * - documentation: Out of Scope details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Out_of_Scope;
    /**
     * The Measures_of_Success
     * Meta information extracted from the WSDL
     * - documentation: Measures of Success details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Measures_of_Success;
    /**
     * The Project_Overview
     * Meta information extracted from the WSDL
     * - documentation: Project Overview details related to the project template.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Overview;
    /**
     * The Project_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project status for the project template.
     * - minOccurs: 0
     * @var \StructType\Project_StageObjectType
     */
    public $Project_Status_Reference;
    /**
     * The Include_Project_ID_in_Name
     * Meta information extracted from the WSDL
     * - documentation: If true, the project ID is to be included in project name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Project_ID_in_Name;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: If true, the project is billable for the project template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Capital
     * Meta information extracted from the WSDL
     * - documentation: If true, the project template is for a capital project.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Capital;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company for the project template.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default currency for the project template.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Customer_Reference
     * Meta information extracted from the WSDL
     * - documentation: The customer for the project template.
     * - minOccurs: 0
     * @var \StructType\CustomerObjectType
     */
    public $Customer_Reference;
    /**
     * The Worktags_Data
     * Meta information extracted from the WSDL
     * - documentation: Related Worktag Widget
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType
     */
    public $Worktags_Data;
    /**
     * The Balancing_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The balancing worktag that the project template is tagged with.
     * - minOccurs: 0
     * @var \StructType\Balancing_WorktagObjectType
     */
    public $Balancing_Worktag_Reference;
    /**
     * The Optional_Balancing_Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The optional balancing worktag that the project template is tagged with.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Optional_Balancing_Worktags_Reference;
    /**
     * The Project_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project group for the project template.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_GroupObjectType[]
     */
    public $Project_Group_Reference;
    /**
     * The Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: The work priority for the project template.
     * - minOccurs: 0
     * @var \StructType\Work_PriorityObjectType
     */
    public $Priority_Reference;
    /**
     * The Importance_Reference
     * Meta information extracted from the WSDL
     * - documentation: The importance rating for the project template.
     * - minOccurs: 0
     * @var \StructType\Importance_RatingObjectType
     */
    public $Importance_Reference;
    /**
     * The Project_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project plan template used for the project template.
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TemplateObjectType
     */
    public $Project_Plan_Template_Reference;
    /**
     * The Resource_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project resource plan template used for the project template.
     * - minOccurs: 0
     * @var \StructType\Project_Resource_Plan_TemplateObjectType
     */
    public $Resource_Plan_Template_Reference;
    /**
     * The Task_Resource_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project task resource template used for the project template.
     * - minOccurs: 0
     * @var \StructType\Project_Task_Resource_TemplateObjectType
     */
    public $Task_Resource_Template_Reference;
    /**
     * The Customer_Contract_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The customer contract template for the project template.
     * - minOccurs: 0
     * @var \StructType\Customer_Contract_TemplateObjectType
     */
    public $Customer_Contract_Template_Reference;
    /**
     * Constructor method for Project_Template_DataType
     * @uses Project_Template_DataType::setID()
     * @uses Project_Template_DataType::setTemplate_Name()
     * @uses Project_Template_DataType::setDescription()
     * @uses Project_Template_DataType::setPercent_Complete()
     * @uses Project_Template_DataType::setRisk_Level_Reference()
     * @uses Project_Template_DataType::setProblem_Statement()
     * @uses Project_Template_DataType::setObjective()
     * @uses Project_Template_DataType::setIn_Scope()
     * @uses Project_Template_DataType::setOut_of_Scope()
     * @uses Project_Template_DataType::setMeasures_of_Success()
     * @uses Project_Template_DataType::setProject_Overview()
     * @uses Project_Template_DataType::setProject_Status_Reference()
     * @uses Project_Template_DataType::setInclude_Project_ID_in_Name()
     * @uses Project_Template_DataType::setBillable()
     * @uses Project_Template_DataType::setCapital()
     * @uses Project_Template_DataType::setCompany_Reference()
     * @uses Project_Template_DataType::setCurrency_Reference()
     * @uses Project_Template_DataType::setCustomer_Reference()
     * @uses Project_Template_DataType::setWorktags_Data()
     * @uses Project_Template_DataType::setBalancing_Worktag_Reference()
     * @uses Project_Template_DataType::setOptional_Balancing_Worktags_Reference()
     * @uses Project_Template_DataType::setProject_Group_Reference()
     * @uses Project_Template_DataType::setPriority_Reference()
     * @uses Project_Template_DataType::setImportance_Reference()
     * @uses Project_Template_DataType::setProject_Plan_Template_Reference()
     * @uses Project_Template_DataType::setResource_Plan_Template_Reference()
     * @uses Project_Template_DataType::setTask_Resource_Template_Reference()
     * @uses Project_Template_DataType::setCustomer_Contract_Template_Reference()
     * @param string $iD
     * @param string $template_Name
     * @param string $description
     * @param float $percent_Complete
     * @param \StructType\Risk_LevelObjectType $risk_Level_Reference
     * @param string $problem_Statement
     * @param string $objective
     * @param string $in_Scope
     * @param string $out_of_Scope
     * @param string $measures_of_Success
     * @param string $project_Overview
     * @param \StructType\Project_StageObjectType $project_Status_Reference
     * @param bool $include_Project_ID_in_Name
     * @param bool $billable
     * @param bool $capital
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\CustomerObjectType $customer_Reference
     * @param \StructType\Related_Worktag_Widget_DataType $worktags_Data
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $optional_Balancing_Worktags_Reference
     * @param \StructType\Project_GroupObjectType[] $project_Group_Reference
     * @param \StructType\Work_PriorityObjectType $priority_Reference
     * @param \StructType\Importance_RatingObjectType $importance_Reference
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @param \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference
     * @param \StructType\Project_Task_Resource_TemplateObjectType $task_Resource_Template_Reference
     * @param \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference
     */
    public function __construct($iD = null, $template_Name = null, $description = null, $percent_Complete = null, \StructType\Risk_LevelObjectType $risk_Level_Reference = null, $problem_Statement = null, $objective = null, $in_Scope = null, $out_of_Scope = null, $measures_of_Success = null, $project_Overview = null, \StructType\Project_StageObjectType $project_Status_Reference = null, $include_Project_ID_in_Name = null, $billable = null, $capital = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\CustomerObjectType $customer_Reference = null, \StructType\Related_Worktag_Widget_DataType $worktags_Data = null, \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null, array $optional_Balancing_Worktags_Reference = array(), array $project_Group_Reference = array(), \StructType\Work_PriorityObjectType $priority_Reference = null, \StructType\Importance_RatingObjectType $importance_Reference = null, \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null, \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference = null, \StructType\Project_Task_Resource_TemplateObjectType $task_Resource_Template_Reference = null, \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference = null)
    {
        $this
            ->setID($iD)
            ->setTemplate_Name($template_Name)
            ->setDescription($description)
            ->setPercent_Complete($percent_Complete)
            ->setRisk_Level_Reference($risk_Level_Reference)
            ->setProblem_Statement($problem_Statement)
            ->setObjective($objective)
            ->setIn_Scope($in_Scope)
            ->setOut_of_Scope($out_of_Scope)
            ->setMeasures_of_Success($measures_of_Success)
            ->setProject_Overview($project_Overview)
            ->setProject_Status_Reference($project_Status_Reference)
            ->setInclude_Project_ID_in_Name($include_Project_ID_in_Name)
            ->setBillable($billable)
            ->setCapital($capital)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setCustomer_Reference($customer_Reference)
            ->setWorktags_Data($worktags_Data)
            ->setBalancing_Worktag_Reference($balancing_Worktag_Reference)
            ->setOptional_Balancing_Worktags_Reference($optional_Balancing_Worktags_Reference)
            ->setProject_Group_Reference($project_Group_Reference)
            ->setPriority_Reference($priority_Reference)
            ->setImportance_Reference($importance_Reference)
            ->setProject_Plan_Template_Reference($project_Plan_Template_Reference)
            ->setResource_Plan_Template_Reference($resource_Plan_Template_Reference)
            ->setTask_Resource_Template_Reference($task_Resource_Template_Reference)
            ->setCustomer_Contract_Template_Reference($customer_Contract_Template_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Project_Template_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Template_Name value
     * @return string|null
     */
    public function getTemplate_Name()
    {
        return $this->Template_Name;
    }
    /**
     * Set Template_Name value
     * @param string $template_Name
     * @return \StructType\Project_Template_DataType
     */
    public function setTemplate_Name($template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Name) && !is_string($template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Name, true), gettype($template_Name)), __LINE__);
        }
        $this->Template_Name = $template_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Template_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Percent_Complete value
     * @return float|null
     */
    public function getPercent_Complete()
    {
        return $this->Percent_Complete;
    }
    /**
     * Set Percent_Complete value
     * @param float $percent_Complete
     * @return \StructType\Project_Template_DataType
     */
    public function setPercent_Complete($percent_Complete = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Complete) && !(is_float($percent_Complete) || is_numeric($percent_Complete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Complete, true), gettype($percent_Complete)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Complete) && mb_strlen(mb_substr($percent_Complete, false !== mb_strpos($percent_Complete, '.') ? mb_strpos($percent_Complete, '.') + 1 : mb_strlen($percent_Complete))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Complete, true), mb_strlen(mb_substr($percent_Complete, mb_strpos($percent_Complete, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Complete) && $percent_Complete < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Complete, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Complete) && mb_strlen(preg_replace('/(\D)/', '', $percent_Complete)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Complete, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Complete))), __LINE__);
        }
        $this->Percent_Complete = $percent_Complete;
        return $this;
    }
    /**
     * Get Risk_Level_Reference value
     * @return \StructType\Risk_LevelObjectType|null
     */
    public function getRisk_Level_Reference()
    {
        return $this->Risk_Level_Reference;
    }
    /**
     * Set Risk_Level_Reference value
     * @param \StructType\Risk_LevelObjectType $risk_Level_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setRisk_Level_Reference(\StructType\Risk_LevelObjectType $risk_Level_Reference = null)
    {
        $this->Risk_Level_Reference = $risk_Level_Reference;
        return $this;
    }
    /**
     * Get Problem_Statement value
     * @return string|null
     */
    public function getProblem_Statement()
    {
        return $this->Problem_Statement;
    }
    /**
     * Set Problem_Statement value
     * @param string $problem_Statement
     * @return \StructType\Project_Template_DataType
     */
    public function setProblem_Statement($problem_Statement = null)
    {
        // validation for constraint: string
        if (!is_null($problem_Statement) && !is_string($problem_Statement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($problem_Statement, true), gettype($problem_Statement)), __LINE__);
        }
        $this->Problem_Statement = $problem_Statement;
        return $this;
    }
    /**
     * Get Objective value
     * @return string|null
     */
    public function getObjective()
    {
        return $this->Objective;
    }
    /**
     * Set Objective value
     * @param string $objective
     * @return \StructType\Project_Template_DataType
     */
    public function setObjective($objective = null)
    {
        // validation for constraint: string
        if (!is_null($objective) && !is_string($objective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objective, true), gettype($objective)), __LINE__);
        }
        $this->Objective = $objective;
        return $this;
    }
    /**
     * Get In_Scope value
     * @return string|null
     */
    public function getIn_Scope()
    {
        return $this->In_Scope;
    }
    /**
     * Set In_Scope value
     * @param string $in_Scope
     * @return \StructType\Project_Template_DataType
     */
    public function setIn_Scope($in_Scope = null)
    {
        // validation for constraint: string
        if (!is_null($in_Scope) && !is_string($in_Scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Scope, true), gettype($in_Scope)), __LINE__);
        }
        $this->In_Scope = $in_Scope;
        return $this;
    }
    /**
     * Get Out_of_Scope value
     * @return string|null
     */
    public function getOut_of_Scope()
    {
        return $this->Out_of_Scope;
    }
    /**
     * Set Out_of_Scope value
     * @param string $out_of_Scope
     * @return \StructType\Project_Template_DataType
     */
    public function setOut_of_Scope($out_of_Scope = null)
    {
        // validation for constraint: string
        if (!is_null($out_of_Scope) && !is_string($out_of_Scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($out_of_Scope, true), gettype($out_of_Scope)), __LINE__);
        }
        $this->Out_of_Scope = $out_of_Scope;
        return $this;
    }
    /**
     * Get Measures_of_Success value
     * @return string|null
     */
    public function getMeasures_of_Success()
    {
        return $this->Measures_of_Success;
    }
    /**
     * Set Measures_of_Success value
     * @param string $measures_of_Success
     * @return \StructType\Project_Template_DataType
     */
    public function setMeasures_of_Success($measures_of_Success = null)
    {
        // validation for constraint: string
        if (!is_null($measures_of_Success) && !is_string($measures_of_Success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measures_of_Success, true), gettype($measures_of_Success)), __LINE__);
        }
        $this->Measures_of_Success = $measures_of_Success;
        return $this;
    }
    /**
     * Get Project_Overview value
     * @return string|null
     */
    public function getProject_Overview()
    {
        return $this->Project_Overview;
    }
    /**
     * Set Project_Overview value
     * @param string $project_Overview
     * @return \StructType\Project_Template_DataType
     */
    public function setProject_Overview($project_Overview = null)
    {
        // validation for constraint: string
        if (!is_null($project_Overview) && !is_string($project_Overview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Overview, true), gettype($project_Overview)), __LINE__);
        }
        $this->Project_Overview = $project_Overview;
        return $this;
    }
    /**
     * Get Project_Status_Reference value
     * @return \StructType\Project_StageObjectType|null
     */
    public function getProject_Status_Reference()
    {
        return $this->Project_Status_Reference;
    }
    /**
     * Set Project_Status_Reference value
     * @param \StructType\Project_StageObjectType $project_Status_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setProject_Status_Reference(\StructType\Project_StageObjectType $project_Status_Reference = null)
    {
        $this->Project_Status_Reference = $project_Status_Reference;
        return $this;
    }
    /**
     * Get Include_Project_ID_in_Name value
     * @return bool|null
     */
    public function getInclude_Project_ID_in_Name()
    {
        return $this->Include_Project_ID_in_Name;
    }
    /**
     * Set Include_Project_ID_in_Name value
     * @param bool $include_Project_ID_in_Name
     * @return \StructType\Project_Template_DataType
     */
    public function setInclude_Project_ID_in_Name($include_Project_ID_in_Name = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Project_ID_in_Name) && !is_bool($include_Project_ID_in_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Project_ID_in_Name, true), gettype($include_Project_ID_in_Name)), __LINE__);
        }
        $this->Include_Project_ID_in_Name = $include_Project_ID_in_Name;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Project_Template_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Capital value
     * @return bool|null
     */
    public function getCapital()
    {
        return $this->Capital;
    }
    /**
     * Set Capital value
     * @param bool $capital
     * @return \StructType\Project_Template_DataType
     */
    public function setCapital($capital = null)
    {
        // validation for constraint: boolean
        if (!is_null($capital) && !is_bool($capital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($capital, true), gettype($capital)), __LINE__);
        }
        $this->Capital = $capital;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Customer_Reference value
     * @return \StructType\CustomerObjectType|null
     */
    public function getCustomer_Reference()
    {
        return $this->Customer_Reference;
    }
    /**
     * Set Customer_Reference value
     * @param \StructType\CustomerObjectType $customer_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setCustomer_Reference(\StructType\CustomerObjectType $customer_Reference = null)
    {
        $this->Customer_Reference = $customer_Reference;
        return $this;
    }
    /**
     * Get Worktags_Data value
     * @return \StructType\Related_Worktag_Widget_DataType|null
     */
    public function getWorktags_Data()
    {
        return $this->Worktags_Data;
    }
    /**
     * Set Worktags_Data value
     * @param \StructType\Related_Worktag_Widget_DataType $worktags_Data
     * @return \StructType\Project_Template_DataType
     */
    public function setWorktags_Data(\StructType\Related_Worktag_Widget_DataType $worktags_Data = null)
    {
        $this->Worktags_Data = $worktags_Data;
        return $this;
    }
    /**
     * Get Balancing_Worktag_Reference value
     * @return \StructType\Balancing_WorktagObjectType|null
     */
    public function getBalancing_Worktag_Reference()
    {
        return $this->Balancing_Worktag_Reference;
    }
    /**
     * Set Balancing_Worktag_Reference value
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setBalancing_Worktag_Reference(\StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null)
    {
        $this->Balancing_Worktag_Reference = $balancing_Worktag_Reference;
        return $this;
    }
    /**
     * Get Optional_Balancing_Worktags_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getOptional_Balancing_Worktags_Reference()
    {
        return $this->Optional_Balancing_Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOptional_Balancing_Worktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptional_Balancing_Worktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptional_Balancing_Worktags_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem) ? get_class($project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem) : sprintf('%s(%s)', gettype($project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem), var_export($project_Template_DataTypeOptional_Balancing_Worktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Optional_Balancing_Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Optional_Balancing_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $optional_Balancing_Worktags_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setOptional_Balancing_Worktags_Reference(array $optional_Balancing_Worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($optional_Balancing_Worktags_ReferenceArrayErrorMessage = self::validateOptional_Balancing_Worktags_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktags_Reference($optional_Balancing_Worktags_Reference))) {
            throw new \InvalidArgumentException($optional_Balancing_Worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Optional_Balancing_Worktags_Reference = $optional_Balancing_Worktags_Reference;
        return $this;
    }
    /**
     * Add item to Optional_Balancing_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Project_Template_DataType
     */
    public function addToOptional_Balancing_Worktags_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Optional_Balancing_Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Optional_Balancing_Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Group_Reference value
     * @return \StructType\Project_GroupObjectType[]|null
     */
    public function getProject_Group_Reference()
    {
        return $this->Project_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Group_ReferenceForArrayConstraintsFromSetProject_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Template_DataTypeProject_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Template_DataTypeProject_Group_ReferenceItem instanceof \StructType\Project_GroupObjectType) {
                $invalidValues[] = is_object($project_Template_DataTypeProject_Group_ReferenceItem) ? get_class($project_Template_DataTypeProject_Group_ReferenceItem) : sprintf('%s(%s)', gettype($project_Template_DataTypeProject_Group_ReferenceItem), var_export($project_Template_DataTypeProject_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Group_Reference property can only contain items of type \StructType\Project_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_GroupObjectType[] $project_Group_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setProject_Group_Reference(array $project_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Group_ReferenceArrayErrorMessage = self::validateProject_Group_ReferenceForArrayConstraintsFromSetProject_Group_Reference($project_Group_Reference))) {
            throw new \InvalidArgumentException($project_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Group_Reference = $project_Group_Reference;
        return $this;
    }
    /**
     * Add item to Project_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_GroupObjectType $item
     * @return \StructType\Project_Template_DataType
     */
    public function addToProject_Group_Reference(\StructType\Project_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Group_Reference property can only contain items of type \StructType\Project_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Priority_Reference value
     * @return \StructType\Work_PriorityObjectType|null
     */
    public function getPriority_Reference()
    {
        return $this->Priority_Reference;
    }
    /**
     * Set Priority_Reference value
     * @param \StructType\Work_PriorityObjectType $priority_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setPriority_Reference(\StructType\Work_PriorityObjectType $priority_Reference = null)
    {
        $this->Priority_Reference = $priority_Reference;
        return $this;
    }
    /**
     * Get Importance_Reference value
     * @return \StructType\Importance_RatingObjectType|null
     */
    public function getImportance_Reference()
    {
        return $this->Importance_Reference;
    }
    /**
     * Set Importance_Reference value
     * @param \StructType\Importance_RatingObjectType $importance_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setImportance_Reference(\StructType\Importance_RatingObjectType $importance_Reference = null)
    {
        $this->Importance_Reference = $importance_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Template_Reference value
     * @return \StructType\Project_Plan_TemplateObjectType|null
     */
    public function getProject_Plan_Template_Reference()
    {
        return $this->Project_Plan_Template_Reference;
    }
    /**
     * Set Project_Plan_Template_Reference value
     * @param \StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setProject_Plan_Template_Reference(\StructType\Project_Plan_TemplateObjectType $project_Plan_Template_Reference = null)
    {
        $this->Project_Plan_Template_Reference = $project_Plan_Template_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Template_Reference value
     * @return \StructType\Project_Resource_Plan_TemplateObjectType|null
     */
    public function getResource_Plan_Template_Reference()
    {
        return $this->Resource_Plan_Template_Reference;
    }
    /**
     * Set Resource_Plan_Template_Reference value
     * @param \StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setResource_Plan_Template_Reference(\StructType\Project_Resource_Plan_TemplateObjectType $resource_Plan_Template_Reference = null)
    {
        $this->Resource_Plan_Template_Reference = $resource_Plan_Template_Reference;
        return $this;
    }
    /**
     * Get Task_Resource_Template_Reference value
     * @return \StructType\Project_Task_Resource_TemplateObjectType|null
     */
    public function getTask_Resource_Template_Reference()
    {
        return $this->Task_Resource_Template_Reference;
    }
    /**
     * Set Task_Resource_Template_Reference value
     * @param \StructType\Project_Task_Resource_TemplateObjectType $task_Resource_Template_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setTask_Resource_Template_Reference(\StructType\Project_Task_Resource_TemplateObjectType $task_Resource_Template_Reference = null)
    {
        $this->Task_Resource_Template_Reference = $task_Resource_Template_Reference;
        return $this;
    }
    /**
     * Get Customer_Contract_Template_Reference value
     * @return \StructType\Customer_Contract_TemplateObjectType|null
     */
    public function getCustomer_Contract_Template_Reference()
    {
        return $this->Customer_Contract_Template_Reference;
    }
    /**
     * Set Customer_Contract_Template_Reference value
     * @param \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference
     * @return \StructType\Project_Template_DataType
     */
    public function setCustomer_Contract_Template_Reference(\StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference = null)
    {
        $this->Customer_Contract_Template_Reference = $customer_Contract_Template_Reference;
        return $this;
    }
}
