<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Card_Holder_Listing_FileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Card Holder Listing File instance and data
 * @subpackage Structs
 */
class Card_Holder_Listing_FileType extends AbstractStructBase
{
    /**
     * The Card_Holder_Listing_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Reference
     * - minOccurs: 0
     * @var \StructType\Cardholder_Listing_FileObjectType
     */
    public $Card_Holder_Listing_File_Reference;
    /**
     * The Card_Holder_Listing_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Card Holder Listing File data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Card_Holder_Listing_File_DataType[]
     */
    public $Card_Holder_Listing_File_Data;
    /**
     * Constructor method for Card_Holder_Listing_FileType
     * @uses Card_Holder_Listing_FileType::setCard_Holder_Listing_File_Reference()
     * @uses Card_Holder_Listing_FileType::setCard_Holder_Listing_File_Data()
     * @param \StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference
     * @param \StructType\Card_Holder_Listing_File_DataType[] $card_Holder_Listing_File_Data
     */
    public function __construct(\StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference = null, array $card_Holder_Listing_File_Data = array())
    {
        $this
            ->setCard_Holder_Listing_File_Reference($card_Holder_Listing_File_Reference)
            ->setCard_Holder_Listing_File_Data($card_Holder_Listing_File_Data);
    }
    /**
     * Get Card_Holder_Listing_File_Reference value
     * @return \StructType\Cardholder_Listing_FileObjectType|null
     */
    public function getCard_Holder_Listing_File_Reference()
    {
        return $this->Card_Holder_Listing_File_Reference;
    }
    /**
     * Set Card_Holder_Listing_File_Reference value
     * @param \StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference
     * @return \StructType\Card_Holder_Listing_FileType
     */
    public function setCard_Holder_Listing_File_Reference(\StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference = null)
    {
        $this->Card_Holder_Listing_File_Reference = $card_Holder_Listing_File_Reference;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Data value
     * @return \StructType\Card_Holder_Listing_File_DataType[]|null
     */
    public function getCard_Holder_Listing_File_Data()
    {
        return $this->Card_Holder_Listing_File_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCard_Holder_Listing_File_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCard_Holder_Listing_File_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCard_Holder_Listing_File_DataForArrayConstraintsFromSetCard_Holder_Listing_File_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem) {
            // validation for constraint: itemType
            if (!$card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem instanceof \StructType\Card_Holder_Listing_File_DataType) {
                $invalidValues[] = is_object($card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem) ? get_class($card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem) : sprintf('%s(%s)', gettype($card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem), var_export($card_Holder_Listing_FileTypeCard_Holder_Listing_File_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Card_Holder_Listing_File_Data property can only contain items of type \StructType\Card_Holder_Listing_File_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Card_Holder_Listing_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Card_Holder_Listing_File_DataType[] $card_Holder_Listing_File_Data
     * @return \StructType\Card_Holder_Listing_FileType
     */
    public function setCard_Holder_Listing_File_Data(array $card_Holder_Listing_File_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($card_Holder_Listing_File_DataArrayErrorMessage = self::validateCard_Holder_Listing_File_DataForArrayConstraintsFromSetCard_Holder_Listing_File_Data($card_Holder_Listing_File_Data))) {
            throw new \InvalidArgumentException($card_Holder_Listing_File_DataArrayErrorMessage, __LINE__);
        }
        $this->Card_Holder_Listing_File_Data = $card_Holder_Listing_File_Data;
        return $this;
    }
    /**
     * Add item to Card_Holder_Listing_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Card_Holder_Listing_File_DataType $item
     * @return \StructType\Card_Holder_Listing_FileType
     */
    public function addToCard_Holder_Listing_File_Data(\StructType\Card_Holder_Listing_File_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Card_Holder_Listing_File_DataType) {
            throw new \InvalidArgumentException(sprintf('The Card_Holder_Listing_File_Data property can only contain items of type \StructType\Card_Holder_Listing_File_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Card_Holder_Listing_File_Data[] = $item;
        return $this;
    }
}
