<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You need to enable a payment purpose code during tenant set up to add a payment purpose code to the invoice or adjustment | The alternate ledger currency override you entered must be unique. Enter a unique override currency. |
 * Specify a value for either Remit-To Supplier Connection or Use Default Supplier Connection. | You selected an invalid supplier contract for this supplier invoice. Select a supplier contract that's valid for the company, supplier, and document date;
 * not undergoing an amendment; and supports manual supplier invoices. | You can't submit Taxable Code Application Data when Company has a third party tax integration enabled for Supplier Invoices. | You can't specify a third party tax code in the
 * transaction tax code reference. | You can't associate invoices to Consignment type Contracts. | The accounting journal associated with this operational transaction is in a closed period, so you can't change this document. | Please enter just one
 * Ship-To Address. | Tax Option is required on a Tax Only Invoice. | Tax Amount at the header should be entered on a Tax Only Invoice when Enter Tax Due to Supplier tax option is selected. | Withholding Tax Codes that has Withholding Tax Rate(s) with
 * Tax Base Type of Tax can only be selected for a Tax Only Invoice Type. | The header company and line company must be the same for a Tax Only Invoice Type. | You can't submit a tax-only invoice if the invoice is related to any other business document,
 * such as a purchase order, receipt, supplier contract, and more. | Referenced invoices must match the header company | Referenced invoices cannot be Cancelled or Denied | Freight or Other Charges cannot be entered if the invoice is Tax Only. | The
 * Prepaid flag cannot be checked for a Tax Only Invoice Type. | You can't change the Supplier if the supplier invoice is related to a purchase order. | You can't change the Company if the supplier invoice is related to a purchase order. | You can't
 * change the Currency if the supplier invoice is related to a purchase order. | An Invoice Document cannot have a Reference Type without a Reference Number or a Reference Number without a Reference Type. The document must contain both or neither. | The
 * Supplier Contract provided cannot be used because it is referenced on a Procurement Card Verification. | Suppliers that are restricted to company must be restricted to either the document header company or the Company Hierarchy for which it is a
 * subordinate. | 'Allow Accounting in Arrears' is not permitted for this company. | Accounting Date is required for this Company. Enter an Accounting Date. | Enter an Accounting Date in an Open Period | The Document Link URL entered does not comply
 * with URL restrictions set for this Field. | External Document Links are currently not enabled. | Supplier Invoice Data
 * @subpackage Structs
 */
class Supplier_Invoice__HV__DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice ID. This is the Supplier Invoice unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the invoice inside the Workday application. Invoice can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: If adding a new invoice, then make the Invoice Number the same value as Reference ID. If updating an existing invoice, then make it the same value as the Reference ID of that invoice. If you do not make the Invoice Number the same as
     * Reference ID, then duplicate Invoice Numbers for different invoices may be created. The Reference ID is the only value checked as a unique identifier. Note that the name of the Reference ID is different for each invoice type: e.g. Supplier Invoice
     * ID, Supplier Invoice Adjustment ID, Customer Invoice Adjustment ID, and Customer Invoice ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Number;
    /**
     * The External_Supplier_Invoice_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The External Supplier Invoice Source. Defaults to Web Service, but you can override it.
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_Supplier_Invoice_Source_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that tranasction is for. This is the reference id value of the company.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Payment_Practices
     * Meta information extracted from the WSDL
     * - documentation: Payment Practice field to flag a Supplier Invoice for Payment Practices Reporting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Payment_Practices;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a Currency. The Supplier, Company, or Remit to Connection don't have a default currency. | Currency entered is not listed as an Accepted Currency by Supplier. | This is the reference id of currency of the transaction If no
     * currency is specified, Workday will first look to see if the payer/payee has a preferred currency and if not, currency will be populated with the company base currency. If the company base currency is not allowed currency for payer/payee then
     * transaction will not be able to be submitted for approval.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference is the reference to the Supplier the invoice is from.
     * - choice: Supplier_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Contingent Worker
     * - choice: Supplier_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Contingent_WorkerObjectType
     */
    public $Contingent_Worker_Reference;
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Use_Default_Supplier_Connection
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the default supplier connection will be derived.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Default_Supplier_Connection;
    /**
     * The Default_Tax_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Option. If left blank, will default from the Company.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Default_Tax_Option_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Address_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: We update these web services to enable you to submit a ship-to address using the Address Reference ID field:* Import Supplier Invoice* Submit Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_ID_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't submit a Tax Code at the header when the Company has a third party tax integration enabled for Supplier Invoices. | This is the reference id value of the tax code. If not submitted, Workday will use the payee default the
     * tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Default_Withholding_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the default withholding tax code. If not submitted, Workday will use the payee default the withholding tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Withholding_Tax_Code_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Format is MM/DD/YYYY.If this is left blank, Workday will populate invoice date with the current date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Invoice_Received_Date
     * Meta information extracted from the WSDL
     * - documentation: Field to store the Invoice Received Date value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Received_Date;
    /**
     * The Due_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Due Date must not be earlier than Invoice Date | Format is MM/DD/YYYY.If a date is provided, it will override the due date that Workday automatically determines based on the invoice date and payment terms.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date_Override;
    /**
     * The Accounting_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Override date for Accounting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Date_Override;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on all supplier invoice lines and splits.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The On_Hold
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the invoice will be put on hold.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $On_Hold;
    /**
     * The Control_Amount_Total
     * Meta information extracted from the WSDL
     * - documentation: This is the expected invoice total including tax. It is optional. An invoice cannot be submittted for approval if it has a non-zero control total that does not equal the sum of the extended amount for all invoice lines plus tax.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Control_Amount_Total;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Other_Charges
     * Meta information extracted from the WSDL
     * - documentation: If there are Other Charges, then there must be at least one line with a Spend Category that has Allocate Other Charges. | An optional addition of Other Charges for the Requisition. | Other Charges
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Other_Charges;
    /**
     * The Worktag_Split_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Allocation Template for Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_TemplateObjectType
     */
    public $Worktag_Split_Template_Reference;
    /**
     * The Tax_Only
     * Meta information extracted from the WSDL
     * - documentation: Tax Only Boolean to indicate if the Supplier Invoice is Tax Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Tax_Only;
    /**
     * The Referenced_Invoices_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Only invoice Workset for adding Referenced Invoices
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType[]
     */
    public $Referenced_Invoices_Reference;
    /**
     * The Supplier_Document_Received
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute indicating if the Supplier Paper Document was received (possibly through mail or fax) . If this is set then a Supplier Reference is required that will provide information for locating that document.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Supplier_Document_Received;
    /**
     * The Suppliers_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: If Supplier Document Received is true, a Supplier Reference Number must also be submitted. | The Supplier Reference entered has already been used on another invoice or adjustment for this supplier | Free form text field to provide a
     * Supplier Reference memo. The Supplier Reference is not a Workday Reference ID, but a text field for providing additional information about the Supplier Invoice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Suppliers_Invoice_Number;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for providing addition information on the Purchase Order that the Supplier Invoice is for. This is not a Workday Purchase Order Reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Statutory_Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type for Supplier Invoice.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Statutory_Invoice_Type_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract referenced cannot be an Amendment or History. | The Supplier Contract selected must be for the Supplier on the invoice. | Reference to an existing Supplier Contract
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_BaseObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Link to a scanned image of the paper invoice
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: This transaction header memo will print on the delivered transaction. It is optional freeform text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Approver_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Approver for Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Approver_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter Payment Terms. You can also select a Remit to Connection or Supplier that already has default payment terms configured. | This is the reference id of the payment terms for the invoice. Payment Terms are the rules for
     * establishing when a invoice payment is due and whether discounts are eligible to be taken or given for early payment. This is a required field, but if no payment terms are specified, Workday will populate this with the customer's default payment
     * terms if one is defined. Workday will automatically determine the due date and discount date based on the invoice date and payment terms.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Override Payment Type cannot be used if a Supplier is not provided. | If Override Payment Type is provided, it must be one of the accepted Payment Types for the Supplier provided. | A reference to a Payment Type. If one is provided,
     * it will be used in processing the Payment instead of the Supplier's default payment type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Additional_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Additional Type Reference
     * - minOccurs: 0
     * @var \StructType\Additional_Reference_TypeObjectType
     */
    public $Additional_Type_Reference;
    /**
     * The Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Reference Number
     * - base: xsd:string
     * - maxLength: 140
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference_Number;
    /**
     * The Originating_Country_Payment_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Originating Country Payment Purpose Code. This code is used to identify the purpose of the payment from the originating country.
     * - minOccurs: 0
     * @var \StructType\Payment_Purpose_CodeObjectType
     */
    public $Originating_Country_Payment_Purpose_Reference;
    /**
     * The Receiving_Country_Payment_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Country Payment Purpose Code. This code is used to identify the purpose of the payment from the receiving country.
     * - minOccurs: 0
     * @var \StructType\Payment_Purpose_CodeObjectType
     */
    public $Receiving_Country_Payment_Purpose_Reference;
    /**
     * The Handling_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference code of the payment handling instructions for the supplier invoice or supplier invoice adjustment.
     * - minOccurs: 0
     * @var \StructType\Payment_Handling_InstructionObjectType
     */
    public $Handling_Code_Reference;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Set the Prepaid value to true for Prepaid Invoices where all lines are Prepaid. If set, the lines cannot be also set to Prepaid individually.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Prepayment_Release_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Prepaid Amortization Type
     * - minOccurs: 0
     * @var \StructType\Prepaid_Amortization_TypeObjectType
     */
    public $Prepayment_Release_Type_Reference;
    /**
     * The Release_Date
     * Meta information extracted from the WSDL
     * - documentation: Expected Amortization Date must be after the Invoice date and the current date. | Prepaid Amortization Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Release_Date;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Frequency to be used when generating the next prepaid accounting entry.
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The Number_of_Installments
     * Meta information extracted from the WSDL
     * - documentation: Number of installments. The system generates installments based on this value. | The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Installments;
    /**
     * The Use_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Both the Use Invoice Date and Specified Date cannot be specified at the same time. | Use the Invoice Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Invoice_Date;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Specified Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The Retention_Memo
     * Meta information extracted from the WSDL
     * - documentation: The retention memo.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Retention_Memo;
    /**
     * The Additional_Fields_Data_Reference
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing additional fields data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Configurable_Attributes_DataType[]
     */
    public $Additional_Fields_Data_Reference;
    /**
     * The Currency_Rate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_DataType[]
     */
    public $Currency_Rate_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Tax_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Tax Data by Tax Authority and Tax Code. For Customer Invoice Documents and Cash Sales tax data will always be calculated from the line data regardless of what is populated in Tax Rate Application Data. For Purchase Orders, Supplier
     * Invoice Documents and Ad hoc Payments, if data is in Tax Rate Application Data, then that will be the tax information that is saved. Otherwise, the tax will be calculated from the lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Taxable_Code_Application_DataType[]
     */
    public $Tax_Code_Data;
    /**
     * The Invoice_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Line Data. A Supplier Invoice may have multiple lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Replacement__HV__DataType[]
     */
    public $Invoice_Line_Replacement_Data;
    /**
     * The Retention_Release_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing Supplier Invoice Retention Release Line data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[]
     */
    public $Retention_Release_Line_Data;
    /**
     * The Supplier_Invoice_Intercompany_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType
     */
    public $Supplier_Invoice_Intercompany_Sub_Process;
    /**
     * The Supplier_Invoice_Prepaid_Amortization_Schedule
     * Meta information extracted from the WSDL
     * - documentation: Prepaid Supplier Invoice Lines for Amortization Schedule
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[]
     */
    public $Supplier_Invoice_Prepaid_Amortization_Schedule;
    /**
     * The Work_Queue_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Information_DataType[]
     */
    public $Work_Queue_Information_Data;
    /**
     * Constructor method for Supplier_Invoice__HV__DataType
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Invoice_ID()
     * @uses Supplier_Invoice__HV__DataType::setSubmit()
     * @uses Supplier_Invoice__HV__DataType::setLocked_in_Workday()
     * @uses Supplier_Invoice__HV__DataType::setInvoice_Number()
     * @uses Supplier_Invoice__HV__DataType::setExternal_Supplier_Invoice_Source_Reference()
     * @uses Supplier_Invoice__HV__DataType::setCompany_Reference()
     * @uses Supplier_Invoice__HV__DataType::setPayment_Practices()
     * @uses Supplier_Invoice__HV__DataType::setCurrency_Reference()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Reference()
     * @uses Supplier_Invoice__HV__DataType::setContingent_Worker_Reference()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Connection_Reference()
     * @uses Supplier_Invoice__HV__DataType::setUse_Default_Supplier_Connection()
     * @uses Supplier_Invoice__HV__DataType::setDefault_Tax_Option_Reference()
     * @uses Supplier_Invoice__HV__DataType::setShip_To_Address_Reference()
     * @uses Supplier_Invoice__HV__DataType::setShip_To_Address_ID_Reference()
     * @uses Supplier_Invoice__HV__DataType::setTax_Code_Reference()
     * @uses Supplier_Invoice__HV__DataType::setDefault_Withholding_Tax_Code_Reference()
     * @uses Supplier_Invoice__HV__DataType::setInvoice_Date()
     * @uses Supplier_Invoice__HV__DataType::setInvoice_Received_Date()
     * @uses Supplier_Invoice__HV__DataType::setDue_Date_Override()
     * @uses Supplier_Invoice__HV__DataType::setAccounting_Date_Override()
     * @uses Supplier_Invoice__HV__DataType::setBudget_Date()
     * @uses Supplier_Invoice__HV__DataType::setOn_Hold()
     * @uses Supplier_Invoice__HV__DataType::setControl_Amount_Total()
     * @uses Supplier_Invoice__HV__DataType::setTax_Amount()
     * @uses Supplier_Invoice__HV__DataType::setFreight_Amount()
     * @uses Supplier_Invoice__HV__DataType::setOther_Charges()
     * @uses Supplier_Invoice__HV__DataType::setWorktag_Split_Template_Reference()
     * @uses Supplier_Invoice__HV__DataType::setTax_Only()
     * @uses Supplier_Invoice__HV__DataType::setReferenced_Invoices_Reference()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Document_Received()
     * @uses Supplier_Invoice__HV__DataType::setSuppliers_Invoice_Number()
     * @uses Supplier_Invoice__HV__DataType::setExternal_PO_Number()
     * @uses Supplier_Invoice__HV__DataType::setStatutory_Invoice_Type_Reference()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Invoice__HV__DataType::setDocument_Link()
     * @uses Supplier_Invoice__HV__DataType::setMemo()
     * @uses Supplier_Invoice__HV__DataType::setApprover_Reference()
     * @uses Supplier_Invoice__HV__DataType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice__HV__DataType::setOverride_Payment_Type_Reference()
     * @uses Supplier_Invoice__HV__DataType::setAdditional_Type_Reference()
     * @uses Supplier_Invoice__HV__DataType::setReference_Number()
     * @uses Supplier_Invoice__HV__DataType::setOriginating_Country_Payment_Purpose_Reference()
     * @uses Supplier_Invoice__HV__DataType::setReceiving_Country_Payment_Purpose_Reference()
     * @uses Supplier_Invoice__HV__DataType::setHandling_Code_Reference()
     * @uses Supplier_Invoice__HV__DataType::setPrepaid()
     * @uses Supplier_Invoice__HV__DataType::setPrepayment_Release_Type_Reference()
     * @uses Supplier_Invoice__HV__DataType::setRelease_Date()
     * @uses Supplier_Invoice__HV__DataType::setFrequency_Reference()
     * @uses Supplier_Invoice__HV__DataType::setNumber_of_Installments()
     * @uses Supplier_Invoice__HV__DataType::setUse_Invoice_Date()
     * @uses Supplier_Invoice__HV__DataType::setFrom_Date()
     * @uses Supplier_Invoice__HV__DataType::setRetention_Memo()
     * @uses Supplier_Invoice__HV__DataType::setAdditional_Fields_Data_Reference()
     * @uses Supplier_Invoice__HV__DataType::setCurrency_Rate_Data()
     * @uses Supplier_Invoice__HV__DataType::setAttachment_Data()
     * @uses Supplier_Invoice__HV__DataType::setTax_Code_Data()
     * @uses Supplier_Invoice__HV__DataType::setInvoice_Line_Replacement_Data()
     * @uses Supplier_Invoice__HV__DataType::setRetention_Release_Line_Data()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Invoice_Intercompany_Sub_Process()
     * @uses Supplier_Invoice__HV__DataType::setSupplier_Invoice_Prepaid_Amortization_Schedule()
     * @uses Supplier_Invoice__HV__DataType::setWork_Queue_Information_Data()
     * @param string $supplier_Invoice_ID
     * @param bool $submit
     * @param bool $locked_in_Workday
     * @param string $invoice_Number
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $payment_Practices
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param bool $use_Default_Supplier_Connection
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @param string $invoice_Date
     * @param string $invoice_Received_Date
     * @param string $due_Date_Override
     * @param string $accounting_Date_Override
     * @param string $budget_Date
     * @param bool $on_Hold
     * @param float $control_Amount_Total
     * @param float $tax_Amount
     * @param float $freight_Amount
     * @param float $other_Charges
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @param bool $tax_Only
     * @param \StructType\Supplier_InvoiceObjectType[] $referenced_Invoices_Reference
     * @param bool $supplier_Document_Received
     * @param string $suppliers_Invoice_Number
     * @param string $external_PO_Number
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @param string $document_Link
     * @param string $memo
     * @param \StructType\WorkerObjectType $approver_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @param string $reference_Number
     * @param \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference
     * @param \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @param bool $prepaid
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @param string $release_Date
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param float $number_of_Installments
     * @param bool $use_Invoice_Date
     * @param string $from_Date
     * @param string $retention_Memo
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Taxable_Code_Application_DataType[] $tax_Code_Data
     * @param \StructType\Supplier_Invoice_Line_Replacement__HV__DataType[] $invoice_Line_Replacement_Data
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[] $retention_Release_Line_Data
     * @param \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[] $supplier_Invoice_Prepaid_Amortization_Schedule
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType[] $work_Queue_Information_Data
     */
    public function __construct($supplier_Invoice_ID = null, $submit = null, $locked_in_Workday = null, $invoice_Number = null, \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $payment_Practices = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $use_Default_Supplier_Connection = null, \StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null, $invoice_Date = null, $invoice_Received_Date = null, $due_Date_Override = null, $accounting_Date_Override = null, $budget_Date = null, $on_Hold = null, $control_Amount_Total = null, $tax_Amount = null, $freight_Amount = null, $other_Charges = null, \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null, $tax_Only = null, array $referenced_Invoices_Reference = array(), $supplier_Document_Received = null, $suppliers_Invoice_Number = null, $external_PO_Number = null, \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null, \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null, $document_Link = null, $memo = null, \StructType\WorkerObjectType $approver_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null, $reference_Number = null, \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference = null, \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference = null, \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null, $prepaid = null, \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null, $release_Date = null, \StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $number_of_Installments = null, $use_Invoice_Date = null, $from_Date = null, $retention_Memo = null, array $additional_Fields_Data_Reference = array(), array $currency_Rate_Data = array(), array $attachment_Data = array(), array $tax_Code_Data = array(), array $invoice_Line_Replacement_Data = array(), array $retention_Release_Line_Data = array(), \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process = null, array $supplier_Invoice_Prepaid_Amortization_Schedule = array(), array $work_Queue_Information_Data = array())
    {
        $this
            ->setSupplier_Invoice_ID($supplier_Invoice_ID)
            ->setSubmit($submit)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setInvoice_Number($invoice_Number)
            ->setExternal_Supplier_Invoice_Source_Reference($external_Supplier_Invoice_Source_Reference)
            ->setCompany_Reference($company_Reference)
            ->setPayment_Practices($payment_Practices)
            ->setCurrency_Reference($currency_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setContingent_Worker_Reference($contingent_Worker_Reference)
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setUse_Default_Supplier_Connection($use_Default_Supplier_Connection)
            ->setDefault_Tax_Option_Reference($default_Tax_Option_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Address_ID_Reference($ship_To_Address_ID_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setDefault_Withholding_Tax_Code_Reference($default_Withholding_Tax_Code_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setInvoice_Received_Date($invoice_Received_Date)
            ->setDue_Date_Override($due_Date_Override)
            ->setAccounting_Date_Override($accounting_Date_Override)
            ->setBudget_Date($budget_Date)
            ->setOn_Hold($on_Hold)
            ->setControl_Amount_Total($control_Amount_Total)
            ->setTax_Amount($tax_Amount)
            ->setFreight_Amount($freight_Amount)
            ->setOther_Charges($other_Charges)
            ->setWorktag_Split_Template_Reference($worktag_Split_Template_Reference)
            ->setTax_Only($tax_Only)
            ->setReferenced_Invoices_Reference($referenced_Invoices_Reference)
            ->setSupplier_Document_Received($supplier_Document_Received)
            ->setSuppliers_Invoice_Number($suppliers_Invoice_Number)
            ->setExternal_PO_Number($external_PO_Number)
            ->setStatutory_Invoice_Type_Reference($statutory_Invoice_Type_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setDocument_Link($document_Link)
            ->setMemo($memo)
            ->setApprover_Reference($approver_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setAdditional_Type_Reference($additional_Type_Reference)
            ->setReference_Number($reference_Number)
            ->setOriginating_Country_Payment_Purpose_Reference($originating_Country_Payment_Purpose_Reference)
            ->setReceiving_Country_Payment_Purpose_Reference($receiving_Country_Payment_Purpose_Reference)
            ->setHandling_Code_Reference($handling_Code_Reference)
            ->setPrepaid($prepaid)
            ->setPrepayment_Release_Type_Reference($prepayment_Release_Type_Reference)
            ->setRelease_Date($release_Date)
            ->setFrequency_Reference($frequency_Reference)
            ->setNumber_of_Installments($number_of_Installments)
            ->setUse_Invoice_Date($use_Invoice_Date)
            ->setFrom_Date($from_Date)
            ->setRetention_Memo($retention_Memo)
            ->setAdditional_Fields_Data_Reference($additional_Fields_Data_Reference)
            ->setCurrency_Rate_Data($currency_Rate_Data)
            ->setAttachment_Data($attachment_Data)
            ->setTax_Code_Data($tax_Code_Data)
            ->setInvoice_Line_Replacement_Data($invoice_Line_Replacement_Data)
            ->setRetention_Release_Line_Data($retention_Release_Line_Data)
            ->setSupplier_Invoice_Intercompany_Sub_Process($supplier_Invoice_Intercompany_Sub_Process)
            ->setSupplier_Invoice_Prepaid_Amortization_Schedule($supplier_Invoice_Prepaid_Amortization_Schedule)
            ->setWork_Queue_Information_Data($work_Queue_Information_Data);
    }
    /**
     * Get Supplier_Invoice_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_ID()
    {
        return $this->Supplier_Invoice_ID;
    }
    /**
     * Set Supplier_Invoice_ID value
     * @param string $supplier_Invoice_ID
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Invoice_ID($supplier_Invoice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_ID) && !is_string($supplier_Invoice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_ID, true), gettype($supplier_Invoice_ID)), __LINE__);
        }
        $this->Supplier_Invoice_ID = $supplier_Invoice_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Invoice_Number value
     * @return string|null
     */
    public function getInvoice_Number()
    {
        return $this->Invoice_Number;
    }
    /**
     * Set Invoice_Number value
     * @param string $invoice_Number
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setInvoice_Number($invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Number) && !is_string($invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Number, true), gettype($invoice_Number)), __LINE__);
        }
        $this->Invoice_Number = $invoice_Number;
        return $this;
    }
    /**
     * Get External_Supplier_Invoice_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_Supplier_Invoice_Source_Reference()
    {
        return $this->External_Supplier_Invoice_Source_Reference;
    }
    /**
     * Set External_Supplier_Invoice_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setExternal_Supplier_Invoice_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null)
    {
        $this->External_Supplier_Invoice_Source_Reference = $external_Supplier_Invoice_Source_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Payment_Practices value
     * @return bool|null
     */
    public function getPayment_Practices()
    {
        return $this->Payment_Practices;
    }
    /**
     * Set Payment_Practices value
     * @param bool $payment_Practices
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setPayment_Practices($payment_Practices = null)
    {
        // validation for constraint: boolean
        if (!is_null($payment_Practices) && !is_bool($payment_Practices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payment_Practices, true), gettype($payment_Practices)), __LINE__);
        }
        $this->Payment_Practices = $payment_Practices;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return isset($this->Supplier_Reference) ? $this->Supplier_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Contingent_Worker_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Contingent_Worker_Reference)
        if ('' !== ($supplier_ReferenceChoiceErrorMessage = self::validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Reference) || (is_array($supplier_Reference) && empty($supplier_Reference))) {
            unset($this->Supplier_Reference);
        } else {
            $this->Supplier_Reference = $supplier_Reference;
        }
        return $this;
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\Contingent_WorkerObjectType|null
     */
    public function getContingent_Worker_Reference()
    {
        return isset($this->Contingent_Worker_Reference) ? $this->Contingent_Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setContingent_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContingent_Worker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Contingent_Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Contingent_Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Contingent_Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setContingent_Worker_Reference(\StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Contingent_Worker_Reference)
        if ('' !== ($contingent_Worker_ReferenceChoiceErrorMessage = self::validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($contingent_Worker_Reference))) {
            throw new \InvalidArgumentException($contingent_Worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($contingent_Worker_Reference) || (is_array($contingent_Worker_Reference) && empty($contingent_Worker_Reference))) {
            unset($this->Contingent_Worker_Reference);
        } else {
            $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return $this->Supplier_Connection_Reference;
    }
    /**
     * Set Supplier_Connection_Reference value
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Use_Default_Supplier_Connection value
     * @return bool|null
     */
    public function getUse_Default_Supplier_Connection()
    {
        return $this->Use_Default_Supplier_Connection;
    }
    /**
     * Set Use_Default_Supplier_Connection value
     * @param bool $use_Default_Supplier_Connection
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setUse_Default_Supplier_Connection($use_Default_Supplier_Connection = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Default_Supplier_Connection) && !is_bool($use_Default_Supplier_Connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Default_Supplier_Connection, true), gettype($use_Default_Supplier_Connection)), __LINE__);
        }
        $this->Use_Default_Supplier_Connection = $use_Default_Supplier_Connection;
        return $this;
    }
    /**
     * Get Default_Tax_Option_Reference value
     * @return \StructType\Tax_OptionObjectType|null
     */
    public function getDefault_Tax_Option_Reference()
    {
        return $this->Default_Tax_Option_Reference;
    }
    /**
     * Set Default_Tax_Option_Reference value
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setDefault_Tax_Option_Reference(\StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null)
    {
        $this->Default_Tax_Option_Reference = $default_Tax_Option_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_ID_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_ID_Reference()
    {
        return $this->{'Ship-To_Address_ID_Reference'};
    }
    /**
     * Set Ship_To_Address_ID_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setShip_To_Address_ID_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference = null)
    {
        $this->Ship_To_Address_ID_Reference = $this->{'Ship-To_Address_ID_Reference'} = $ship_To_Address_ID_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Default_Withholding_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Withholding_Tax_Code_Reference()
    {
        return $this->Default_Withholding_Tax_Code_Reference;
    }
    /**
     * Set Default_Withholding_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setDefault_Withholding_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null)
    {
        $this->Default_Withholding_Tax_Code_Reference = $default_Withholding_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Invoice_Received_Date value
     * @return string|null
     */
    public function getInvoice_Received_Date()
    {
        return $this->Invoice_Received_Date;
    }
    /**
     * Set Invoice_Received_Date value
     * @param string $invoice_Received_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setInvoice_Received_Date($invoice_Received_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Received_Date) && !is_string($invoice_Received_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Received_Date, true), gettype($invoice_Received_Date)), __LINE__);
        }
        $this->Invoice_Received_Date = $invoice_Received_Date;
        return $this;
    }
    /**
     * Get Due_Date_Override value
     * @return string|null
     */
    public function getDue_Date_Override()
    {
        return $this->Due_Date_Override;
    }
    /**
     * Set Due_Date_Override value
     * @param string $due_Date_Override
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setDue_Date_Override($due_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date_Override) && !is_string($due_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date_Override, true), gettype($due_Date_Override)), __LINE__);
        }
        $this->Due_Date_Override = $due_Date_Override;
        return $this;
    }
    /**
     * Get Accounting_Date_Override value
     * @return string|null
     */
    public function getAccounting_Date_Override()
    {
        return $this->Accounting_Date_Override;
    }
    /**
     * Set Accounting_Date_Override value
     * @param string $accounting_Date_Override
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setAccounting_Date_Override($accounting_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date_Override) && !is_string($accounting_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date_Override, true), gettype($accounting_Date_Override)), __LINE__);
        }
        $this->Accounting_Date_Override = $accounting_Date_Override;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get On_Hold value
     * @return bool|null
     */
    public function getOn_Hold()
    {
        return $this->On_Hold;
    }
    /**
     * Set On_Hold value
     * @param bool $on_Hold
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setOn_Hold($on_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($on_Hold) && !is_bool($on_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($on_Hold, true), gettype($on_Hold)), __LINE__);
        }
        $this->On_Hold = $on_Hold;
        return $this;
    }
    /**
     * Get Control_Amount_Total value
     * @return float|null
     */
    public function getControl_Amount_Total()
    {
        return $this->Control_Amount_Total;
    }
    /**
     * Set Control_Amount_Total value
     * @param float $control_Amount_Total
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setControl_Amount_Total($control_Amount_Total = null)
    {
        // validation for constraint: float
        if (!is_null($control_Amount_Total) && !(is_float($control_Amount_Total) || is_numeric($control_Amount_Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($control_Amount_Total, true), gettype($control_Amount_Total)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($control_Amount_Total) && mb_strlen(mb_substr($control_Amount_Total, false !== mb_strpos($control_Amount_Total, '.') ? mb_strpos($control_Amount_Total, '.') + 1 : mb_strlen($control_Amount_Total))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($control_Amount_Total, true), mb_strlen(mb_substr($control_Amount_Total, mb_strpos($control_Amount_Total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($control_Amount_Total) && mb_strlen(preg_replace('/(\D)/', '', $control_Amount_Total)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($control_Amount_Total, true), mb_strlen(preg_replace('/(\D)/', '', $control_Amount_Total))), __LINE__);
        }
        $this->Control_Amount_Total = $control_Amount_Total;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Other_Charges value
     * @return float|null
     */
    public function getOther_Charges()
    {
        return $this->Other_Charges;
    }
    /**
     * Set Other_Charges value
     * @param float $other_Charges
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setOther_Charges($other_Charges = null)
    {
        // validation for constraint: float
        if (!is_null($other_Charges) && !(is_float($other_Charges) || is_numeric($other_Charges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_Charges, true), gettype($other_Charges)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($other_Charges) && mb_strlen(mb_substr($other_Charges, false !== mb_strpos($other_Charges, '.') ? mb_strpos($other_Charges, '.') + 1 : mb_strlen($other_Charges))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($other_Charges, true), mb_strlen(mb_substr($other_Charges, mb_strpos($other_Charges, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($other_Charges) && mb_strlen(preg_replace('/(\D)/', '', $other_Charges)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($other_Charges, true), mb_strlen(preg_replace('/(\D)/', '', $other_Charges))), __LINE__);
        }
        $this->Other_Charges = $other_Charges;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Reference value
     * @return \StructType\Worktag_Split_TemplateObjectType|null
     */
    public function getWorktag_Split_Template_Reference()
    {
        return $this->Worktag_Split_Template_Reference;
    }
    /**
     * Set Worktag_Split_Template_Reference value
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setWorktag_Split_Template_Reference(\StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null)
    {
        $this->Worktag_Split_Template_Reference = $worktag_Split_Template_Reference;
        return $this;
    }
    /**
     * Get Tax_Only value
     * @return bool|null
     */
    public function getTax_Only()
    {
        return $this->Tax_Only;
    }
    /**
     * Set Tax_Only value
     * @param bool $tax_Only
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setTax_Only($tax_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($tax_Only) && !is_bool($tax_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tax_Only, true), gettype($tax_Only)), __LINE__);
        }
        $this->Tax_Only = $tax_Only;
        return $this;
    }
    /**
     * Get Referenced_Invoices_Reference value
     * @return \StructType\Supplier_InvoiceObjectType[]|null
     */
    public function getReferenced_Invoices_Reference()
    {
        return $this->Referenced_Invoices_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenced_Invoices_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenced_Invoices_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenced_Invoices_ReferenceForArrayConstraintsFromSetReferenced_Invoices_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem instanceof \StructType\Supplier_InvoiceObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem) ? get_class($supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem), var_export($supplier_Invoice_HV_DataTypeReferenced_Invoices_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referenced_Invoices_Reference property can only contain items of type \StructType\Supplier_InvoiceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referenced_Invoices_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceObjectType[] $referenced_Invoices_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setReferenced_Invoices_Reference(array $referenced_Invoices_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenced_Invoices_ReferenceArrayErrorMessage = self::validateReferenced_Invoices_ReferenceForArrayConstraintsFromSetReferenced_Invoices_Reference($referenced_Invoices_Reference))) {
            throw new \InvalidArgumentException($referenced_Invoices_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Referenced_Invoices_Reference = $referenced_Invoices_Reference;
        return $this;
    }
    /**
     * Add item to Referenced_Invoices_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceObjectType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToReferenced_Invoices_Reference(\StructType\Supplier_InvoiceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_InvoiceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Referenced_Invoices_Reference property can only contain items of type \StructType\Supplier_InvoiceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referenced_Invoices_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Document_Received value
     * @return bool|null
     */
    public function getSupplier_Document_Received()
    {
        return $this->Supplier_Document_Received;
    }
    /**
     * Set Supplier_Document_Received value
     * @param bool $supplier_Document_Received
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Document_Received($supplier_Document_Received = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplier_Document_Received) && !is_bool($supplier_Document_Received)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplier_Document_Received, true), gettype($supplier_Document_Received)), __LINE__);
        }
        $this->Supplier_Document_Received = $supplier_Document_Received;
        return $this;
    }
    /**
     * Get Suppliers_Invoice_Number value
     * @return string|null
     */
    public function getSuppliers_Invoice_Number()
    {
        return $this->Suppliers_Invoice_Number;
    }
    /**
     * Set Suppliers_Invoice_Number value
     * @param string $suppliers_Invoice_Number
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSuppliers_Invoice_Number($suppliers_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($suppliers_Invoice_Number) && !is_string($suppliers_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppliers_Invoice_Number, true), gettype($suppliers_Invoice_Number)), __LINE__);
        }
        $this->Suppliers_Invoice_Number = $suppliers_Invoice_Number;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Statutory_Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getStatutory_Invoice_Type_Reference()
    {
        return $this->Statutory_Invoice_Type_Reference;
    }
    /**
     * Set Statutory_Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setStatutory_Invoice_Type_Reference(\StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null)
    {
        $this->Statutory_Invoice_Type_Reference = $statutory_Invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_Contract_BaseObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Approver_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getApprover_Reference()
    {
        return $this->Approver_Reference;
    }
    /**
     * Set Approver_Reference value
     * @param \StructType\WorkerObjectType $approver_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setApprover_Reference(\StructType\WorkerObjectType $approver_Reference = null)
    {
        $this->Approver_Reference = $approver_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Additional_Type_Reference value
     * @return \StructType\Additional_Reference_TypeObjectType|null
     */
    public function getAdditional_Type_Reference()
    {
        return $this->Additional_Type_Reference;
    }
    /**
     * Set Additional_Type_Reference value
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setAdditional_Type_Reference(\StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null)
    {
        $this->Additional_Type_Reference = $additional_Type_Reference;
        return $this;
    }
    /**
     * Get Reference_Number value
     * @return string|null
     */
    public function getReference_Number()
    {
        return $this->Reference_Number;
    }
    /**
     * Set Reference_Number value
     * @param string $reference_Number
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setReference_Number($reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reference_Number) && !is_string($reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference_Number, true), gettype($reference_Number)), __LINE__);
        }
        // validation for constraint: maxLength(140)
        if (!is_null($reference_Number) && mb_strlen($reference_Number) > 140) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 140', mb_strlen($reference_Number)), __LINE__);
        }
        $this->Reference_Number = $reference_Number;
        return $this;
    }
    /**
     * Get Originating_Country_Payment_Purpose_Reference value
     * @return \StructType\Payment_Purpose_CodeObjectType|null
     */
    public function getOriginating_Country_Payment_Purpose_Reference()
    {
        return $this->Originating_Country_Payment_Purpose_Reference;
    }
    /**
     * Set Originating_Country_Payment_Purpose_Reference value
     * @param \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setOriginating_Country_Payment_Purpose_Reference(\StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference = null)
    {
        $this->Originating_Country_Payment_Purpose_Reference = $originating_Country_Payment_Purpose_Reference;
        return $this;
    }
    /**
     * Get Receiving_Country_Payment_Purpose_Reference value
     * @return \StructType\Payment_Purpose_CodeObjectType|null
     */
    public function getReceiving_Country_Payment_Purpose_Reference()
    {
        return $this->Receiving_Country_Payment_Purpose_Reference;
    }
    /**
     * Set Receiving_Country_Payment_Purpose_Reference value
     * @param \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setReceiving_Country_Payment_Purpose_Reference(\StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference = null)
    {
        $this->Receiving_Country_Payment_Purpose_Reference = $receiving_Country_Payment_Purpose_Reference;
        return $this;
    }
    /**
     * Get Handling_Code_Reference value
     * @return \StructType\Payment_Handling_InstructionObjectType|null
     */
    public function getHandling_Code_Reference()
    {
        return $this->Handling_Code_Reference;
    }
    /**
     * Set Handling_Code_Reference value
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setHandling_Code_Reference(\StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null)
    {
        $this->Handling_Code_Reference = $handling_Code_Reference;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Prepayment_Release_Type_Reference value
     * @return \StructType\Prepaid_Amortization_TypeObjectType|null
     */
    public function getPrepayment_Release_Type_Reference()
    {
        return $this->Prepayment_Release_Type_Reference;
    }
    /**
     * Set Prepayment_Release_Type_Reference value
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setPrepayment_Release_Type_Reference(\StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null)
    {
        $this->Prepayment_Release_Type_Reference = $prepayment_Release_Type_Reference;
        return $this;
    }
    /**
     * Get Release_Date value
     * @return string|null
     */
    public function getRelease_Date()
    {
        return $this->Release_Date;
    }
    /**
     * Set Release_Date value
     * @param string $release_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setRelease_Date($release_Date = null)
    {
        // validation for constraint: string
        if (!is_null($release_Date) && !is_string($release_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release_Date, true), gettype($release_Date)), __LINE__);
        }
        $this->Release_Date = $release_Date;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Number_of_Installments value
     * @return float|null
     */
    public function getNumber_of_Installments()
    {
        return $this->Number_of_Installments;
    }
    /**
     * Set Number_of_Installments value
     * @param float $number_of_Installments
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setNumber_of_Installments($number_of_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Installments) && !(is_float($number_of_Installments) || is_numeric($number_of_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Installments, true), gettype($number_of_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Installments) && mb_strlen(mb_substr($number_of_Installments, false !== mb_strpos($number_of_Installments, '.') ? mb_strpos($number_of_Installments, '.') + 1 : mb_strlen($number_of_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Installments, true), mb_strlen(mb_substr($number_of_Installments, mb_strpos($number_of_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Installments) && $number_of_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments))), __LINE__);
        }
        $this->Number_of_Installments = $number_of_Installments;
        return $this;
    }
    /**
     * Get Use_Invoice_Date value
     * @return bool|null
     */
    public function getUse_Invoice_Date()
    {
        return $this->Use_Invoice_Date;
    }
    /**
     * Set Use_Invoice_Date value
     * @param bool $use_Invoice_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setUse_Invoice_Date($use_Invoice_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Date) && !is_bool($use_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Date, true), gettype($use_Invoice_Date)), __LINE__);
        }
        $this->Use_Invoice_Date = $use_Invoice_Date;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get Retention_Memo value
     * @return string|null
     */
    public function getRetention_Memo()
    {
        return $this->Retention_Memo;
    }
    /**
     * Set Retention_Memo value
     * @param string $retention_Memo
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setRetention_Memo($retention_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($retention_Memo) && !is_string($retention_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retention_Memo, true), gettype($retention_Memo)), __LINE__);
        }
        $this->Retention_Memo = $retention_Memo;
        return $this;
    }
    /**
     * Get Additional_Fields_Data_Reference value
     * @return \StructType\Configurable_Attributes_DataType[]|null
     */
    public function getAdditional_Fields_Data_Reference()
    {
        return $this->Additional_Fields_Data_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Fields_Data_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Fields_Data_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem instanceof \StructType\Configurable_Attributes_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem) ? get_class($supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem), var_export($supplier_Invoice_HV_DataTypeAdditional_Fields_Data_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setAdditional_Fields_Data_Reference(array $additional_Fields_Data_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Fields_Data_ReferenceArrayErrorMessage = self::validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference($additional_Fields_Data_Reference))) {
            throw new \InvalidArgumentException($additional_Fields_Data_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Fields_Data_Reference = $additional_Fields_Data_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToAdditional_Fields_Data_Reference(\StructType\Configurable_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configurable_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Fields_Data_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Rate_Data value
     * @return \StructType\Currency_Rate_DataType[]|null
     */
    public function getCurrency_Rate_Data()
    {
        return $this->Currency_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem instanceof \StructType\Currency_Rate_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem) ? get_class($supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem), var_export($supplier_Invoice_HV_DataTypeCurrency_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setCurrency_Rate_Data(array $currency_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_Rate_DataArrayErrorMessage = self::validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data($currency_Rate_Data))) {
            throw new \InvalidArgumentException($currency_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Currency_Rate_Data = $currency_Rate_Data;
        return $this;
    }
    /**
     * Add item to Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToCurrency_Rate_Data(\StructType\Currency_Rate_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency_Rate_DataType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Rate_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeAttachment_DataItem) ? get_class($supplier_Invoice_HV_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeAttachment_DataItem), var_export($supplier_Invoice_HV_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Tax_Code_Data value
     * @return \StructType\Taxable_Code_Application_DataType[]|null
     */
    public function getTax_Code_Data()
    {
        return $this->Tax_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeTax_Code_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeTax_Code_DataItem instanceof \StructType\Taxable_Code_Application_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeTax_Code_DataItem) ? get_class($supplier_Invoice_HV_DataTypeTax_Code_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeTax_Code_DataItem), var_export($supplier_Invoice_HV_DataTypeTax_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType[] $tax_Code_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setTax_Code_Data(array $tax_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Code_DataArrayErrorMessage = self::validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data($tax_Code_Data))) {
            throw new \InvalidArgumentException($tax_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Code_Data = $tax_Code_Data;
        return $this;
    }
    /**
     * Add item to Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToTax_Code_Data(\StructType\Taxable_Code_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Taxable_Code_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Line_Replacement_Data value
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType[]|null
     */
    public function getInvoice_Line_Replacement_Data()
    {
        return $this->Invoice_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Line_Replacement_DataForArrayConstraintsFromSetInvoice_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem instanceof \StructType\Supplier_Invoice_Line_Replacement__HV__DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem) ? get_class($supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem), var_export($supplier_Invoice_HV_DataTypeInvoice_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement__HV__DataType[] $invoice_Line_Replacement_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setInvoice_Line_Replacement_Data(array $invoice_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Line_Replacement_DataArrayErrorMessage = self::validateInvoice_Line_Replacement_DataForArrayConstraintsFromSetInvoice_Line_Replacement_Data($invoice_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($invoice_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Line_Replacement_Data = $invoice_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement__HV__DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToInvoice_Line_Replacement_Data(\StructType\Supplier_Invoice_Line_Replacement__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Replacement__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Retention_Release_Line_Data value
     * @return \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[]|null
     */
    public function getRetention_Release_Line_Data()
    {
        return $this->Retention_Release_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRetention_Release_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetention_Release_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetention_Release_Line_DataForArrayConstraintsFromSetRetention_Release_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem instanceof \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem) ? get_class($supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem), var_export($supplier_Invoice_HV_DataTypeRetention_Release_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Retention_Release_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Retention_Release_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[] $retention_Release_Line_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setRetention_Release_Line_Data(array $retention_Release_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($retention_Release_Line_DataArrayErrorMessage = self::validateRetention_Release_Line_DataForArrayConstraintsFromSetRetention_Release_Line_Data($retention_Release_Line_Data))) {
            throw new \InvalidArgumentException($retention_Release_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Retention_Release_Line_Data = $retention_Release_Line_Data;
        return $this;
    }
    /**
     * Add item to Retention_Release_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToRetention_Release_Line_Data(\StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Retention_Release_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Retention_Release_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Intercompany_Sub_Process value
     * @return \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType|null
     */
    public function getSupplier_Invoice_Intercompany_Sub_Process()
    {
        return $this->Supplier_Invoice_Intercompany_Sub_Process;
    }
    /**
     * Set Supplier_Invoice_Intercompany_Sub_Process value
     * @param \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Invoice_Intercompany_Sub_Process(\StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process = null)
    {
        $this->Supplier_Invoice_Intercompany_Sub_Process = $supplier_Invoice_Intercompany_Sub_Process;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[]|null
     */
    public function getSupplier_Invoice_Prepaid_Amortization_Schedule()
    {
        return $this->Supplier_Invoice_Prepaid_Amortization_Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Prepaid_Amortization_Schedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Prepaid_Amortization_Schedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Prepaid_Amortization_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Prepaid_Amortization_Schedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem instanceof \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) ? get_class($supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem), var_export($supplier_Invoice_HV_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Prepaid_Amortization_Schedule property can only contain items of type \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[] $supplier_Invoice_Prepaid_Amortization_Schedule
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setSupplier_Invoice_Prepaid_Amortization_Schedule(array $supplier_Invoice_Prepaid_Amortization_Schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Prepaid_Amortization_ScheduleArrayErrorMessage = self::validateSupplier_Invoice_Prepaid_Amortization_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Prepaid_Amortization_Schedule($supplier_Invoice_Prepaid_Amortization_Schedule))) {
            throw new \InvalidArgumentException($supplier_Invoice_Prepaid_Amortization_ScheduleArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Prepaid_Amortization_Schedule = $supplier_Invoice_Prepaid_Amortization_Schedule;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToSupplier_Invoice_Prepaid_Amortization_Schedule(\StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Prepaid_Amortization_Schedule property can only contain items of type \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Prepaid_Amortization_Schedule[] = $item;
        return $this;
    }
    /**
     * Get Work_Queue_Information_Data value
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType[]|null
     */
    public function getWork_Queue_Information_Data()
    {
        return $this->Work_Queue_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWork_Queue_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWork_Queue_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWork_Queue_Information_DataForArrayConstraintsFromSetWork_Queue_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem instanceof \StructType\Supplier_Invoice_Work_Queue_Information_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem) ? get_class($supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem), var_export($supplier_Invoice_HV_DataTypeWork_Queue_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Work_Queue_Information_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Work_Queue_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType[] $work_Queue_Information_Data
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function setWork_Queue_Information_Data(array $work_Queue_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($work_Queue_Information_DataArrayErrorMessage = self::validateWork_Queue_Information_DataForArrayConstraintsFromSetWork_Queue_Information_Data($work_Queue_Information_Data))) {
            throw new \InvalidArgumentException($work_Queue_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Work_Queue_Information_Data = $work_Queue_Information_Data;
        return $this;
    }
    /**
     * Add item to Work_Queue_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType $item
     * @return \StructType\Supplier_Invoice__HV__DataType
     */
    public function addToWork_Queue_Information_Data(\StructType\Supplier_Invoice_Work_Queue_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Work_Queue_Information_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Work_Queue_Information_Data[] = $item;
        return $this;
    }
}
