<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Validation_Configuration_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The External Transaction Source can only be EDI 810. | The Supplier Invoice System Validation Reference does not match the Supplier Invoice Validation Configuration. | Supplier Invoice Validation Configuration replacement data.
 * @subpackage Structs
 */
class Supplier_Invoice_Validation_Configuration_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Supplier Invoice Validation Configuration.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Supplier_Invoice_System_Validation_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice System Validation Reference.
     * @var \StructType\Supplier_Invoice_System_ValidationObjectType
     */
    public $Supplier_Invoice_System_Validation_Reference;
    /**
     * The External_Transaction_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Transaction Source reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType[]
     */
    public $External_Transaction_Source_Reference;
    /**
     * Constructor method for Supplier_Invoice_Validation_Configuration_DataType
     * @uses Supplier_Invoice_Validation_Configuration_DataType::setID()
     * @uses Supplier_Invoice_Validation_Configuration_DataType::setSupplier_Invoice_System_Validation_Reference()
     * @uses Supplier_Invoice_Validation_Configuration_DataType::setExternal_Transaction_Source_Reference()
     * @param string $iD
     * @param \StructType\Supplier_Invoice_System_ValidationObjectType $supplier_Invoice_System_Validation_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Transaction_Source_Reference
     */
    public function __construct($iD = null, \StructType\Supplier_Invoice_System_ValidationObjectType $supplier_Invoice_System_Validation_Reference = null, array $external_Transaction_Source_Reference = array())
    {
        $this
            ->setID($iD)
            ->setSupplier_Invoice_System_Validation_Reference($supplier_Invoice_System_Validation_Reference)
            ->setExternal_Transaction_Source_Reference($external_Transaction_Source_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Supplier_Invoice_Validation_Configuration_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Supplier_Invoice_System_Validation_Reference value
     * @return \StructType\Supplier_Invoice_System_ValidationObjectType|null
     */
    public function getSupplier_Invoice_System_Validation_Reference()
    {
        return $this->Supplier_Invoice_System_Validation_Reference;
    }
    /**
     * Set Supplier_Invoice_System_Validation_Reference value
     * @param \StructType\Supplier_Invoice_System_ValidationObjectType $supplier_Invoice_System_Validation_Reference
     * @return \StructType\Supplier_Invoice_Validation_Configuration_DataType
     */
    public function setSupplier_Invoice_System_Validation_Reference(\StructType\Supplier_Invoice_System_ValidationObjectType $supplier_Invoice_System_Validation_Reference = null)
    {
        $this->Supplier_Invoice_System_Validation_Reference = $supplier_Invoice_System_Validation_Reference;
        return $this;
    }
    /**
     * Get External_Transaction_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType[]|null
     */
    public function getExternal_Transaction_Source_Reference()
    {
        return $this->External_Transaction_Source_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Transaction_Source_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Transaction_Source_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Transaction_Source_ReferenceForArrayConstraintsFromSetExternal_Transaction_Source_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem instanceof \StructType\External_Transaction_Source__All_ObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem) ? get_class($supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem), var_export($supplier_Invoice_Validation_Configuration_DataTypeExternal_Transaction_Source_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Transaction_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Transaction_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Transaction_Source_Reference
     * @return \StructType\Supplier_Invoice_Validation_Configuration_DataType
     */
    public function setExternal_Transaction_Source_Reference(array $external_Transaction_Source_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Transaction_Source_ReferenceArrayErrorMessage = self::validateExternal_Transaction_Source_ReferenceForArrayConstraintsFromSetExternal_Transaction_Source_Reference($external_Transaction_Source_Reference))) {
            throw new \InvalidArgumentException($external_Transaction_Source_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->External_Transaction_Source_Reference = $external_Transaction_Source_Reference;
        return $this;
    }
    /**
     * Add item to External_Transaction_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType $item
     * @return \StructType\Supplier_Invoice_Validation_Configuration_DataType
     */
    public function addToExternal_Transaction_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source__All_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The External_Transaction_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Transaction_Source_Reference[] = $item;
        return $this;
    }
}
