<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Item_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Receipt Adjustment Item Line data. A Receipt Adjustment may have multiple Item Lines.
 * @subpackage Structs
 */
class Receipt_Adjustment_Item_Line_DataType extends AbstractStructBase
{
    /**
     * The Receipt_Adjustment_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an existing Receipt Adjustment Line
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Receipt_Adjustment_Line_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of Item on Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the item.This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Purchase Order Line for the Receipt Line that this Receipt Adjustment Line adjusts. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Receipt_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Receipt Line that this Receipt Adjustment Line adjusts.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Receipt_Line_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Contract Line associated to the Original Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Advanced_Shipment_Notice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Advanced Ship Notice Line related to Original Receipt Line being adjusted. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_Notice_LineObjectType
     */
    public $Advanced_Shipment_Notice_Line_Reference;
    /**
     * The Actual_Quantity_Received
     * Meta information extracted from the WSDL
     * - documentation: The Actual Quantity Received for this Line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Actual_Quantity_Received;
    /**
     * The Original_Quantity_Received
     * Meta information extracted from the WSDL
     * - documentation: The Original Quantity received on the Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Original_Quantity_Received;
    /**
     * The Unit_Of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Unit Of Measure for Item Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_Of_Measure_Reference;
    /**
     * The Receipt_Adjustment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Adjustment Reason for this Receipt Adjustment Line
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Receipt_Adjustment_Reason_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Receipt Adjustment Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category on the Receipt Adjustment Line.This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Delivery_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Delivery Type for the Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Delivery_TypeObjectType
     */
    public $Delivery_Type_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address for the Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Worker that is the Ship-To Contact for the Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Receipt_Line_Lot_Data
     * Meta information extracted from the WSDL
     * - documentation: Receipt Line Item Lot Quantity Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Item_Line_Lot_DataType[]
     */
    public $Receipt_Line_Lot_Data;
    /**
     * The Receipt_Line_Split_Data
     * Meta information extracted from the WSDL
     * - documentation: Item Receipt Line Split Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Receipt_Line_Split_DataType[]
     */
    public $Receipt_Line_Split_Data;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags on the Receipt Line. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Receipt_Adjustment_Item_Line_DataType
     * @uses Receipt_Adjustment_Item_Line_DataType::setReceipt_Adjustment_Line_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setItem_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setItem_Description()
     * @uses Receipt_Adjustment_Item_Line_DataType::setPurchase_Order_Line_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setReceipt_Line_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setSupplier_Contract_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setAdvanced_Shipment_Notice_Line_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setActual_Quantity_Received()
     * @uses Receipt_Adjustment_Item_Line_DataType::setOriginal_Quantity_Received()
     * @uses Receipt_Adjustment_Item_Line_DataType::setUnit_Of_Measure_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setReceipt_Adjustment_Reason_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setMemo()
     * @uses Receipt_Adjustment_Item_Line_DataType::setSpend_Category_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setUnit_Cost()
     * @uses Receipt_Adjustment_Item_Line_DataType::setExtended_Amount()
     * @uses Receipt_Adjustment_Item_Line_DataType::setDelivery_Type_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setDeliver_To_Location_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setShip_To_Address_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setShip_To_Contact_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setReceipt_Line_Lot_Data()
     * @uses Receipt_Adjustment_Item_Line_DataType::setReceipt_Line_Split_Data()
     * @uses Receipt_Adjustment_Item_Line_DataType::setWorktag_Reference()
     * @uses Receipt_Adjustment_Item_Line_DataType::setAttachment_Data()
     * @param \StructType\Unique_IdentifierObjectType $receipt_Adjustment_Line_Reference
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $item_Description
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Reference
     * @param \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Shipment_Notice_Line_Reference
     * @param float $actual_Quantity_Received
     * @param float $original_Quantity_Received
     * @param \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @param string $memo
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\Receipt_Adjustment_Item_Line_Lot_DataType[] $receipt_Line_Lot_Data
     * @param \StructType\Item_Receipt_Line_Split_DataType[] $receipt_Line_Split_Data
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $receipt_Adjustment_Line_Reference = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $item_Description = null, \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Reference = null, \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Shipment_Notice_Line_Reference = null, $actual_Quantity_Received = null, $original_Quantity_Received = null, \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference = null, \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null, $memo = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, $unit_Cost = null, $extended_Amount = null, \StructType\Delivery_TypeObjectType $delivery_Type_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, array $receipt_Line_Lot_Data = array(), array $receipt_Line_Split_Data = array(), array $worktag_Reference = array(), array $attachment_Data = array())
    {
        $this
            ->setReceipt_Adjustment_Line_Reference($receipt_Adjustment_Line_Reference)
            ->setItem_Reference($item_Reference)
            ->setItem_Description($item_Description)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setReceipt_Line_Reference($receipt_Line_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setAdvanced_Shipment_Notice_Line_Reference($advanced_Shipment_Notice_Line_Reference)
            ->setActual_Quantity_Received($actual_Quantity_Received)
            ->setOriginal_Quantity_Received($original_Quantity_Received)
            ->setUnit_Of_Measure_Reference($unit_Of_Measure_Reference)
            ->setReceipt_Adjustment_Reason_Reference($receipt_Adjustment_Reason_Reference)
            ->setMemo($memo)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setDelivery_Type_Reference($delivery_Type_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setReceipt_Line_Lot_Data($receipt_Line_Lot_Data)
            ->setReceipt_Line_Split_Data($receipt_Line_Split_Data)
            ->setWorktag_Reference($worktag_Reference)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Receipt_Adjustment_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReceipt_Adjustment_Line_Reference()
    {
        return $this->Receipt_Adjustment_Line_Reference;
    }
    /**
     * Set Receipt_Adjustment_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $receipt_Adjustment_Line_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setReceipt_Adjustment_Line_Reference(\StructType\Unique_IdentifierObjectType $receipt_Adjustment_Line_Reference = null)
    {
        $this->Receipt_Adjustment_Line_Reference = $receipt_Adjustment_Line_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Receipt_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReceipt_Line_Reference()
    {
        return $this->Receipt_Line_Reference;
    }
    /**
     * Set Receipt_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setReceipt_Line_Reference(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null)
    {
        $this->Receipt_Line_Reference = $receipt_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Advanced_Shipment_Notice_Line_Reference value
     * @return \StructType\Advanced_Ship_Notice_LineObjectType|null
     */
    public function getAdvanced_Shipment_Notice_Line_Reference()
    {
        return $this->Advanced_Shipment_Notice_Line_Reference;
    }
    /**
     * Set Advanced_Shipment_Notice_Line_Reference value
     * @param \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Shipment_Notice_Line_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setAdvanced_Shipment_Notice_Line_Reference(\StructType\Advanced_Ship_Notice_LineObjectType $advanced_Shipment_Notice_Line_Reference = null)
    {
        $this->Advanced_Shipment_Notice_Line_Reference = $advanced_Shipment_Notice_Line_Reference;
        return $this;
    }
    /**
     * Get Actual_Quantity_Received value
     * @return float|null
     */
    public function getActual_Quantity_Received()
    {
        return $this->Actual_Quantity_Received;
    }
    /**
     * Set Actual_Quantity_Received value
     * @param float $actual_Quantity_Received
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setActual_Quantity_Received($actual_Quantity_Received = null)
    {
        // validation for constraint: float
        if (!is_null($actual_Quantity_Received) && !(is_float($actual_Quantity_Received) || is_numeric($actual_Quantity_Received))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actual_Quantity_Received, true), gettype($actual_Quantity_Received)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($actual_Quantity_Received) && mb_strlen(mb_substr($actual_Quantity_Received, false !== mb_strpos($actual_Quantity_Received, '.') ? mb_strpos($actual_Quantity_Received, '.') + 1 : mb_strlen($actual_Quantity_Received))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($actual_Quantity_Received, true), mb_strlen(mb_substr($actual_Quantity_Received, mb_strpos($actual_Quantity_Received, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($actual_Quantity_Received) && mb_strlen(preg_replace('/(\D)/', '', $actual_Quantity_Received)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($actual_Quantity_Received, true), mb_strlen(preg_replace('/(\D)/', '', $actual_Quantity_Received))), __LINE__);
        }
        $this->Actual_Quantity_Received = $actual_Quantity_Received;
        return $this;
    }
    /**
     * Get Original_Quantity_Received value
     * @return float|null
     */
    public function getOriginal_Quantity_Received()
    {
        return $this->Original_Quantity_Received;
    }
    /**
     * Set Original_Quantity_Received value
     * @param float $original_Quantity_Received
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setOriginal_Quantity_Received($original_Quantity_Received = null)
    {
        // validation for constraint: float
        if (!is_null($original_Quantity_Received) && !(is_float($original_Quantity_Received) || is_numeric($original_Quantity_Received))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($original_Quantity_Received, true), gettype($original_Quantity_Received)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($original_Quantity_Received) && mb_strlen(mb_substr($original_Quantity_Received, false !== mb_strpos($original_Quantity_Received, '.') ? mb_strpos($original_Quantity_Received, '.') + 1 : mb_strlen($original_Quantity_Received))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($original_Quantity_Received, true), mb_strlen(mb_substr($original_Quantity_Received, mb_strpos($original_Quantity_Received, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($original_Quantity_Received) && mb_strlen(preg_replace('/(\D)/', '', $original_Quantity_Received)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($original_Quantity_Received, true), mb_strlen(preg_replace('/(\D)/', '', $original_Quantity_Received))), __LINE__);
        }
        $this->Original_Quantity_Received = $original_Quantity_Received;
        return $this;
    }
    /**
     * Get Unit_Of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_Of_Measure_Reference()
    {
        return $this->Unit_Of_Measure_Reference;
    }
    /**
     * Set Unit_Of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setUnit_Of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference = null)
    {
        $this->Unit_Of_Measure_Reference = $unit_Of_Measure_Reference;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reason_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReceipt_Adjustment_Reason_Reference()
    {
        return $this->Receipt_Adjustment_Reason_Reference;
    }
    /**
     * Set Receipt_Adjustment_Reason_Reference value
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setReceipt_Adjustment_Reason_Reference(\StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null)
    {
        $this->Receipt_Adjustment_Reason_Reference = $receipt_Adjustment_Reason_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Delivery_Type_Reference value
     * @return \StructType\Delivery_TypeObjectType|null
     */
    public function getDelivery_Type_Reference()
    {
        return $this->Delivery_Type_Reference;
    }
    /**
     * Set Delivery_Type_Reference value
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setDelivery_Type_Reference(\StructType\Delivery_TypeObjectType $delivery_Type_Reference = null)
    {
        $this->Delivery_Type_Reference = $delivery_Type_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->{'Ship-To_Contact_Reference'};
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $this->{'Ship-To_Contact_Reference'} = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Receipt_Line_Lot_Data value
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType[]|null
     */
    public function getReceipt_Line_Lot_Data()
    {
        return $this->Receipt_Line_Lot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Line_Lot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Line_Lot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Line_Lot_DataForArrayConstraintsFromSetReceipt_Line_Lot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem instanceof \StructType\Receipt_Adjustment_Item_Line_Lot_DataType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem) ? get_class($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem), var_export($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Lot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Line_Lot_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_Lot_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Line_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_Lot_DataType[] $receipt_Line_Lot_Data
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setReceipt_Line_Lot_Data(array $receipt_Line_Lot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Line_Lot_DataArrayErrorMessage = self::validateReceipt_Line_Lot_DataForArrayConstraintsFromSetReceipt_Line_Lot_Data($receipt_Line_Lot_Data))) {
            throw new \InvalidArgumentException($receipt_Line_Lot_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Line_Lot_Data = $receipt_Line_Lot_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Line_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_Lot_DataType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function addToReceipt_Line_Lot_Data(\StructType\Receipt_Adjustment_Item_Line_Lot_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Item_Line_Lot_DataType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Line_Lot_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_Lot_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Line_Lot_Data[] = $item;
        return $this;
    }
    /**
     * Get Receipt_Line_Split_Data value
     * @return \StructType\Item_Receipt_Line_Split_DataType[]|null
     */
    public function getReceipt_Line_Split_Data()
    {
        return $this->Receipt_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Line_Split_DataForArrayConstraintsFromSetReceipt_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem instanceof \StructType\Item_Receipt_Line_Split_DataType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem) ? get_class($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem), var_export($receipt_Adjustment_Item_Line_DataTypeReceipt_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Line_Split_Data property can only contain items of type \StructType\Item_Receipt_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Split_DataType[] $receipt_Line_Split_Data
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setReceipt_Line_Split_Data(array $receipt_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Line_Split_DataArrayErrorMessage = self::validateReceipt_Line_Split_DataForArrayConstraintsFromSetReceipt_Line_Split_Data($receipt_Line_Split_Data))) {
            throw new \InvalidArgumentException($receipt_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Line_Split_Data = $receipt_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Split_DataType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function addToReceipt_Line_Split_Data(\StructType\Item_Receipt_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Receipt_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Line_Split_Data property can only contain items of type \StructType\Item_Receipt_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem) ? get_class($receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem), var_export($receipt_Adjustment_Item_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem) ? get_class($receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem), var_export($receipt_Adjustment_Item_Line_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
