<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Hierarchy_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't move the referenced Project into the current Project Hierarchy because the Project is inactive. | Parent of Project Hierarchy must be of the same hierarchy type. | Enable as Optional Hierarchy field can only be changed
 * during the review process | The Optional Projects field must be empty for primary project hierarchies. | The Included Projects field must be empty for optional project hierarchies. | Projects cannot be added to this Project Hierarchy as some of them
 * are already a part of another project hierarchy which uses different Resource Plan and Resource Plan Lines. | Projects cannot be added to this hierarchy as few Projects to Include have associated billable hours. | A Project Hierarchy cannot be moved
 * under a new parent hierarchy if it will change the Resource Plan whose Resource Plan Lines are in use by Task Resources | A Resource Plan cannot be removed from a Project Hierarchy if Resource Plan Lines are in use by Task Resources. | A top-level
 * hierarchy structure exists and is enforced for this parent hierarchy. Please unenforce the top-level hierarchy structure first before selecting this as a parent hierarchy. | A top-level Hierarchy Structure exists and is enforced for this hierarchy.
 * Please unenforce the top-level Hierarchy Structure first before changing the parent hierarchy. | A top-level Hierarchy Structure exists and is enforced for this hierarchy. Please unenforce the top-level Hierarchy Structure first before changing the
 * Organization Subtype for this hierarchy. | A Resource Plan cannot be reused across multiple Projects or Project Hierarchies. The Resource Plan specified is already assigned to a project or project hierarchy. | The current project hierarchy cannot be
 * updated because it is inactive or it is inactivated by another project hierarchy. | A hierarchy structure is defined on this organization. Please delete the hierarchy structure before assigning any superior organization. | The parent project
 * hierarchy selected must be in approved status. | Project Hierarchy WWS Data element used in Submit Workday Project Hierarchy web service task.
 * @subpackage Structs
 */
class Project_Hierarchy_WWS_DataType extends AbstractStructBase
{
    /**
     * The Project_Hierarchy_ID
     * Meta information extracted from the WSDL
     * - documentation: A valid Project Hierarchy Reference Id is required.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Hierarchy_ID;
    /**
     * The Project_Hierarchy_Name
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy Name for Submit Workday Project Hierarchy Web Service Task.
     * - maxOccurs: 1
     * @var string
     */
    public $Project_Hierarchy_Name;
    /**
     * The Include_Project_Hierarchy_ID_in_Name
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating if the Project Hierarchy ID will be included in the display of the Project Hierarchy Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Project_Hierarchy_ID_in_Name;
    /**
     * The Enable_as_Optional_Hierarchy
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate an optional project hierarchy.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_as_Optional_Hierarchy;
    /**
     * The Project_Hierarchy_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: This information is for outbound purposes only. Workday doesn't process this information for inbound Web Service requests.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Project_Hierarchy_Status_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates the project hierarchy is inactive. A project hierarchy may also be inactivated by a parent project hierarchy as indicated by the 'Inactivated By Hierarchy Reference'. In which case, the current project hierarchy is
     * considered Inactive even though this Boolean returns False. Changes to an inactive hierarchy are ignored. Reactivating a project hierarchy can only be done on the hierarchy if it was explicitly marked 'Inactive' or by reactivating the hierarchy that
     * made the current hierarchy inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Inactivated_By_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Indicates the project hierarchy that inactivated the current project hierarchy. This field is provided as a reference only and cannot be updated from this web service operation.
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Inactivated_By_Hierarchy_Reference;
    /**
     * The Organization_Subtype_Reference
     * Meta information extracted from the WSDL
     * - documentation: Organization Subtype is not valid for Organization Type | Reference to an existing Organization Subtype valid for project hierarchies.
     * - minOccurs: 0
     * @var \StructType\Organization_SubtypeObjectType
     */
    public $Organization_Subtype_Reference;
    /**
     * The Parent_Reference
     * Meta information extracted from the WSDL
     * - documentation: Parent project hierarchy for the project hierarchy created from Submit Workday Project Hierarchy web service task.
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Parent_Reference;
    /**
     * The Project_Resource_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource plan for the project hierarchy create via Submit Workday Project Hierarchy web service task.
     * - minOccurs: 0
     * @var \StructType\Project_Resource_PlanObjectType
     */
    public $Project_Resource_Plan_Reference;
    /**
     * The Project_Scenario_Groups_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: The project scenario groups that are secured by this project hierarchy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Scenario_GroupObjectType[]
     */
    public $Project_Scenario_Groups_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Project hierarchy description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Reporting_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy Reporting Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Reporting_Currency_Reference;
    /**
     * The Included_Projects_Reference
     * Meta information extracted from the WSDL
     * - documentation: Projects rolled up under project hierarchy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType[]
     */
    public $Included_Projects_Reference;
    /**
     * The Included_Projects_in_Optional_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Projects rolled up under optional project hierarchy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType[]
     */
    public $Included_Projects_in_Optional_Hierarchy_Reference;
    /**
     * Constructor method for Project_Hierarchy_WWS_DataType
     * @uses Project_Hierarchy_WWS_DataType::setProject_Hierarchy_ID()
     * @uses Project_Hierarchy_WWS_DataType::setProject_Hierarchy_Name()
     * @uses Project_Hierarchy_WWS_DataType::setInclude_Project_Hierarchy_ID_in_Name()
     * @uses Project_Hierarchy_WWS_DataType::setEnable_as_Optional_Hierarchy()
     * @uses Project_Hierarchy_WWS_DataType::setProject_Hierarchy_Status_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setInactive()
     * @uses Project_Hierarchy_WWS_DataType::setInactivated_By_Hierarchy_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setOrganization_Subtype_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setParent_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setProject_Resource_Plan_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setProject_Scenario_Groups_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setDescription()
     * @uses Project_Hierarchy_WWS_DataType::setReporting_Currency_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setIncluded_Projects_Reference()
     * @uses Project_Hierarchy_WWS_DataType::setIncluded_Projects_in_Optional_Hierarchy_Reference()
     * @param string $project_Hierarchy_ID
     * @param string $project_Hierarchy_Name
     * @param bool $include_Project_Hierarchy_ID_in_Name
     * @param bool $enable_as_Optional_Hierarchy
     * @param \StructType\Document_StatusObjectType $project_Hierarchy_Status_Reference
     * @param bool $inactive
     * @param \StructType\Project_HierarchyObjectType $inactivated_By_Hierarchy_Reference
     * @param \StructType\Organization_SubtypeObjectType $organization_Subtype_Reference
     * @param \StructType\Project_HierarchyObjectType $parent_Reference
     * @param \StructType\Project_Resource_PlanObjectType $project_Resource_Plan_Reference
     * @param \StructType\Project_Scenario_GroupObjectType[] $project_Scenario_Groups_Reference
     * @param string $description
     * @param \StructType\CurrencyObjectType $reporting_Currency_Reference
     * @param \StructType\ProjectObjectType[] $included_Projects_Reference
     * @param \StructType\ProjectObjectType[] $included_Projects_in_Optional_Hierarchy_Reference
     */
    public function __construct($project_Hierarchy_ID = null, $project_Hierarchy_Name = null, $include_Project_Hierarchy_ID_in_Name = null, $enable_as_Optional_Hierarchy = null, \StructType\Document_StatusObjectType $project_Hierarchy_Status_Reference = null, $inactive = null, \StructType\Project_HierarchyObjectType $inactivated_By_Hierarchy_Reference = null, \StructType\Organization_SubtypeObjectType $organization_Subtype_Reference = null, \StructType\Project_HierarchyObjectType $parent_Reference = null, \StructType\Project_Resource_PlanObjectType $project_Resource_Plan_Reference = null, array $project_Scenario_Groups_Reference = array(), $description = null, \StructType\CurrencyObjectType $reporting_Currency_Reference = null, array $included_Projects_Reference = array(), array $included_Projects_in_Optional_Hierarchy_Reference = array())
    {
        $this
            ->setProject_Hierarchy_ID($project_Hierarchy_ID)
            ->setProject_Hierarchy_Name($project_Hierarchy_Name)
            ->setInclude_Project_Hierarchy_ID_in_Name($include_Project_Hierarchy_ID_in_Name)
            ->setEnable_as_Optional_Hierarchy($enable_as_Optional_Hierarchy)
            ->setProject_Hierarchy_Status_Reference($project_Hierarchy_Status_Reference)
            ->setInactive($inactive)
            ->setInactivated_By_Hierarchy_Reference($inactivated_By_Hierarchy_Reference)
            ->setOrganization_Subtype_Reference($organization_Subtype_Reference)
            ->setParent_Reference($parent_Reference)
            ->setProject_Resource_Plan_Reference($project_Resource_Plan_Reference)
            ->setProject_Scenario_Groups_Reference($project_Scenario_Groups_Reference)
            ->setDescription($description)
            ->setReporting_Currency_Reference($reporting_Currency_Reference)
            ->setIncluded_Projects_Reference($included_Projects_Reference)
            ->setIncluded_Projects_in_Optional_Hierarchy_Reference($included_Projects_in_Optional_Hierarchy_Reference);
    }
    /**
     * Get Project_Hierarchy_ID value
     * @return string|null
     */
    public function getProject_Hierarchy_ID()
    {
        return $this->Project_Hierarchy_ID;
    }
    /**
     * Set Project_Hierarchy_ID value
     * @param string $project_Hierarchy_ID
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setProject_Hierarchy_ID($project_Hierarchy_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Hierarchy_ID) && !is_string($project_Hierarchy_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Hierarchy_ID, true), gettype($project_Hierarchy_ID)), __LINE__);
        }
        $this->Project_Hierarchy_ID = $project_Hierarchy_ID;
        return $this;
    }
    /**
     * Get Project_Hierarchy_Name value
     * @return string|null
     */
    public function getProject_Hierarchy_Name()
    {
        return $this->Project_Hierarchy_Name;
    }
    /**
     * Set Project_Hierarchy_Name value
     * @param string $project_Hierarchy_Name
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setProject_Hierarchy_Name($project_Hierarchy_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Hierarchy_Name) && !is_string($project_Hierarchy_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Hierarchy_Name, true), gettype($project_Hierarchy_Name)), __LINE__);
        }
        $this->Project_Hierarchy_Name = $project_Hierarchy_Name;
        return $this;
    }
    /**
     * Get Include_Project_Hierarchy_ID_in_Name value
     * @return bool|null
     */
    public function getInclude_Project_Hierarchy_ID_in_Name()
    {
        return $this->Include_Project_Hierarchy_ID_in_Name;
    }
    /**
     * Set Include_Project_Hierarchy_ID_in_Name value
     * @param bool $include_Project_Hierarchy_ID_in_Name
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setInclude_Project_Hierarchy_ID_in_Name($include_Project_Hierarchy_ID_in_Name = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Project_Hierarchy_ID_in_Name) && !is_bool($include_Project_Hierarchy_ID_in_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Project_Hierarchy_ID_in_Name, true), gettype($include_Project_Hierarchy_ID_in_Name)), __LINE__);
        }
        $this->Include_Project_Hierarchy_ID_in_Name = $include_Project_Hierarchy_ID_in_Name;
        return $this;
    }
    /**
     * Get Enable_as_Optional_Hierarchy value
     * @return bool|null
     */
    public function getEnable_as_Optional_Hierarchy()
    {
        return $this->Enable_as_Optional_Hierarchy;
    }
    /**
     * Set Enable_as_Optional_Hierarchy value
     * @param bool $enable_as_Optional_Hierarchy
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setEnable_as_Optional_Hierarchy($enable_as_Optional_Hierarchy = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_as_Optional_Hierarchy) && !is_bool($enable_as_Optional_Hierarchy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_as_Optional_Hierarchy, true), gettype($enable_as_Optional_Hierarchy)), __LINE__);
        }
        $this->Enable_as_Optional_Hierarchy = $enable_as_Optional_Hierarchy;
        return $this;
    }
    /**
     * Get Project_Hierarchy_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getProject_Hierarchy_Status_Reference()
    {
        return $this->Project_Hierarchy_Status_Reference;
    }
    /**
     * Set Project_Hierarchy_Status_Reference value
     * @param \StructType\Document_StatusObjectType $project_Hierarchy_Status_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setProject_Hierarchy_Status_Reference(\StructType\Document_StatusObjectType $project_Hierarchy_Status_Reference = null)
    {
        $this->Project_Hierarchy_Status_Reference = $project_Hierarchy_Status_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Inactivated_By_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getInactivated_By_Hierarchy_Reference()
    {
        return $this->Inactivated_By_Hierarchy_Reference;
    }
    /**
     * Set Inactivated_By_Hierarchy_Reference value
     * @param \StructType\Project_HierarchyObjectType $inactivated_By_Hierarchy_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setInactivated_By_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $inactivated_By_Hierarchy_Reference = null)
    {
        $this->Inactivated_By_Hierarchy_Reference = $inactivated_By_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Organization_Subtype_Reference value
     * @return \StructType\Organization_SubtypeObjectType|null
     */
    public function getOrganization_Subtype_Reference()
    {
        return $this->Organization_Subtype_Reference;
    }
    /**
     * Set Organization_Subtype_Reference value
     * @param \StructType\Organization_SubtypeObjectType $organization_Subtype_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setOrganization_Subtype_Reference(\StructType\Organization_SubtypeObjectType $organization_Subtype_Reference = null)
    {
        $this->Organization_Subtype_Reference = $organization_Subtype_Reference;
        return $this;
    }
    /**
     * Get Parent_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getParent_Reference()
    {
        return $this->Parent_Reference;
    }
    /**
     * Set Parent_Reference value
     * @param \StructType\Project_HierarchyObjectType $parent_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setParent_Reference(\StructType\Project_HierarchyObjectType $parent_Reference = null)
    {
        $this->Parent_Reference = $parent_Reference;
        return $this;
    }
    /**
     * Get Project_Resource_Plan_Reference value
     * @return \StructType\Project_Resource_PlanObjectType|null
     */
    public function getProject_Resource_Plan_Reference()
    {
        return $this->Project_Resource_Plan_Reference;
    }
    /**
     * Set Project_Resource_Plan_Reference value
     * @param \StructType\Project_Resource_PlanObjectType $project_Resource_Plan_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setProject_Resource_Plan_Reference(\StructType\Project_Resource_PlanObjectType $project_Resource_Plan_Reference = null)
    {
        $this->Project_Resource_Plan_Reference = $project_Resource_Plan_Reference;
        return $this;
    }
    /**
     * Get Project_Scenario_Groups_Reference value
     * @return \StructType\Project_Scenario_GroupObjectType[]|null
     */
    public function getProject_Scenario_Groups_Reference()
    {
        return $this->Project_Scenario_Groups_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Scenario_Groups_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Scenario_Groups_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Scenario_Groups_ReferenceForArrayConstraintsFromSetProject_Scenario_Groups_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem instanceof \StructType\Project_Scenario_GroupObjectType) {
                $invalidValues[] = is_object($project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem) ? get_class($project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem) : sprintf('%s(%s)', gettype($project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem), var_export($project_Hierarchy_WWS_DataTypeProject_Scenario_Groups_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Scenario_Groups_Reference property can only contain items of type \StructType\Project_Scenario_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Scenario_Groups_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Scenario_GroupObjectType[] $project_Scenario_Groups_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setProject_Scenario_Groups_Reference(array $project_Scenario_Groups_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Scenario_Groups_ReferenceArrayErrorMessage = self::validateProject_Scenario_Groups_ReferenceForArrayConstraintsFromSetProject_Scenario_Groups_Reference($project_Scenario_Groups_Reference))) {
            throw new \InvalidArgumentException($project_Scenario_Groups_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Scenario_Groups_Reference = $project_Scenario_Groups_Reference;
        return $this;
    }
    /**
     * Add item to Project_Scenario_Groups_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Scenario_GroupObjectType $item
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function addToProject_Scenario_Groups_Reference(\StructType\Project_Scenario_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Scenario_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Scenario_Groups_Reference property can only contain items of type \StructType\Project_Scenario_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Scenario_Groups_Reference[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Reporting_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getReporting_Currency_Reference()
    {
        return $this->Reporting_Currency_Reference;
    }
    /**
     * Set Reporting_Currency_Reference value
     * @param \StructType\CurrencyObjectType $reporting_Currency_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setReporting_Currency_Reference(\StructType\CurrencyObjectType $reporting_Currency_Reference = null)
    {
        $this->Reporting_Currency_Reference = $reporting_Currency_Reference;
        return $this;
    }
    /**
     * Get Included_Projects_Reference value
     * @return \StructType\ProjectObjectType[]|null
     */
    public function getIncluded_Projects_Reference()
    {
        return $this->Included_Projects_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIncluded_Projects_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncluded_Projects_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncluded_Projects_ReferenceForArrayConstraintsFromSetIncluded_Projects_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem instanceof \StructType\ProjectObjectType) {
                $invalidValues[] = is_object($project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem) ? get_class($project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem) : sprintf('%s(%s)', gettype($project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem), var_export($project_Hierarchy_WWS_DataTypeIncluded_Projects_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Included_Projects_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Included_Projects_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType[] $included_Projects_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setIncluded_Projects_Reference(array $included_Projects_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($included_Projects_ReferenceArrayErrorMessage = self::validateIncluded_Projects_ReferenceForArrayConstraintsFromSetIncluded_Projects_Reference($included_Projects_Reference))) {
            throw new \InvalidArgumentException($included_Projects_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Included_Projects_Reference = $included_Projects_Reference;
        return $this;
    }
    /**
     * Add item to Included_Projects_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType $item
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function addToIncluded_Projects_Reference(\StructType\ProjectObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectObjectType) {
            throw new \InvalidArgumentException(sprintf('The Included_Projects_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Included_Projects_Reference[] = $item;
        return $this;
    }
    /**
     * Get Included_Projects_in_Optional_Hierarchy_Reference value
     * @return \StructType\ProjectObjectType[]|null
     */
    public function getIncluded_Projects_in_Optional_Hierarchy_Reference()
    {
        return $this->Included_Projects_in_Optional_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIncluded_Projects_in_Optional_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncluded_Projects_in_Optional_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncluded_Projects_in_Optional_Hierarchy_ReferenceForArrayConstraintsFromSetIncluded_Projects_in_Optional_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem instanceof \StructType\ProjectObjectType) {
                $invalidValues[] = is_object($project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem) ? get_class($project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem), var_export($project_Hierarchy_WWS_DataTypeIncluded_Projects_in_Optional_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Included_Projects_in_Optional_Hierarchy_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Included_Projects_in_Optional_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType[] $included_Projects_in_Optional_Hierarchy_Reference
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function setIncluded_Projects_in_Optional_Hierarchy_Reference(array $included_Projects_in_Optional_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($included_Projects_in_Optional_Hierarchy_ReferenceArrayErrorMessage = self::validateIncluded_Projects_in_Optional_Hierarchy_ReferenceForArrayConstraintsFromSetIncluded_Projects_in_Optional_Hierarchy_Reference($included_Projects_in_Optional_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($included_Projects_in_Optional_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Included_Projects_in_Optional_Hierarchy_Reference = $included_Projects_in_Optional_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Included_Projects_in_Optional_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType $item
     * @return \StructType\Project_Hierarchy_WWS_DataType
     */
    public function addToIncluded_Projects_in_Optional_Hierarchy_Reference(\StructType\ProjectObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectObjectType) {
            throw new \InvalidArgumentException(sprintf('The Included_Projects_in_Optional_Hierarchy_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Included_Projects_in_Optional_Hierarchy_Reference[] = $item;
        return $this;
    }
}
