<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configurable_Attributes_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing Supplier Invoice Adjustment Data
 * @subpackage Structs
 */
class Configurable_Attributes_DataType extends AbstractStructBase
{
    /**
     * The Configurable_Attribute_Value_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configurable Attribute Value Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType
     */
    public $Configurable_Attribute_Value_Reference;
    /**
     * The Configurable_Attribute_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Configurable Attribute
     * - minOccurs: 0
     * @var \StructType\Configurable_AttributeObjectType
     */
    public $Configurable_Attribute_Reference;
    /**
     * The Attribute_Value
     * Meta information extracted from the WSDL
     * - documentation: Reference to Attribute Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attribute_Value;
    /**
     * Constructor method for Configurable_Attributes_DataType
     * @uses Configurable_Attributes_DataType::setConfigurable_Attribute_Value_Reference()
     * @uses Configurable_Attributes_DataType::setConfigurable_Attribute_Reference()
     * @uses Configurable_Attributes_DataType::setAttribute_Value()
     * @param \StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType $configurable_Attribute_Value_Reference
     * @param \StructType\Configurable_AttributeObjectType $configurable_Attribute_Reference
     * @param string $attribute_Value
     */
    public function __construct(\StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType $configurable_Attribute_Value_Reference = null, \StructType\Configurable_AttributeObjectType $configurable_Attribute_Reference = null, $attribute_Value = null)
    {
        $this
            ->setConfigurable_Attribute_Value_Reference($configurable_Attribute_Value_Reference)
            ->setConfigurable_Attribute_Reference($configurable_Attribute_Reference)
            ->setAttribute_Value($attribute_Value);
    }
    /**
     * Get Configurable_Attribute_Value_Reference value
     * @return \StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType|null
     */
    public function getConfigurable_Attribute_Value_Reference()
    {
        return $this->Configurable_Attribute_Value_Reference;
    }
    /**
     * Set Configurable_Attribute_Value_Reference value
     * @param \StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType $configurable_Attribute_Value_Reference
     * @return \StructType\Configurable_Attributes_DataType
     */
    public function setConfigurable_Attribute_Value_Reference(\StructType\Supplier_Invoice_Document_Configurable_Attribute_ValueObjectType $configurable_Attribute_Value_Reference = null)
    {
        $this->Configurable_Attribute_Value_Reference = $configurable_Attribute_Value_Reference;
        return $this;
    }
    /**
     * Get Configurable_Attribute_Reference value
     * @return \StructType\Configurable_AttributeObjectType|null
     */
    public function getConfigurable_Attribute_Reference()
    {
        return $this->Configurable_Attribute_Reference;
    }
    /**
     * Set Configurable_Attribute_Reference value
     * @param \StructType\Configurable_AttributeObjectType $configurable_Attribute_Reference
     * @return \StructType\Configurable_Attributes_DataType
     */
    public function setConfigurable_Attribute_Reference(\StructType\Configurable_AttributeObjectType $configurable_Attribute_Reference = null)
    {
        $this->Configurable_Attribute_Reference = $configurable_Attribute_Reference;
        return $this;
    }
    /**
     * Get Attribute_Value value
     * @return string|null
     */
    public function getAttribute_Value()
    {
        return $this->Attribute_Value;
    }
    /**
     * Set Attribute_Value value
     * @param string $attribute_Value
     * @return \StructType\Configurable_Attributes_DataType
     */
    public function setAttribute_Value($attribute_Value = null)
    {
        // validation for constraint: string
        if (!is_null($attribute_Value) && !is_string($attribute_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute_Value, true), gettype($attribute_Value)), __LINE__);
        }
        $this->Attribute_Value = $attribute_Value;
        return $this;
    }
}
