<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Load_Alternate_Item_IdentifierType StructType
 * Meta information extracted from the WSDL
 * - documentation: Alternate Item Identifiers for Catalog Load items.
 * @subpackage Structs
 */
class Catalog_Load_Alternate_Item_IdentifierType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Type for the Alternate Item Identifier.
     * @var \StructType\Item_Identifier_TypeObjectType
     */
    public $Item_Identifier_Type_Reference;
    /**
     * The Alternate_Identifier_Value
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Value for the Alternate Item Identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alternate_Identifier_Value;
    /**
     * The Manufacturer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Please enter an active Manufacturer instance as Alternate Item Identifier
     * - minOccurs: 0
     * @var \StructType\ManufacturerObjectType
     */
    public $Manufacturer_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference for Item Identifier Type that supports UOM.
     * - choice: Unit_of_Measure_Reference | UN_CEFACT_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The UN_CEFACT_UOM_Code
     * Meta information extracted from the WSDL
     * - documentation: UN CEFACT Common Code for Item Identifier Type that supports UOM.
     * - choice: Unit_of_Measure_Reference | UN_CEFACT_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UN_CEFACT_UOM_Code;
    /**
     * Constructor method for Catalog_Load_Alternate_Item_IdentifierType
     * @uses Catalog_Load_Alternate_Item_IdentifierType::setItem_Identifier_Type_Reference()
     * @uses Catalog_Load_Alternate_Item_IdentifierType::setAlternate_Identifier_Value()
     * @uses Catalog_Load_Alternate_Item_IdentifierType::setManufacturer_Reference()
     * @uses Catalog_Load_Alternate_Item_IdentifierType::setUnit_of_Measure_Reference()
     * @uses Catalog_Load_Alternate_Item_IdentifierType::setUN_CEFACT_UOM_Code()
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @param string $alternate_Identifier_Value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param string $uN_CEFACT_UOM_Code
     */
    public function __construct(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null, $alternate_Identifier_Value = null, \StructType\ManufacturerObjectType $manufacturer_Reference = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $uN_CEFACT_UOM_Code = null)
    {
        $this
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference)
            ->setAlternate_Identifier_Value($alternate_Identifier_Value)
            ->setManufacturer_Reference($manufacturer_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code);
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType
     */
    public function setItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null)
    {
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Get Alternate_Identifier_Value value
     * @return string|null
     */
    public function getAlternate_Identifier_Value()
    {
        return $this->Alternate_Identifier_Value;
    }
    /**
     * Set Alternate_Identifier_Value value
     * @param string $alternate_Identifier_Value
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType
     */
    public function setAlternate_Identifier_Value($alternate_Identifier_Value = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Identifier_Value) && !is_string($alternate_Identifier_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Identifier_Value, true), gettype($alternate_Identifier_Value)), __LINE__);
        }
        $this->Alternate_Identifier_Value = $alternate_Identifier_Value;
        return $this;
    }
    /**
     * Get Manufacturer_Reference value
     * @return \StructType\ManufacturerObjectType|null
     */
    public function getManufacturer_Reference()
    {
        return $this->Manufacturer_Reference;
    }
    /**
     * Set Manufacturer_Reference value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType
     */
    public function setManufacturer_Reference(\StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this->Manufacturer_Reference = $manufacturer_Reference;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return isset($this->Unit_of_Measure_Reference) ? $this->Unit_of_Measure_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUnit_of_Measure_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnit_of_Measure_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUnit_of_Measure_ReferenceForChoiceConstraintsFromSetUnit_of_Measure_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UN_CEFACT_UOM_Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Unit_of_Measure_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Unit_of_Measure_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        // validation for constraint: choice(Unit_of_Measure_Reference, UN_CEFACT_UOM_Code)
        if ('' !== ($unit_of_Measure_ReferenceChoiceErrorMessage = self::validateUnit_of_Measure_ReferenceForChoiceConstraintsFromSetUnit_of_Measure_Reference($unit_of_Measure_Reference))) {
            throw new \InvalidArgumentException($unit_of_Measure_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($unit_of_Measure_Reference) || (is_array($unit_of_Measure_Reference) && empty($unit_of_Measure_Reference))) {
            unset($this->Unit_of_Measure_Reference);
        } else {
            $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        }
        return $this;
    }
    /**
     * Get UN_CEFACT_UOM_Code value
     * @return string|null
     */
    public function getUN_CEFACT_UOM_Code()
    {
        return isset($this->UN_CEFACT_UOM_Code) ? $this->UN_CEFACT_UOM_Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUN_CEFACT_UOM_Code method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUN_CEFACT_UOM_Code method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUN_CEFACT_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_UOM_Code($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Unit_of_Measure_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UN_CEFACT_UOM_Code can\'t be set as the property %s is already set. Only one property must be set among these properties: UN_CEFACT_UOM_Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UN_CEFACT_UOM_Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uN_CEFACT_UOM_Code
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType
     */
    public function setUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code = null)
    {
        // validation for constraint: string
        if (!is_null($uN_CEFACT_UOM_Code) && !is_string($uN_CEFACT_UOM_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uN_CEFACT_UOM_Code, true), gettype($uN_CEFACT_UOM_Code)), __LINE__);
        }
        // validation for constraint: choice(Unit_of_Measure_Reference, UN_CEFACT_UOM_Code)
        if ('' !== ($uN_CEFACT_UOM_CodeChoiceErrorMessage = self::validateUN_CEFACT_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code))) {
            throw new \InvalidArgumentException($uN_CEFACT_UOM_CodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($uN_CEFACT_UOM_Code) || (is_array($uN_CEFACT_UOM_Code) && empty($uN_CEFACT_UOM_Code))) {
            unset($this->UN_CEFACT_UOM_Code);
        } else {
            $this->UN_CEFACT_UOM_Code = $uN_CEFACT_UOM_Code;
        }
        return $this;
    }
}
