<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Line_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains the specific instance set containing the requested requisition line. The type attribute is either Reference ID type or Workday ID (GUI) and the ID is the value for the instance of the requisition line.
 * @subpackage Structs
 */
class Requisition_Line_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Requisition_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition Line reference
     * - maxOccurs: unbounded
     * @var \StructType\Requisition_LineObjectType[]
     */
    public $Requisition_Line_Reference;
    /**
     * Constructor method for Requisition_Line_Request_ReferencesType
     * @uses Requisition_Line_Request_ReferencesType::setRequisition_Line_Reference()
     * @param \StructType\Requisition_LineObjectType[] $requisition_Line_Reference
     */
    public function __construct(array $requisition_Line_Reference = array())
    {
        $this
            ->setRequisition_Line_Reference($requisition_Line_Reference);
    }
    /**
     * Get Requisition_Line_Reference value
     * @return \StructType\Requisition_LineObjectType[]|null
     */
    public function getRequisition_Line_Reference()
    {
        return $this->Requisition_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Line_ReferenceForArrayConstraintsFromSetRequisition_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem instanceof \StructType\Requisition_LineObjectType) {
                $invalidValues[] = is_object($requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem) ? get_class($requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem), var_export($requisition_Line_Request_ReferencesTypeRequisition_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Line_Reference property can only contain items of type \StructType\Requisition_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_LineObjectType[] $requisition_Line_Reference
     * @return \StructType\Requisition_Line_Request_ReferencesType
     */
    public function setRequisition_Line_Reference(array $requisition_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Line_ReferenceArrayErrorMessage = self::validateRequisition_Line_ReferenceForArrayConstraintsFromSetRequisition_Line_Reference($requisition_Line_Reference))) {
            throw new \InvalidArgumentException($requisition_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Line_Reference = $requisition_Line_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_LineObjectType $item
     * @return \StructType\Requisition_Line_Request_ReferencesType
     */
    public function addToRequisition_Line_Reference(\StructType\Requisition_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Line_Reference property can only contain items of type \StructType\Requisition_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Line_Reference[] = $item;
        return $this;
    }
}
