<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Request for Quote Reference and Request for Quote Data.
 * @subpackage Structs
 */
class Request_for_Quote_OutboundType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Reference.
     * - minOccurs: 0
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $Request_for_Quote_Reference;
    /**
     * The Request_for_Quote_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_DataType[]
     */
    public $Request_for_Quote_Data;
    /**
     * Constructor method for Request_for_Quote_OutboundType
     * @uses Request_for_Quote_OutboundType::setRequest_for_Quote_Reference()
     * @uses Request_for_Quote_OutboundType::setRequest_for_Quote_Data()
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @param \StructType\Request_for_Quote_DataType[] $request_for_Quote_Data
     */
    public function __construct(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null, array $request_for_Quote_Data = array())
    {
        $this
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference)
            ->setRequest_for_Quote_Data($request_for_Quote_Data);
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @return \StructType\Request_for_Quote_OutboundType
     */
    public function setRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null)
    {
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Data value
     * @return \StructType\Request_for_Quote_DataType[]|null
     */
    public function getRequest_for_Quote_Data()
    {
        return $this->Request_for_Quote_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_DataForArrayConstraintsFromSetRequest_for_Quote_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_OutboundTypeRequest_for_Quote_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_OutboundTypeRequest_for_Quote_DataItem instanceof \StructType\Request_for_Quote_DataType) {
                $invalidValues[] = is_object($request_for_Quote_OutboundTypeRequest_for_Quote_DataItem) ? get_class($request_for_Quote_OutboundTypeRequest_for_Quote_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_OutboundTypeRequest_for_Quote_DataItem), var_export($request_for_Quote_OutboundTypeRequest_for_Quote_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Data property can only contain items of type \StructType\Request_for_Quote_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_DataType[] $request_for_Quote_Data
     * @return \StructType\Request_for_Quote_OutboundType
     */
    public function setRequest_for_Quote_Data(array $request_for_Quote_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_DataArrayErrorMessage = self::validateRequest_for_Quote_DataForArrayConstraintsFromSetRequest_for_Quote_Data($request_for_Quote_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Data = $request_for_Quote_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_DataType $item
     * @return \StructType\Request_for_Quote_OutboundType
     */
    public function addToRequest_for_Quote_Data(\StructType\Request_for_Quote_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Data property can only contain items of type \StructType\Request_for_Quote_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Data[] = $item;
        return $this;
    }
}
