<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Invoice_Types_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Invoice Type response elements including echoed request data and request result data.
 * @subpackage Structs
 */
class Get_Invoice_Types_ResponseType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: This element contains the echoed Invoice Type Request Reference element.
     * - minOccurs: 0
     * @var \StructType\Invoice_Type_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta information extracted from the WSDL
     * - documentation: This element content contains the echoed Invoice Type Request Criteria element.
     * - minOccurs: 0
     * @var \StructType\Invoice_Type_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Reponse_Filter
     * Meta information extracted from the WSDL
     * - documentation: This element content contains the echoed Response Filter element.
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Reponse_Filter;
    /**
     * The Response_Group
     * Meta information extracted from the WSDL
     * - documentation: This element content contains the echoed Invoice Type Response Group element.
     * - minOccurs: 0
     * @var \StructType\Invoice_Type_Response_GroupType
     */
    public $Response_Group;
    /**
     * The Response_Results
     * Meta information extracted from the WSDL
     * - documentation: This element content contains the Invoice Type Response Results element.
     * - minOccurs: 0
     * @var \StructType\Response_ResultsType
     */
    public $Response_Results;
    /**
     * The Response_Data
     * Meta information extracted from the WSDL
     * - documentation: This element content contains the Invoice Type Response Data element.
     * - minOccurs: 0
     * @var \StructType\Invoice_Type_Response_DataType
     */
    public $Response_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Invoice_Types_ResponseType
     * @uses Get_Invoice_Types_ResponseType::setRequest_References()
     * @uses Get_Invoice_Types_ResponseType::setRequest_Criteria()
     * @uses Get_Invoice_Types_ResponseType::setReponse_Filter()
     * @uses Get_Invoice_Types_ResponseType::setResponse_Group()
     * @uses Get_Invoice_Types_ResponseType::setResponse_Results()
     * @uses Get_Invoice_Types_ResponseType::setResponse_Data()
     * @uses Get_Invoice_Types_ResponseType::setVersion()
     * @param \StructType\Invoice_Type_Request_ReferencesType $request_References
     * @param \StructType\Invoice_Type_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $reponse_Filter
     * @param \StructType\Invoice_Type_Response_GroupType $response_Group
     * @param \StructType\Response_ResultsType $response_Results
     * @param \StructType\Invoice_Type_Response_DataType $response_Data
     * @param string $version
     */
    public function __construct(\StructType\Invoice_Type_Request_ReferencesType $request_References = null, \StructType\Invoice_Type_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $reponse_Filter = null, \StructType\Invoice_Type_Response_GroupType $response_Group = null, \StructType\Response_ResultsType $response_Results = null, \StructType\Invoice_Type_Response_DataType $response_Data = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setReponse_Filter($reponse_Filter)
            ->setResponse_Group($response_Group)
            ->setResponse_Results($response_Results)
            ->setResponse_Data($response_Data)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Invoice_Type_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Invoice_Type_Request_ReferencesType $request_References
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setRequest_References(\StructType\Invoice_Type_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Invoice_Type_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Invoice_Type_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setRequest_Criteria(\StructType\Invoice_Type_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Reponse_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getReponse_Filter()
    {
        return $this->Reponse_Filter;
    }
    /**
     * Set Reponse_Filter value
     * @param \StructType\Response_FilterType $reponse_Filter
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setReponse_Filter(\StructType\Response_FilterType $reponse_Filter = null)
    {
        $this->Reponse_Filter = $reponse_Filter;
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Invoice_Type_Response_GroupType|null
     */
    public function getResponse_Group()
    {
        return $this->Response_Group;
    }
    /**
     * Set Response_Group value
     * @param \StructType\Invoice_Type_Response_GroupType $response_Group
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setResponse_Group(\StructType\Invoice_Type_Response_GroupType $response_Group = null)
    {
        $this->Response_Group = $response_Group;
        return $this;
    }
    /**
     * Get Response_Results value
     * @return \StructType\Response_ResultsType|null
     */
    public function getResponse_Results()
    {
        return $this->Response_Results;
    }
    /**
     * Set Response_Results value
     * @param \StructType\Response_ResultsType $response_Results
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setResponse_Results(\StructType\Response_ResultsType $response_Results = null)
    {
        $this->Response_Results = $response_Results;
        return $this;
    }
    /**
     * Get Response_Data value
     * @return \StructType\Invoice_Type_Response_DataType|null
     */
    public function getResponse_Data()
    {
        return $this->Response_Data;
    }
    /**
     * Set Response_Data value
     * @param \StructType\Invoice_Type_Response_DataType $response_Data
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setResponse_Data(\StructType\Invoice_Type_Response_DataType $response_Data = null)
    {
        $this->Response_Data = $response_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Invoice_Types_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
