<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier classification data
 * @subpackage Structs
 */
class Supplier_Classification_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_ID
     * Meta information extracted from the WSDL
     * - documentation: This is the supplier classification unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Classification_ID;
    /**
     * The Supplier_Classification_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference that identifies the Supplier Classification Category for the supplier classification.
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_Category__All_ObjectType
     */
    public $Supplier_Classification_Category_Reference;
    /**
     * The Supplier_Classification_Name
     * Meta information extracted from the WSDL
     * - documentation: The name for the supplier classification
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Classification_Name;
    /**
     * The External_Site
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier classification is to be used in the supplier external site
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $External_Site;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the country that the supplier classification is associated with
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier classification is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Supplier_Classification_Field_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Field Replacement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Classification_Field_Replacement_DataType[]
     */
    public $Supplier_Classification_Field_Replacement_Data;
    /**
     * Constructor method for Supplier_Classification_DataType
     * @uses Supplier_Classification_DataType::setSupplier_Classification_ID()
     * @uses Supplier_Classification_DataType::setSupplier_Classification_Category_Reference()
     * @uses Supplier_Classification_DataType::setSupplier_Classification_Name()
     * @uses Supplier_Classification_DataType::setExternal_Site()
     * @uses Supplier_Classification_DataType::setCountry_Reference()
     * @uses Supplier_Classification_DataType::setInactive()
     * @uses Supplier_Classification_DataType::setSupplier_Classification_Field_Replacement_Data()
     * @param string $supplier_Classification_ID
     * @param \StructType\Custom_Supplier_Classification_Category__All_ObjectType $supplier_Classification_Category_Reference
     * @param string $supplier_Classification_Name
     * @param bool $external_Site
     * @param \StructType\CountryObjectType $country_Reference
     * @param bool $inactive
     * @param \StructType\Supplier_Classification_Field_Replacement_DataType[] $supplier_Classification_Field_Replacement_Data
     */
    public function __construct($supplier_Classification_ID = null, \StructType\Custom_Supplier_Classification_Category__All_ObjectType $supplier_Classification_Category_Reference = null, $supplier_Classification_Name = null, $external_Site = null, \StructType\CountryObjectType $country_Reference = null, $inactive = null, array $supplier_Classification_Field_Replacement_Data = array())
    {
        $this
            ->setSupplier_Classification_ID($supplier_Classification_ID)
            ->setSupplier_Classification_Category_Reference($supplier_Classification_Category_Reference)
            ->setSupplier_Classification_Name($supplier_Classification_Name)
            ->setExternal_Site($external_Site)
            ->setCountry_Reference($country_Reference)
            ->setInactive($inactive)
            ->setSupplier_Classification_Field_Replacement_Data($supplier_Classification_Field_Replacement_Data);
    }
    /**
     * Get Supplier_Classification_ID value
     * @return string|null
     */
    public function getSupplier_Classification_ID()
    {
        return $this->Supplier_Classification_ID;
    }
    /**
     * Set Supplier_Classification_ID value
     * @param string $supplier_Classification_ID
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setSupplier_Classification_ID($supplier_Classification_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Classification_ID) && !is_string($supplier_Classification_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Classification_ID, true), gettype($supplier_Classification_ID)), __LINE__);
        }
        $this->Supplier_Classification_ID = $supplier_Classification_ID;
        return $this;
    }
    /**
     * Get Supplier_Classification_Category_Reference value
     * @return \StructType\Custom_Supplier_Classification_Category__All_ObjectType|null
     */
    public function getSupplier_Classification_Category_Reference()
    {
        return $this->Supplier_Classification_Category_Reference;
    }
    /**
     * Set Supplier_Classification_Category_Reference value
     * @param \StructType\Custom_Supplier_Classification_Category__All_ObjectType $supplier_Classification_Category_Reference
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setSupplier_Classification_Category_Reference(\StructType\Custom_Supplier_Classification_Category__All_ObjectType $supplier_Classification_Category_Reference = null)
    {
        $this->Supplier_Classification_Category_Reference = $supplier_Classification_Category_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Name value
     * @return string|null
     */
    public function getSupplier_Classification_Name()
    {
        return $this->Supplier_Classification_Name;
    }
    /**
     * Set Supplier_Classification_Name value
     * @param string $supplier_Classification_Name
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setSupplier_Classification_Name($supplier_Classification_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Classification_Name) && !is_string($supplier_Classification_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Classification_Name, true), gettype($supplier_Classification_Name)), __LINE__);
        }
        $this->Supplier_Classification_Name = $supplier_Classification_Name;
        return $this;
    }
    /**
     * Get External_Site value
     * @return bool|null
     */
    public function getExternal_Site()
    {
        return $this->External_Site;
    }
    /**
     * Set External_Site value
     * @param bool $external_Site
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setExternal_Site($external_Site = null)
    {
        // validation for constraint: boolean
        if (!is_null($external_Site) && !is_bool($external_Site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($external_Site, true), gettype($external_Site)), __LINE__);
        }
        $this->External_Site = $external_Site;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Supplier_Classification_Field_Replacement_Data value
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType[]|null
     */
    public function getSupplier_Classification_Field_Replacement_Data()
    {
        return $this->Supplier_Classification_Field_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Field_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Field_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_Field_Replacement_DataForArrayConstraintsFromSetSupplier_Classification_Field_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem instanceof \StructType\Supplier_Classification_Field_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem) ? get_class($supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem), var_export($supplier_Classification_DataTypeSupplier_Classification_Field_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Field_Replacement_Data property can only contain items of type \StructType\Supplier_Classification_Field_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Field_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Replacement_DataType[] $supplier_Classification_Field_Replacement_Data
     * @return \StructType\Supplier_Classification_DataType
     */
    public function setSupplier_Classification_Field_Replacement_Data(array $supplier_Classification_Field_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_Field_Replacement_DataArrayErrorMessage = self::validateSupplier_Classification_Field_Replacement_DataForArrayConstraintsFromSetSupplier_Classification_Field_Replacement_Data($supplier_Classification_Field_Replacement_Data))) {
            throw new \InvalidArgumentException($supplier_Classification_Field_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Field_Replacement_Data = $supplier_Classification_Field_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Field_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Replacement_DataType $item
     * @return \StructType\Supplier_Classification_DataType
     */
    public function addToSupplier_Classification_Field_Replacement_Data(\StructType\Supplier_Classification_Field_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Classification_Field_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Field_Replacement_Data property can only contain items of type \StructType\Supplier_Classification_Field_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Field_Replacement_Data[] = $item;
        return $this;
    }
}
