<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Header_Or_Line_Bid_Response_Data_InboundType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture header and line level bid responses
 * @subpackage Structs
 */
class RFQ_Header_Or_Line_Bid_Response_Data_InboundType extends AbstractStructBase
{
    /**
     * The RFQ_Bid_Requirement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ Bid Requirement.
     * @var \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType
     */
    public $RFQ_Bid_Requirement_Reference;
    /**
     * The Date_Response
     * Meta information extracted from the WSDL
     * - documentation: Date Response provided by supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Response;
    /**
     * The Numeric_Response
     * Meta information extracted from the WSDL
     * - documentation: Numeric Response provided by supplier.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Numeric_Response;
    /**
     * The Text_Response
     * Meta information extracted from the WSDL
     * - documentation: Text Response provided by Supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text_Response;
    /**
     * The Boolean_Yes_Response
     * Meta information extracted from the WSDL
     * - documentation: Boolean Yes Response provided by supplier. Enter Y to indicate that the supplier has answered 'Yes' to the bid requirement. Leave blank otherwise.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Boolean_Yes_Response;
    /**
     * The Boolean_No_Response
     * Meta information extracted from the WSDL
     * - documentation: Boolean No Response provided by supplier. Enter Y to indicate that the supplier has answered 'No' to the bid requirement. Leave blank otherwise.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Boolean_No_Response;
    /**
     * The Bid_Response_Memo
     * Meta information extracted from the WSDL
     * - documentation: Bid Response Memo provided by supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bid_Response_Memo;
    /**
     * Constructor method for RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setRFQ_Bid_Requirement_Reference()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setDate_Response()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setNumeric_Response()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setText_Response()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setBoolean_Yes_Response()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setBoolean_No_Response()
     * @uses RFQ_Header_Or_Line_Bid_Response_Data_InboundType::setBid_Response_Memo()
     * @param \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference
     * @param string $date_Response
     * @param float $numeric_Response
     * @param string $text_Response
     * @param bool $boolean_Yes_Response
     * @param bool $boolean_No_Response
     * @param string $bid_Response_Memo
     */
    public function __construct(\StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference = null, $date_Response = null, $numeric_Response = null, $text_Response = null, $boolean_Yes_Response = null, $boolean_No_Response = null, $bid_Response_Memo = null)
    {
        $this
            ->setRFQ_Bid_Requirement_Reference($rFQ_Bid_Requirement_Reference)
            ->setDate_Response($date_Response)
            ->setNumeric_Response($numeric_Response)
            ->setText_Response($text_Response)
            ->setBoolean_Yes_Response($boolean_Yes_Response)
            ->setBoolean_No_Response($boolean_No_Response)
            ->setBid_Response_Memo($bid_Response_Memo);
    }
    /**
     * Get RFQ_Bid_Requirement_Reference value
     * @return \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType|null
     */
    public function getRFQ_Bid_Requirement_Reference()
    {
        return $this->RFQ_Bid_Requirement_Reference;
    }
    /**
     * Set RFQ_Bid_Requirement_Reference value
     * @param \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setRFQ_Bid_Requirement_Reference(\StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference = null)
    {
        $this->RFQ_Bid_Requirement_Reference = $rFQ_Bid_Requirement_Reference;
        return $this;
    }
    /**
     * Get Date_Response value
     * @return string|null
     */
    public function getDate_Response()
    {
        return $this->Date_Response;
    }
    /**
     * Set Date_Response value
     * @param string $date_Response
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setDate_Response($date_Response = null)
    {
        // validation for constraint: string
        if (!is_null($date_Response) && !is_string($date_Response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Response, true), gettype($date_Response)), __LINE__);
        }
        $this->Date_Response = $date_Response;
        return $this;
    }
    /**
     * Get Numeric_Response value
     * @return float|null
     */
    public function getNumeric_Response()
    {
        return $this->Numeric_Response;
    }
    /**
     * Set Numeric_Response value
     * @param float $numeric_Response
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setNumeric_Response($numeric_Response = null)
    {
        // validation for constraint: float
        if (!is_null($numeric_Response) && !(is_float($numeric_Response) || is_numeric($numeric_Response))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numeric_Response, true), gettype($numeric_Response)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($numeric_Response) && mb_strlen(mb_substr($numeric_Response, false !== mb_strpos($numeric_Response, '.') ? mb_strpos($numeric_Response, '.') + 1 : mb_strlen($numeric_Response))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($numeric_Response, true), mb_strlen(mb_substr($numeric_Response, mb_strpos($numeric_Response, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($numeric_Response) && $numeric_Response < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($numeric_Response, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($numeric_Response) && mb_strlen(preg_replace('/(\D)/', '', $numeric_Response)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($numeric_Response, true), mb_strlen(preg_replace('/(\D)/', '', $numeric_Response))), __LINE__);
        }
        $this->Numeric_Response = $numeric_Response;
        return $this;
    }
    /**
     * Get Text_Response value
     * @return string|null
     */
    public function getText_Response()
    {
        return $this->Text_Response;
    }
    /**
     * Set Text_Response value
     * @param string $text_Response
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setText_Response($text_Response = null)
    {
        // validation for constraint: string
        if (!is_null($text_Response) && !is_string($text_Response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text_Response, true), gettype($text_Response)), __LINE__);
        }
        $this->Text_Response = $text_Response;
        return $this;
    }
    /**
     * Get Boolean_Yes_Response value
     * @return bool|null
     */
    public function getBoolean_Yes_Response()
    {
        return $this->Boolean_Yes_Response;
    }
    /**
     * Set Boolean_Yes_Response value
     * @param bool $boolean_Yes_Response
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setBoolean_Yes_Response($boolean_Yes_Response = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean_Yes_Response) && !is_bool($boolean_Yes_Response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolean_Yes_Response, true), gettype($boolean_Yes_Response)), __LINE__);
        }
        $this->Boolean_Yes_Response = $boolean_Yes_Response;
        return $this;
    }
    /**
     * Get Boolean_No_Response value
     * @return bool|null
     */
    public function getBoolean_No_Response()
    {
        return $this->Boolean_No_Response;
    }
    /**
     * Set Boolean_No_Response value
     * @param bool $boolean_No_Response
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setBoolean_No_Response($boolean_No_Response = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolean_No_Response) && !is_bool($boolean_No_Response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolean_No_Response, true), gettype($boolean_No_Response)), __LINE__);
        }
        $this->Boolean_No_Response = $boolean_No_Response;
        return $this;
    }
    /**
     * Get Bid_Response_Memo value
     * @return string|null
     */
    public function getBid_Response_Memo()
    {
        return $this->Bid_Response_Memo;
    }
    /**
     * Set Bid_Response_Memo value
     * @param string $bid_Response_Memo
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType
     */
    public function setBid_Response_Memo($bid_Response_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($bid_Response_Memo) && !is_string($bid_Response_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bid_Response_Memo, true), gettype($bid_Response_Memo)), __LINE__);
        }
        $this->Bid_Response_Memo = $bid_Response_Memo;
        return $this;
    }
}
