<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Hotel_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the Hotel Reference and Data that is sent in the response
 * @subpackage Structs
 */
class Put_Hotel_ResponseType extends AbstractStructBase
{
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference
     * - minOccurs: 0
     * @var \StructType\HotelObjectType
     */
    public $Hotel_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Hotel_ResponseType
     * @uses Put_Hotel_ResponseType::setHotel_Reference()
     * @uses Put_Hotel_ResponseType::setVersion()
     * @param \StructType\HotelObjectType $hotel_Reference
     * @param string $version
     */
    public function __construct(\StructType\HotelObjectType $hotel_Reference = null, $version = null)
    {
        $this
            ->setHotel_Reference($hotel_Reference)
            ->setVersion($version);
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * Set Hotel_Reference value
     * @param \StructType\HotelObjectType $hotel_Reference
     * @return \StructType\Put_Hotel_ResponseType
     */
    public function setHotel_Reference(\StructType\HotelObjectType $hotel_Reference = null)
    {
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Hotel_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
