<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Task_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains the Project Plan Task Data
 * @subpackage Structs
 */
class Project_Plan_Task_WWS_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Task_ID
     * Meta information extracted from the WSDL
     * - documentation: Task ID. This is the task unique identifier within a phase.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Plan_Task_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Specifies the display order of the task within the phase of a project plan.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Task Reference
     * - minOccurs: 0
     * @var \StructType\Project_TaskObjectType
     */
    public $Task_Reference;
    /**
     * The Custom_Task_Name
     * Meta information extracted from the WSDL
     * - documentation: Custom Task Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Task_Name;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Task Start Date cannot be after Project End Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Task End Date cannot be after the Project End Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Percent_Complete
     * Meta information extracted from the WSDL
     * - documentation: The percent complete for the project plan template. | The percent complete for the project template. | Decimal value for Proposed Percent Complete of the Project Task selected. This value can be set via the Timesheet under certain
     * condition and is then copied to the Project Task on Approval of the Timesheet. | The value for Percent Complete Proposed can only be set where the Task is not 100% already on the Project and that Task is directly assigned to the worker. | Proposed
     * Percent Complete Complete cannot be greater than 100%. Percent complete is in decimal format value can not be greater than 1.00. | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Complete;
    /**
     * The Non_Billable
     * Meta information extracted from the WSDL
     * - documentation: Non-Billable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Billable;
    /**
     * The Milestone
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the task is a project milestone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Milestone;
    /**
     * The Closed
     * Meta information extracted from the WSDL
     * - documentation: Checking the task Closed will prevent any additional time to be reported for the specified task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Closed;
    /**
     * The Utilization
     * Meta information extracted from the WSDL
     * - documentation: For informational purposes only to indicate that this project plan task qualifies for utilization calculations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Utilization;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Free form text capturing comments about the task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Task_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment File
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Task_Attachment_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Delete is set to true, Replace All must be set to false. | Flag indicating that the referenced data should be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Project_Plan_Task_WWS_DataType
     * @uses Project_Plan_Task_WWS_DataType::setProject_Plan_Task_ID()
     * @uses Project_Plan_Task_WWS_DataType::setOrder()
     * @uses Project_Plan_Task_WWS_DataType::setTask_Reference()
     * @uses Project_Plan_Task_WWS_DataType::setCustom_Task_Name()
     * @uses Project_Plan_Task_WWS_DataType::setStart_Date()
     * @uses Project_Plan_Task_WWS_DataType::setEnd_Date()
     * @uses Project_Plan_Task_WWS_DataType::setPercent_Complete()
     * @uses Project_Plan_Task_WWS_DataType::setNon_Billable()
     * @uses Project_Plan_Task_WWS_DataType::setMilestone()
     * @uses Project_Plan_Task_WWS_DataType::setClosed()
     * @uses Project_Plan_Task_WWS_DataType::setUtilization()
     * @uses Project_Plan_Task_WWS_DataType::setMemo()
     * @uses Project_Plan_Task_WWS_DataType::setTask_Attachment_Data()
     * @uses Project_Plan_Task_WWS_DataType::setDelete()
     * @param string $project_Plan_Task_ID
     * @param string $order
     * @param \StructType\Project_TaskObjectType $task_Reference
     * @param string $custom_Task_Name
     * @param string $start_Date
     * @param string $end_Date
     * @param float $percent_Complete
     * @param bool $non_Billable
     * @param bool $milestone
     * @param bool $closed
     * @param bool $utilization
     * @param string $memo
     * @param \StructType\Financials_Attachment_DataType[] $task_Attachment_Data
     * @param bool $delete
     */
    public function __construct($project_Plan_Task_ID = null, $order = null, \StructType\Project_TaskObjectType $task_Reference = null, $custom_Task_Name = null, $start_Date = null, $end_Date = null, $percent_Complete = null, $non_Billable = null, $milestone = null, $closed = null, $utilization = null, $memo = null, array $task_Attachment_Data = array(), $delete = null)
    {
        $this
            ->setProject_Plan_Task_ID($project_Plan_Task_ID)
            ->setOrder($order)
            ->setTask_Reference($task_Reference)
            ->setCustom_Task_Name($custom_Task_Name)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setPercent_Complete($percent_Complete)
            ->setNon_Billable($non_Billable)
            ->setMilestone($milestone)
            ->setClosed($closed)
            ->setUtilization($utilization)
            ->setMemo($memo)
            ->setTask_Attachment_Data($task_Attachment_Data)
            ->setDelete($delete);
    }
    /**
     * Get Project_Plan_Task_ID value
     * @return string|null
     */
    public function getProject_Plan_Task_ID()
    {
        return $this->Project_Plan_Task_ID;
    }
    /**
     * Set Project_Plan_Task_ID value
     * @param string $project_Plan_Task_ID
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setProject_Plan_Task_ID($project_Plan_Task_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Plan_Task_ID) && !is_string($project_Plan_Task_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Plan_Task_ID, true), gettype($project_Plan_Task_ID)), __LINE__);
        }
        $this->Project_Plan_Task_ID = $project_Plan_Task_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Task_Reference value
     * @return \StructType\Project_TaskObjectType|null
     */
    public function getTask_Reference()
    {
        return $this->Task_Reference;
    }
    /**
     * Set Task_Reference value
     * @param \StructType\Project_TaskObjectType $task_Reference
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setTask_Reference(\StructType\Project_TaskObjectType $task_Reference = null)
    {
        $this->Task_Reference = $task_Reference;
        return $this;
    }
    /**
     * Get Custom_Task_Name value
     * @return string|null
     */
    public function getCustom_Task_Name()
    {
        return $this->Custom_Task_Name;
    }
    /**
     * Set Custom_Task_Name value
     * @param string $custom_Task_Name
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setCustom_Task_Name($custom_Task_Name = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Task_Name) && !is_string($custom_Task_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custom_Task_Name, true), gettype($custom_Task_Name)), __LINE__);
        }
        $this->Custom_Task_Name = $custom_Task_Name;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Percent_Complete value
     * @return float|null
     */
    public function getPercent_Complete()
    {
        return $this->Percent_Complete;
    }
    /**
     * Set Percent_Complete value
     * @param float $percent_Complete
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setPercent_Complete($percent_Complete = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Complete) && !(is_float($percent_Complete) || is_numeric($percent_Complete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Complete, true), gettype($percent_Complete)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Complete) && mb_strlen(mb_substr($percent_Complete, false !== mb_strpos($percent_Complete, '.') ? mb_strpos($percent_Complete, '.') + 1 : mb_strlen($percent_Complete))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Complete, true), mb_strlen(mb_substr($percent_Complete, mb_strpos($percent_Complete, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Complete) && $percent_Complete < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Complete, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Complete) && mb_strlen(preg_replace('/(\D)/', '', $percent_Complete)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Complete, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Complete))), __LINE__);
        }
        $this->Percent_Complete = $percent_Complete;
        return $this;
    }
    /**
     * Get Non_Billable value
     * @return bool|null
     */
    public function getNon_Billable()
    {
        return $this->{'Non-Billable'};
    }
    /**
     * Set Non_Billable value
     * @param bool $non_Billable
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setNon_Billable($non_Billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Billable) && !is_bool($non_Billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Billable, true), gettype($non_Billable)), __LINE__);
        }
        $this->Non_Billable = $this->{'Non-Billable'} = $non_Billable;
        return $this;
    }
    /**
     * Get Milestone value
     * @return bool|null
     */
    public function getMilestone()
    {
        return $this->Milestone;
    }
    /**
     * Set Milestone value
     * @param bool $milestone
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setMilestone($milestone = null)
    {
        // validation for constraint: boolean
        if (!is_null($milestone) && !is_bool($milestone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($milestone, true), gettype($milestone)), __LINE__);
        }
        $this->Milestone = $milestone;
        return $this;
    }
    /**
     * Get Closed value
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param bool $closed
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($closed) && !is_bool($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get Utilization value
     * @return bool|null
     */
    public function getUtilization()
    {
        return $this->Utilization;
    }
    /**
     * Set Utilization value
     * @param bool $utilization
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setUtilization($utilization = null)
    {
        // validation for constraint: boolean
        if (!is_null($utilization) && !is_bool($utilization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($utilization, true), gettype($utilization)), __LINE__);
        }
        $this->Utilization = $utilization;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Task_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getTask_Attachment_Data()
    {
        return $this->Task_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTask_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTask_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTask_Attachment_DataForArrayConstraintsFromSetTask_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem) ? get_class($project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem), var_export($project_Plan_Task_WWS_DataTypeTask_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Task_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Task_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $task_Attachment_Data
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setTask_Attachment_Data(array $task_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($task_Attachment_DataArrayErrorMessage = self::validateTask_Attachment_DataForArrayConstraintsFromSetTask_Attachment_Data($task_Attachment_Data))) {
            throw new \InvalidArgumentException($task_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Task_Attachment_Data = $task_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Task_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function addToTask_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Task_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Task_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Plan_Task_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
