<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Request_for_Quote_Response_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cancel a Request for Quote Response if it does not have an active award.
 * @subpackage Structs
 */
class Cancel_Request_for_Quote_Response_RequestType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response_Reference
     * Meta information extracted from the WSDL
     * - documentation: Element that shows the RFQ Response Document worked upon.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_ResponseObjectType
     */
    public $Request_for_Quote_Response_Reference;
    /**
     * The Request_for_Quote_Response_Data
     * Meta information extracted from the WSDL
     * - documentation: Element to capture the RFQ Response to be canceled along with a Cancellation Memo.
     * - minOccurs: 0
     * @var \StructType\Cancel_Request_for_Quote_Response_DataType
     */
    public $Request_for_Quote_Response_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Request_for_Quote_Response_RequestType
     * @uses Cancel_Request_for_Quote_Response_RequestType::setRequest_for_Quote_Response_Reference()
     * @uses Cancel_Request_for_Quote_Response_RequestType::setRequest_for_Quote_Response_Data()
     * @uses Cancel_Request_for_Quote_Response_RequestType::setVersion()
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @param \StructType\Cancel_Request_for_Quote_Response_DataType $request_for_Quote_Response_Data
     * @param string $version
     */
    public function __construct(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null, \StructType\Cancel_Request_for_Quote_Response_DataType $request_for_Quote_Response_Data = null, $version = null)
    {
        $this
            ->setRequest_for_Quote_Response_Reference($request_for_Quote_Response_Reference)
            ->setRequest_for_Quote_Response_Data($request_for_Quote_Response_Data)
            ->setVersion($version);
    }
    /**
     * Get Request_for_Quote_Response_Reference value
     * @return \StructType\Request_for_Quote_ResponseObjectType|null
     */
    public function getRequest_for_Quote_Response_Reference()
    {
        return $this->Request_for_Quote_Response_Reference;
    }
    /**
     * Set Request_for_Quote_Response_Reference value
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @return \StructType\Cancel_Request_for_Quote_Response_RequestType
     */
    public function setRequest_for_Quote_Response_Reference(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null)
    {
        $this->Request_for_Quote_Response_Reference = $request_for_Quote_Response_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Response_Data value
     * @return \StructType\Cancel_Request_for_Quote_Response_DataType|null
     */
    public function getRequest_for_Quote_Response_Data()
    {
        return $this->Request_for_Quote_Response_Data;
    }
    /**
     * Set Request_for_Quote_Response_Data value
     * @param \StructType\Cancel_Request_for_Quote_Response_DataType $request_for_Quote_Response_Data
     * @return \StructType\Cancel_Request_for_Quote_Response_RequestType
     */
    public function setRequest_for_Quote_Response_Data(\StructType\Cancel_Request_for_Quote_Response_DataType $request_for_Quote_Response_Data = null)
    {
        $this->Request_for_Quote_Response_Data = $request_for_Quote_Response_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Request_for_Quote_Response_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
