<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Areas_Changed_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Areas Changed flags. These flags indicate which areas have been updated by Supplier Data, they are readonly and set accordingly by system for web service request.
 * @subpackage Structs
 */
class Areas_Changed_WWS_DataType extends AbstractStructBase
{
    /**
     * The Supplier_and_Tax_Details
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Supplier and Tax Details
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Supplier_and_Tax_Details;
    /**
     * The Payment_Details
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Payment Details
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Payment_Details;
    /**
     * The Supplier_Hierarchy
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Supplier Hierarchy
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Supplier_Hierarchy;
    /**
     * The Contact_Information
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Contact Information
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Contact_Information;
    /**
     * The Settlement_Bank_Account
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Settlement Bank Account
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Settlement_Bank_Account;
    /**
     * The Alternate_Names
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Alternate Names
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Alternate_Names;
    /**
     * The Procurement_Options
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Procurement Options
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Procurement_Options;
    /**
     * The Classifications
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Classifications
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Classifications;
    /**
     * The Contingent__Worker__Options
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Contingent Worker Options
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Contingent__Worker__Options;
    /**
     * The Attachments
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Attachments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Attachments;
    /**
     * The Related_Worktags
     * Meta information extracted from the WSDL
     * - documentation: Indicate there are changes in Supplier Related Worktags
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Related_Worktags;
    /**
     * Constructor method for Areas_Changed_WWS_DataType
     * @uses Areas_Changed_WWS_DataType::setSupplier_and_Tax_Details()
     * @uses Areas_Changed_WWS_DataType::setPayment_Details()
     * @uses Areas_Changed_WWS_DataType::setSupplier_Hierarchy()
     * @uses Areas_Changed_WWS_DataType::setContact_Information()
     * @uses Areas_Changed_WWS_DataType::setSettlement_Bank_Account()
     * @uses Areas_Changed_WWS_DataType::setAlternate_Names()
     * @uses Areas_Changed_WWS_DataType::setProcurement_Options()
     * @uses Areas_Changed_WWS_DataType::setClassifications()
     * @uses Areas_Changed_WWS_DataType::setContingent__Worker__Options()
     * @uses Areas_Changed_WWS_DataType::setAttachments()
     * @uses Areas_Changed_WWS_DataType::setRelated_Worktags()
     * @param bool $supplier_and_Tax_Details
     * @param bool $payment_Details
     * @param bool $supplier_Hierarchy
     * @param bool $contact_Information
     * @param bool $settlement_Bank_Account
     * @param bool $alternate_Names
     * @param bool $procurement_Options
     * @param bool $classifications
     * @param bool $contingent__Worker__Options
     * @param bool $attachments
     * @param bool $related_Worktags
     */
    public function __construct($supplier_and_Tax_Details = null, $payment_Details = null, $supplier_Hierarchy = null, $contact_Information = null, $settlement_Bank_Account = null, $alternate_Names = null, $procurement_Options = null, $classifications = null, $contingent__Worker__Options = null, $attachments = null, $related_Worktags = null)
    {
        $this
            ->setSupplier_and_Tax_Details($supplier_and_Tax_Details)
            ->setPayment_Details($payment_Details)
            ->setSupplier_Hierarchy($supplier_Hierarchy)
            ->setContact_Information($contact_Information)
            ->setSettlement_Bank_Account($settlement_Bank_Account)
            ->setAlternate_Names($alternate_Names)
            ->setProcurement_Options($procurement_Options)
            ->setClassifications($classifications)
            ->setContingent__Worker__Options($contingent__Worker__Options)
            ->setAttachments($attachments)
            ->setRelated_Worktags($related_Worktags);
    }
    /**
     * Get Supplier_and_Tax_Details value
     * @return bool|null
     */
    public function getSupplier_and_Tax_Details()
    {
        return $this->Supplier_and_Tax_Details;
    }
    /**
     * Set Supplier_and_Tax_Details value
     * @param bool $supplier_and_Tax_Details
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setSupplier_and_Tax_Details($supplier_and_Tax_Details = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplier_and_Tax_Details) && !is_bool($supplier_and_Tax_Details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplier_and_Tax_Details, true), gettype($supplier_and_Tax_Details)), __LINE__);
        }
        $this->Supplier_and_Tax_Details = $supplier_and_Tax_Details;
        return $this;
    }
    /**
     * Get Payment_Details value
     * @return bool|null
     */
    public function getPayment_Details()
    {
        return $this->Payment_Details;
    }
    /**
     * Set Payment_Details value
     * @param bool $payment_Details
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setPayment_Details($payment_Details = null)
    {
        // validation for constraint: boolean
        if (!is_null($payment_Details) && !is_bool($payment_Details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payment_Details, true), gettype($payment_Details)), __LINE__);
        }
        $this->Payment_Details = $payment_Details;
        return $this;
    }
    /**
     * Get Supplier_Hierarchy value
     * @return bool|null
     */
    public function getSupplier_Hierarchy()
    {
        return $this->Supplier_Hierarchy;
    }
    /**
     * Set Supplier_Hierarchy value
     * @param bool $supplier_Hierarchy
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setSupplier_Hierarchy($supplier_Hierarchy = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplier_Hierarchy) && !is_bool($supplier_Hierarchy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplier_Hierarchy, true), gettype($supplier_Hierarchy)), __LINE__);
        }
        $this->Supplier_Hierarchy = $supplier_Hierarchy;
        return $this;
    }
    /**
     * Get Contact_Information value
     * @return bool|null
     */
    public function getContact_Information()
    {
        return $this->Contact_Information;
    }
    /**
     * Set Contact_Information value
     * @param bool $contact_Information
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setContact_Information($contact_Information = null)
    {
        // validation for constraint: boolean
        if (!is_null($contact_Information) && !is_bool($contact_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contact_Information, true), gettype($contact_Information)), __LINE__);
        }
        $this->Contact_Information = $contact_Information;
        return $this;
    }
    /**
     * Get Settlement_Bank_Account value
     * @return bool|null
     */
    public function getSettlement_Bank_Account()
    {
        return $this->Settlement_Bank_Account;
    }
    /**
     * Set Settlement_Bank_Account value
     * @param bool $settlement_Bank_Account
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setSettlement_Bank_Account($settlement_Bank_Account = null)
    {
        // validation for constraint: boolean
        if (!is_null($settlement_Bank_Account) && !is_bool($settlement_Bank_Account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($settlement_Bank_Account, true), gettype($settlement_Bank_Account)), __LINE__);
        }
        $this->Settlement_Bank_Account = $settlement_Bank_Account;
        return $this;
    }
    /**
     * Get Alternate_Names value
     * @return bool|null
     */
    public function getAlternate_Names()
    {
        return $this->Alternate_Names;
    }
    /**
     * Set Alternate_Names value
     * @param bool $alternate_Names
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setAlternate_Names($alternate_Names = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternate_Names) && !is_bool($alternate_Names)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alternate_Names, true), gettype($alternate_Names)), __LINE__);
        }
        $this->Alternate_Names = $alternate_Names;
        return $this;
    }
    /**
     * Get Procurement_Options value
     * @return bool|null
     */
    public function getProcurement_Options()
    {
        return $this->Procurement_Options;
    }
    /**
     * Set Procurement_Options value
     * @param bool $procurement_Options
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setProcurement_Options($procurement_Options = null)
    {
        // validation for constraint: boolean
        if (!is_null($procurement_Options) && !is_bool($procurement_Options)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($procurement_Options, true), gettype($procurement_Options)), __LINE__);
        }
        $this->Procurement_Options = $procurement_Options;
        return $this;
    }
    /**
     * Get Classifications value
     * @return bool|null
     */
    public function getClassifications()
    {
        return $this->Classifications;
    }
    /**
     * Set Classifications value
     * @param bool $classifications
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setClassifications($classifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($classifications) && !is_bool($classifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($classifications, true), gettype($classifications)), __LINE__);
        }
        $this->Classifications = $classifications;
        return $this;
    }
    /**
     * Get Contingent__Worker__Options value
     * @return bool|null
     */
    public function getContingent__Worker__Options()
    {
        return $this->Contingent__Worker__Options;
    }
    /**
     * Set Contingent__Worker__Options value
     * @param bool $contingent__Worker__Options
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setContingent__Worker__Options($contingent__Worker__Options = null)
    {
        // validation for constraint: boolean
        if (!is_null($contingent__Worker__Options) && !is_bool($contingent__Worker__Options)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contingent__Worker__Options, true), gettype($contingent__Worker__Options)), __LINE__);
        }
        $this->Contingent__Worker__Options = $contingent__Worker__Options;
        return $this;
    }
    /**
     * Get Attachments value
     * @return bool|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param bool $attachments
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setAttachments($attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($attachments) && !is_bool($attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($attachments, true), gettype($attachments)), __LINE__);
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Get Related_Worktags value
     * @return bool|null
     */
    public function getRelated_Worktags()
    {
        return $this->Related_Worktags;
    }
    /**
     * Set Related_Worktags value
     * @param bool $related_Worktags
     * @return \StructType\Areas_Changed_WWS_DataType
     */
    public function setRelated_Worktags($related_Worktags = null)
    {
        // validation for constraint: boolean
        if (!is_null($related_Worktags) && !is_bool($related_Worktags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($related_Worktags, true), gettype($related_Worktags)), __LINE__);
        }
        $this->Related_Worktags = $related_Worktags;
        return $this;
    }
}
