<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Requisition Response Data
 * @subpackage Structs
 */
class Requisition_Response_DataType extends AbstractStructBase
{
    /**
     * The Requisition
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Requisition data. A Requisition may have multiple goods and deliverable Requisition lines. A Requisition also supports service lines v24.0 onwards.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RequisitionType[]
     */
    public $Requisition;
    /**
     * Constructor method for Requisition_Response_DataType
     * @uses Requisition_Response_DataType::setRequisition()
     * @param \StructType\RequisitionType[] $requisition
     */
    public function __construct(array $requisition = array())
    {
        $this
            ->setRequisition($requisition);
    }
    /**
     * Get Requisition value
     * @return \StructType\RequisitionType[]|null
     */
    public function getRequisition()
    {
        return $this->Requisition;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisitionForArrayConstraintsFromSetRequisition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Response_DataTypeRequisitionItem) {
            // validation for constraint: itemType
            if (!$requisition_Response_DataTypeRequisitionItem instanceof \StructType\RequisitionType) {
                $invalidValues[] = is_object($requisition_Response_DataTypeRequisitionItem) ? get_class($requisition_Response_DataTypeRequisitionItem) : sprintf('%s(%s)', gettype($requisition_Response_DataTypeRequisitionItem), var_export($requisition_Response_DataTypeRequisitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition property can only contain items of type \StructType\RequisitionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionType[] $requisition
     * @return \StructType\Requisition_Response_DataType
     */
    public function setRequisition(array $requisition = array())
    {
        // validation for constraint: array
        if ('' !== ($requisitionArrayErrorMessage = self::validateRequisitionForArrayConstraintsFromSetRequisition($requisition))) {
            throw new \InvalidArgumentException($requisitionArrayErrorMessage, __LINE__);
        }
        $this->Requisition = $requisition;
        return $this;
    }
    /**
     * Add item to Requisition value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionType $item
     * @return \StructType\Requisition_Response_DataType
     */
    public function addToRequisition(\StructType\RequisitionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequisitionType) {
            throw new \InvalidArgumentException(sprintf('The Requisition property can only contain items of type \StructType\RequisitionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition[] = $item;
        return $this;
    }
}
