<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Commodity_Code_Type_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code Type Request
 * @subpackage Structs
 */
class Put_Commodity_Code_Type_RequestType extends AbstractStructBase
{
    /**
     * The Commodity_Code_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Commodity Code Type for update only purposes
     * - minOccurs: 0
     * @var \StructType\Commodity_Code_TypeObjectType
     */
    public $Commodity_Code_Type_Reference;
    /**
     * The Commodity_Code_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Type
     * @var \StructType\Commodity_Code_Type_DataType
     */
    public $Commodity_Code_Type_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Commodity_Code_Type_RequestType
     * @uses Put_Commodity_Code_Type_RequestType::setCommodity_Code_Type_Reference()
     * @uses Put_Commodity_Code_Type_RequestType::setCommodity_Code_Type_Data()
     * @uses Put_Commodity_Code_Type_RequestType::setAdd_Only()
     * @uses Put_Commodity_Code_Type_RequestType::setVersion()
     * @param \StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference
     * @param \StructType\Commodity_Code_Type_DataType $commodity_Code_Type_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference = null, \StructType\Commodity_Code_Type_DataType $commodity_Code_Type_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCommodity_Code_Type_Reference($commodity_Code_Type_Reference)
            ->setCommodity_Code_Type_Data($commodity_Code_Type_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Commodity_Code_Type_Reference value
     * @return \StructType\Commodity_Code_TypeObjectType|null
     */
    public function getCommodity_Code_Type_Reference()
    {
        return $this->Commodity_Code_Type_Reference;
    }
    /**
     * Set Commodity_Code_Type_Reference value
     * @param \StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference
     * @return \StructType\Put_Commodity_Code_Type_RequestType
     */
    public function setCommodity_Code_Type_Reference(\StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference = null)
    {
        $this->Commodity_Code_Type_Reference = $commodity_Code_Type_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Type_Data value
     * @return \StructType\Commodity_Code_Type_DataType|null
     */
    public function getCommodity_Code_Type_Data()
    {
        return $this->Commodity_Code_Type_Data;
    }
    /**
     * Set Commodity_Code_Type_Data value
     * @param \StructType\Commodity_Code_Type_DataType $commodity_Code_Type_Data
     * @return \StructType\Put_Commodity_Code_Type_RequestType
     */
    public function setCommodity_Code_Type_Data(\StructType\Commodity_Code_Type_DataType $commodity_Code_Type_Data = null)
    {
        $this->Commodity_Code_Type_Data = $commodity_Code_Type_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Commodity_Code_Type_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Commodity_Code_Type_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
