<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lease_Payment_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Represents a single payment for the amount on the provided payment date. Only applies to Variable Payment lease contracts.
 * @subpackage Structs
 */
class Lease_Payment_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Payment_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the lease payment.
     * - maxOccurs: 1
     * @var string
     */
    public $Payment_Date;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount for the project subtask. | Unit cost for the expense report line. Leave blank if you are entering a credit card transaction. | The amount of the installment line. | Transaction Extended Amount | The payment amount for this
     * lease payment line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for Lease_Payment_Line_Replacement_DataType
     * @uses Lease_Payment_Line_Replacement_DataType::setPayment_Date()
     * @uses Lease_Payment_Line_Replacement_DataType::setAmount()
     * @param string $payment_Date
     * @param float $amount
     */
    public function __construct($payment_Date = null, $amount = null)
    {
        $this
            ->setPayment_Date($payment_Date)
            ->setAmount($amount);
    }
    /**
     * Get Payment_Date value
     * @return string|null
     */
    public function getPayment_Date()
    {
        return $this->Payment_Date;
    }
    /**
     * Set Payment_Date value
     * @param string $payment_Date
     * @return \StructType\Lease_Payment_Line_Replacement_DataType
     */
    public function setPayment_Date($payment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Date) && !is_string($payment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Date, true), gettype($payment_Date)), __LINE__);
        }
        $this->Payment_Date = $payment_Date;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Lease_Payment_Line_Replacement_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
