<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Hotel object
 * @subpackage Structs
 */
class Hotel_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Hotel Object
     * - maxOccurs: unbounded
     * @var \StructType\HotelObjectType[]
     */
    public $Hotel_Reference;
    /**
     * Constructor method for Hotel_Request_ReferencesType
     * @uses Hotel_Request_ReferencesType::setHotel_Reference()
     * @param \StructType\HotelObjectType[] $hotel_Reference
     */
    public function __construct(array $hotel_Reference = array())
    {
        $this
            ->setHotel_Reference($hotel_Reference);
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType[]|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotel_Request_ReferencesTypeHotel_ReferenceItem) {
            // validation for constraint: itemType
            if (!$hotel_Request_ReferencesTypeHotel_ReferenceItem instanceof \StructType\HotelObjectType) {
                $invalidValues[] = is_object($hotel_Request_ReferencesTypeHotel_ReferenceItem) ? get_class($hotel_Request_ReferencesTypeHotel_ReferenceItem) : sprintf('%s(%s)', gettype($hotel_Request_ReferencesTypeHotel_ReferenceItem), var_export($hotel_Request_ReferencesTypeHotel_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @return \StructType\Hotel_Request_ReferencesType
     */
    public function setHotel_Reference(array $hotel_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_ReferenceArrayErrorMessage = self::validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference($hotel_Reference))) {
            throw new \InvalidArgumentException($hotel_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Add item to Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType $item
     * @return \StructType\Hotel_Request_ReferencesType
     */
    public function addToHotel_Reference(\StructType\HotelObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelObjectType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Reference[] = $item;
        return $this;
    }
}
