<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Contact Information (Email, Phone, Fax) for Bill-To of Purchase Order
 * @subpackage Structs
 */
class Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Phone_Country_Code
     * Meta information extracted from the WSDL
     * - documentation: Phone Country CodecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/CountryCode andRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/CountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/CountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Phone
     * Country Code | Ship-To Phone Country Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Phone_Country_Code;
    /**
     * The Phone_Country_Code_Alpha_2
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Phone Country Code Alpha-2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Country_Code_Alpha_2;
    /**
     * The Phone_Area_Code
     * Meta information extracted from the WSDL
     * - documentation: Phone Area CodecXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/A
     * reaOrCityCodePhone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Phone Area Code | Ship-To Phone Area Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Phone_Area_Code;
    /**
     * The Phone_Number
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Phone Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Number;
    /**
     * The Fax_Country_Code
     * Meta information extracted from the WSDL
     * - documentation: Fax Country CodecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/CountryCode andRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/CountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/CountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Fax
     * Country Code | Ship-To Fax Country Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Fax_Country_Code;
    /**
     * The Fax_Country_Code_Alpha_2
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Fax Country Code Alpha-2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax_Country_Code_Alpha_2;
    /**
     * The Fax_Area_Code
     * Meta information extracted from the WSDL
     * - documentation: Fax Area CodecXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/AreaOrC
     * ityCodePhone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Fax Area Code | Ship-To Fax Area Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Fax_Area_Code;
    /**
     * The Fax_Number
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Fax Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax_Number;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Email
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Deliver_To
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Deliver To
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliver_To;
    /**
     * Constructor method for
     * Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPhone_Country_Code()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPhone_Country_Code_Alpha_2()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPhone_Area_Code()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPhone_Number()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setFax_Country_Code()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setFax_Country_Code_Alpha_2()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setFax_Area_Code()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setFax_Number()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setEmail()
     * @uses Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setDeliver_To()
     * @param float $phone_Country_Code
     * @param string $phone_Country_Code_Alpha_2
     * @param float $phone_Area_Code
     * @param string $phone_Number
     * @param float $fax_Country_Code
     * @param string $fax_Country_Code_Alpha_2
     * @param float $fax_Area_Code
     * @param string $fax_Number
     * @param string $email
     * @param string $deliver_To
     */
    public function __construct($phone_Country_Code = null, $phone_Country_Code_Alpha_2 = null, $phone_Area_Code = null, $phone_Number = null, $fax_Country_Code = null, $fax_Country_Code_Alpha_2 = null, $fax_Area_Code = null, $fax_Number = null, $email = null, $deliver_To = null)
    {
        $this
            ->setPhone_Country_Code($phone_Country_Code)
            ->setPhone_Country_Code_Alpha_2($phone_Country_Code_Alpha_2)
            ->setPhone_Area_Code($phone_Area_Code)
            ->setPhone_Number($phone_Number)
            ->setFax_Country_Code($fax_Country_Code)
            ->setFax_Country_Code_Alpha_2($fax_Country_Code_Alpha_2)
            ->setFax_Area_Code($fax_Area_Code)
            ->setFax_Number($fax_Number)
            ->setEmail($email)
            ->setDeliver_To($deliver_To);
    }
    /**
     * Get Phone_Country_Code value
     * @return float|null
     */
    public function getPhone_Country_Code()
    {
        return $this->Phone_Country_Code;
    }
    /**
     * Set Phone_Country_Code value
     * @param float $phone_Country_Code
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPhone_Country_Code($phone_Country_Code = null)
    {
        // validation for constraint: float
        if (!is_null($phone_Country_Code) && !(is_float($phone_Country_Code) || is_numeric($phone_Country_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($phone_Country_Code, true), gettype($phone_Country_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($phone_Country_Code) && mb_strlen(mb_substr($phone_Country_Code, false !== mb_strpos($phone_Country_Code, '.') ? mb_strpos($phone_Country_Code, '.') + 1 : mb_strlen($phone_Country_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($phone_Country_Code, true), mb_strlen(mb_substr($phone_Country_Code, mb_strpos($phone_Country_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($phone_Country_Code) && $phone_Country_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($phone_Country_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($phone_Country_Code) && mb_strlen(preg_replace('/(\D)/', '', $phone_Country_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($phone_Country_Code, true), mb_strlen(preg_replace('/(\D)/', '', $phone_Country_Code))), __LINE__);
        }
        $this->Phone_Country_Code = $phone_Country_Code;
        return $this;
    }
    /**
     * Get phone_Country_Code_Alpha value
     * @return phone_Country_Code_Alpha
     */
    public function getPhone_Country_Code_Alpha_2()
    {
        return $this->{'Phone_Country_Code_Alpha-2'};
    }
    /**
     * Set phone_Country_Code_Alpha value
     * @param phone_Country_Code_Alpha $phone_Country_Code_Alpha
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPhone_Country_Code_Alpha_2($phone_Country_Code_Alpha_2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Country_Code_Alpha_2) && !is_string($phone_Country_Code_Alpha_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Country_Code_Alpha_2, true), gettype($phone_Country_Code_Alpha_2)), __LINE__);
        }
        $this->Phone_Country_Code_Alpha_2 = $this->{'Phone_Country_Code_Alpha-2'} = $phone_Country_Code_Alpha_2;
        return $this;
    }
    /**
     * Get Phone_Area_Code value
     * @return float|null
     */
    public function getPhone_Area_Code()
    {
        return $this->Phone_Area_Code;
    }
    /**
     * Set Phone_Area_Code value
     * @param float $phone_Area_Code
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPhone_Area_Code($phone_Area_Code = null)
    {
        // validation for constraint: float
        if (!is_null($phone_Area_Code) && !(is_float($phone_Area_Code) || is_numeric($phone_Area_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($phone_Area_Code, true), gettype($phone_Area_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($phone_Area_Code) && mb_strlen(mb_substr($phone_Area_Code, false !== mb_strpos($phone_Area_Code, '.') ? mb_strpos($phone_Area_Code, '.') + 1 : mb_strlen($phone_Area_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($phone_Area_Code, true), mb_strlen(mb_substr($phone_Area_Code, mb_strpos($phone_Area_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($phone_Area_Code) && $phone_Area_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($phone_Area_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($phone_Area_Code) && mb_strlen(preg_replace('/(\D)/', '', $phone_Area_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($phone_Area_Code, true), mb_strlen(preg_replace('/(\D)/', '', $phone_Area_Code))), __LINE__);
        }
        $this->Phone_Area_Code = $phone_Area_Code;
        return $this;
    }
    /**
     * Get Phone_Number value
     * @return string|null
     */
    public function getPhone_Number()
    {
        return $this->Phone_Number;
    }
    /**
     * Set Phone_Number value
     * @param string $phone_Number
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPhone_Number($phone_Number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Number) && !is_string($phone_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Number, true), gettype($phone_Number)), __LINE__);
        }
        $this->Phone_Number = $phone_Number;
        return $this;
    }
    /**
     * Get Fax_Country_Code value
     * @return float|null
     */
    public function getFax_Country_Code()
    {
        return $this->Fax_Country_Code;
    }
    /**
     * Set Fax_Country_Code value
     * @param float $fax_Country_Code
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setFax_Country_Code($fax_Country_Code = null)
    {
        // validation for constraint: float
        if (!is_null($fax_Country_Code) && !(is_float($fax_Country_Code) || is_numeric($fax_Country_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fax_Country_Code, true), gettype($fax_Country_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($fax_Country_Code) && mb_strlen(mb_substr($fax_Country_Code, false !== mb_strpos($fax_Country_Code, '.') ? mb_strpos($fax_Country_Code, '.') + 1 : mb_strlen($fax_Country_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($fax_Country_Code, true), mb_strlen(mb_substr($fax_Country_Code, mb_strpos($fax_Country_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fax_Country_Code) && $fax_Country_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fax_Country_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($fax_Country_Code) && mb_strlen(preg_replace('/(\D)/', '', $fax_Country_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($fax_Country_Code, true), mb_strlen(preg_replace('/(\D)/', '', $fax_Country_Code))), __LINE__);
        }
        $this->Fax_Country_Code = $fax_Country_Code;
        return $this;
    }
    /**
     * Get fax_Country_Code_Alpha value
     * @return fax_Country_Code_Alpha
     */
    public function getFax_Country_Code_Alpha_2()
    {
        return $this->{'Fax_Country_Code_Alpha-2'};
    }
    /**
     * Set fax_Country_Code_Alpha value
     * @param fax_Country_Code_Alpha $fax_Country_Code_Alpha
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setFax_Country_Code_Alpha_2($fax_Country_Code_Alpha_2 = null)
    {
        // validation for constraint: string
        if (!is_null($fax_Country_Code_Alpha_2) && !is_string($fax_Country_Code_Alpha_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_Country_Code_Alpha_2, true), gettype($fax_Country_Code_Alpha_2)), __LINE__);
        }
        $this->Fax_Country_Code_Alpha_2 = $this->{'Fax_Country_Code_Alpha-2'} = $fax_Country_Code_Alpha_2;
        return $this;
    }
    /**
     * Get Fax_Area_Code value
     * @return float|null
     */
    public function getFax_Area_Code()
    {
        return $this->Fax_Area_Code;
    }
    /**
     * Set Fax_Area_Code value
     * @param float $fax_Area_Code
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setFax_Area_Code($fax_Area_Code = null)
    {
        // validation for constraint: float
        if (!is_null($fax_Area_Code) && !(is_float($fax_Area_Code) || is_numeric($fax_Area_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fax_Area_Code, true), gettype($fax_Area_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($fax_Area_Code) && mb_strlen(mb_substr($fax_Area_Code, false !== mb_strpos($fax_Area_Code, '.') ? mb_strpos($fax_Area_Code, '.') + 1 : mb_strlen($fax_Area_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($fax_Area_Code, true), mb_strlen(mb_substr($fax_Area_Code, mb_strpos($fax_Area_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fax_Area_Code) && $fax_Area_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fax_Area_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($fax_Area_Code) && mb_strlen(preg_replace('/(\D)/', '', $fax_Area_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($fax_Area_Code, true), mb_strlen(preg_replace('/(\D)/', '', $fax_Area_Code))), __LINE__);
        }
        $this->Fax_Area_Code = $fax_Area_Code;
        return $this;
    }
    /**
     * Get Fax_Number value
     * @return string|null
     */
    public function getFax_Number()
    {
        return $this->Fax_Number;
    }
    /**
     * Set Fax_Number value
     * @param string $fax_Number
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setFax_Number($fax_Number = null)
    {
        // validation for constraint: string
        if (!is_null($fax_Number) && !is_string($fax_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_Number, true), gettype($fax_Number)), __LINE__);
        }
        $this->Fax_Number = $fax_Number;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Deliver_To value
     * @return string|null
     */
    public function getDeliver_To()
    {
        return $this->Deliver_To;
    }
    /**
     * Set Deliver_To value
     * @param string $deliver_To
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setDeliver_To($deliver_To = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_To) && !is_string($deliver_To)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_To, true), gettype($deliver_To)), __LINE__);
        }
        $this->Deliver_To = $deliver_To;
        return $this;
    }
}
