<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Impairment_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for impairment activity for this asset.
 * @subpackage Structs
 */
class Asset_Impairment_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was impaired or the transaction effective date of the impairment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Current_Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: The current fair market value at the time of the impairment.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Current_Fair_Market_Value;
    /**
     * The Revised_Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: The revised fair market value after the impairment was recorded.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Revised_Fair_Market_Value;
    /**
     * The Impairment_Amount
     * Meta information extracted from the WSDL
     * - documentation: The impairment amount. This is the difference between the Current Fair Market Value and Revised Fair Market Value for the asset impairment.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Impairment_Amount;
    /**
     * The Impairment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the reason recorded for the asset impairment.
     * - minOccurs: 0
     * @var \StructType\Asset_Impairment_ReasonObjectType
     */
    public $Impairment_Reason_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comments entered by the user when impairing the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Asset_Impairment_WWS_DataType
     * @uses Asset_Impairment_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Impairment_WWS_DataType::setCurrent_Fair_Market_Value()
     * @uses Asset_Impairment_WWS_DataType::setRevised_Fair_Market_Value()
     * @uses Asset_Impairment_WWS_DataType::setImpairment_Amount()
     * @uses Asset_Impairment_WWS_DataType::setImpairment_Reason_Reference()
     * @uses Asset_Impairment_WWS_DataType::setComment()
     * @param string $transaction_Effective_Date
     * @param float $current_Fair_Market_Value
     * @param float $revised_Fair_Market_Value
     * @param float $impairment_Amount
     * @param \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference
     * @param string $comment
     */
    public function __construct($transaction_Effective_Date = null, $current_Fair_Market_Value = null, $revised_Fair_Market_Value = null, $impairment_Amount = null, \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference = null, $comment = null)
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setCurrent_Fair_Market_Value($current_Fair_Market_Value)
            ->setRevised_Fair_Market_Value($revised_Fair_Market_Value)
            ->setImpairment_Amount($impairment_Amount)
            ->setImpairment_Reason_Reference($impairment_Reason_Reference)
            ->setComment($comment);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Current_Fair_Market_Value value
     * @return float|null
     */
    public function getCurrent_Fair_Market_Value()
    {
        return $this->Current_Fair_Market_Value;
    }
    /**
     * Set Current_Fair_Market_Value value
     * @param float $current_Fair_Market_Value
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setCurrent_Fair_Market_Value($current_Fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($current_Fair_Market_Value) && !(is_float($current_Fair_Market_Value) || is_numeric($current_Fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($current_Fair_Market_Value, true), gettype($current_Fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($current_Fair_Market_Value) && mb_strlen(mb_substr($current_Fair_Market_Value, false !== mb_strpos($current_Fair_Market_Value, '.') ? mb_strpos($current_Fair_Market_Value, '.') + 1 : mb_strlen($current_Fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($current_Fair_Market_Value, true), mb_strlen(mb_substr($current_Fair_Market_Value, mb_strpos($current_Fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($current_Fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $current_Fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($current_Fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $current_Fair_Market_Value))), __LINE__);
        }
        $this->Current_Fair_Market_Value = $current_Fair_Market_Value;
        return $this;
    }
    /**
     * Get Revised_Fair_Market_Value value
     * @return float|null
     */
    public function getRevised_Fair_Market_Value()
    {
        return $this->Revised_Fair_Market_Value;
    }
    /**
     * Set Revised_Fair_Market_Value value
     * @param float $revised_Fair_Market_Value
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setRevised_Fair_Market_Value($revised_Fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($revised_Fair_Market_Value) && !(is_float($revised_Fair_Market_Value) || is_numeric($revised_Fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($revised_Fair_Market_Value, true), gettype($revised_Fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($revised_Fair_Market_Value) && mb_strlen(mb_substr($revised_Fair_Market_Value, false !== mb_strpos($revised_Fair_Market_Value, '.') ? mb_strpos($revised_Fair_Market_Value, '.') + 1 : mb_strlen($revised_Fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($revised_Fair_Market_Value, true), mb_strlen(mb_substr($revised_Fair_Market_Value, mb_strpos($revised_Fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($revised_Fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $revised_Fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($revised_Fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $revised_Fair_Market_Value))), __LINE__);
        }
        $this->Revised_Fair_Market_Value = $revised_Fair_Market_Value;
        return $this;
    }
    /**
     * Get Impairment_Amount value
     * @return float|null
     */
    public function getImpairment_Amount()
    {
        return $this->Impairment_Amount;
    }
    /**
     * Set Impairment_Amount value
     * @param float $impairment_Amount
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setImpairment_Amount($impairment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($impairment_Amount) && !(is_float($impairment_Amount) || is_numeric($impairment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impairment_Amount, true), gettype($impairment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($impairment_Amount) && mb_strlen(mb_substr($impairment_Amount, false !== mb_strpos($impairment_Amount, '.') ? mb_strpos($impairment_Amount, '.') + 1 : mb_strlen($impairment_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($impairment_Amount, true), mb_strlen(mb_substr($impairment_Amount, mb_strpos($impairment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($impairment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $impairment_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($impairment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $impairment_Amount))), __LINE__);
        }
        $this->Impairment_Amount = $impairment_Amount;
        return $this;
    }
    /**
     * Get Impairment_Reason_Reference value
     * @return \StructType\Asset_Impairment_ReasonObjectType|null
     */
    public function getImpairment_Reason_Reference()
    {
        return $this->Impairment_Reason_Reference;
    }
    /**
     * Set Impairment_Reason_Reference value
     * @param \StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setImpairment_Reason_Reference(\StructType\Asset_Impairment_ReasonObjectType $impairment_Reason_Reference = null)
    {
        $this->Impairment_Reason_Reference = $impairment_Reason_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Asset_Impairment_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
