<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains an Asset Reference and corresponding data to be edited.
 * @subpackage Structs
 */
class Edit_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Asset_Edit_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Asset Reference
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Edit_Reference;
    /**
     * The Asset_Edit_Data
     * Meta information extracted from the WSDL
     * - documentation: Data that may be updated using the asset's related task Asset Edit, such as description, name, identifier, serial number, asset class, asset type, asset manufacturer, related assets and attachments. If any attributes are updated that
     * bonus depreciation rules are based on (e.g. asset type or asset class), bonus depreciation percent is not defaulted again from bonus depreciation rules.
     * @var \StructType\Asset_Edit_DataType
     */
    public $Asset_Edit_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Edit_Asset_RequestType
     * @uses Edit_Asset_RequestType::setAsset_Edit_Reference()
     * @uses Edit_Asset_RequestType::setAsset_Edit_Data()
     * @uses Edit_Asset_RequestType::setVersion()
     * @param \StructType\Business_AssetObjectType $asset_Edit_Reference
     * @param \StructType\Asset_Edit_DataType $asset_Edit_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Edit_Reference = null, \StructType\Asset_Edit_DataType $asset_Edit_Data = null, $version = null)
    {
        $this
            ->setAsset_Edit_Reference($asset_Edit_Reference)
            ->setAsset_Edit_Data($asset_Edit_Data)
            ->setVersion($version);
    }
    /**
     * Get Asset_Edit_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Edit_Reference()
    {
        return $this->Asset_Edit_Reference;
    }
    /**
     * Set Asset_Edit_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Edit_Reference
     * @return \StructType\Edit_Asset_RequestType
     */
    public function setAsset_Edit_Reference(\StructType\Business_AssetObjectType $asset_Edit_Reference = null)
    {
        $this->Asset_Edit_Reference = $asset_Edit_Reference;
        return $this;
    }
    /**
     * Get Asset_Edit_Data value
     * @return \StructType\Asset_Edit_DataType|null
     */
    public function getAsset_Edit_Data()
    {
        return $this->Asset_Edit_Data;
    }
    /**
     * Set Asset_Edit_Data value
     * @param \StructType\Asset_Edit_DataType $asset_Edit_Data
     * @return \StructType\Edit_Asset_RequestType
     */
    public function setAsset_Edit_Data(\StructType\Asset_Edit_DataType $asset_Edit_Data = null)
    {
        $this->Asset_Edit_Data = $asset_Edit_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Edit_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
