<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Alternate_Item_Identifiers_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Alternate Item Identifiers Data
 * @subpackage Structs
 */
class Alternate_Item_Identifiers_DataType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Item Identifier Types associated with the Spend Category
     * @var \StructType\Item_Identifier_TypeObjectType
     */
    public $Item_Identifier_Type_Reference;
    /**
     * The Alternate_Item_Identifier_Value
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Type Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alternate_Item_Identifier_Value;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure associated to the value.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Manufacturer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Manufacturer associated with the Item Identifier Type
     * - minOccurs: 0
     * @var \StructType\ManufacturerObjectType
     */
    public $Manufacturer_Reference;
    /**
     * Constructor method for Alternate_Item_Identifiers_DataType
     * @uses Alternate_Item_Identifiers_DataType::setItem_Identifier_Type_Reference()
     * @uses Alternate_Item_Identifiers_DataType::setAlternate_Item_Identifier_Value()
     * @uses Alternate_Item_Identifiers_DataType::setUnit_of_Measure_Reference()
     * @uses Alternate_Item_Identifiers_DataType::setManufacturer_Reference()
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @param string $alternate_Item_Identifier_Value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     */
    public function __construct(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null, $alternate_Item_Identifier_Value = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, \StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference)
            ->setAlternate_Item_Identifier_Value($alternate_Item_Identifier_Value)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setManufacturer_Reference($manufacturer_Reference);
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @return \StructType\Alternate_Item_Identifiers_DataType
     */
    public function setItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null)
    {
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifier_Value value
     * @return string|null
     */
    public function getAlternate_Item_Identifier_Value()
    {
        return $this->Alternate_Item_Identifier_Value;
    }
    /**
     * Set Alternate_Item_Identifier_Value value
     * @param string $alternate_Item_Identifier_Value
     * @return \StructType\Alternate_Item_Identifiers_DataType
     */
    public function setAlternate_Item_Identifier_Value($alternate_Item_Identifier_Value = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Item_Identifier_Value) && !is_string($alternate_Item_Identifier_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Item_Identifier_Value, true), gettype($alternate_Item_Identifier_Value)), __LINE__);
        }
        $this->Alternate_Item_Identifier_Value = $alternate_Item_Identifier_Value;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Alternate_Item_Identifiers_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Manufacturer_Reference value
     * @return \StructType\ManufacturerObjectType|null
     */
    public function getManufacturer_Reference()
    {
        return $this->Manufacturer_Reference;
    }
    /**
     * Set Manufacturer_Reference value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @return \StructType\Alternate_Item_Identifiers_DataType
     */
    public function setManufacturer_Reference(\StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this->Manufacturer_Reference = $manufacturer_Reference;
        return $this;
    }
}
