<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains references to existing Advanced Ship Notices to be retrieved.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to existing Advanced Ship Notices to be retrieved via the Get Advanced Ship Notices Web Service operation
     * - maxOccurs: unbounded
     * @var \StructType\Advanced_Ship_NoticeObjectType[]
     */
    public $Advanced_Ship_Notice_Reference;
    /**
     * Constructor method for Advanced_Ship_Notice_Request_ReferencesType
     * @uses Advanced_Ship_Notice_Request_ReferencesType::setAdvanced_Ship_Notice_Reference()
     * @param \StructType\Advanced_Ship_NoticeObjectType[] $advanced_Ship_Notice_Reference
     */
    public function __construct(array $advanced_Ship_Notice_Reference = array())
    {
        $this
            ->setAdvanced_Ship_Notice_Reference($advanced_Ship_Notice_Reference);
    }
    /**
     * Get Advanced_Ship_Notice_Reference value
     * @return \StructType\Advanced_Ship_NoticeObjectType[]|null
     */
    public function getAdvanced_Ship_Notice_Reference()
    {
        return $this->Advanced_Ship_Notice_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvanced_Ship_Notice_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvanced_Ship_Notice_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvanced_Ship_Notice_ReferenceForArrayConstraintsFromSetAdvanced_Ship_Notice_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem instanceof \StructType\Advanced_Ship_NoticeObjectType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem) ? get_class($advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem), var_export($advanced_Ship_Notice_Request_ReferencesTypeAdvanced_Ship_Notice_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Advanced_Ship_Notice_Reference property can only contain items of type \StructType\Advanced_Ship_NoticeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Advanced_Ship_Notice_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_NoticeObjectType[] $advanced_Ship_Notice_Reference
     * @return \StructType\Advanced_Ship_Notice_Request_ReferencesType
     */
    public function setAdvanced_Ship_Notice_Reference(array $advanced_Ship_Notice_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($advanced_Ship_Notice_ReferenceArrayErrorMessage = self::validateAdvanced_Ship_Notice_ReferenceForArrayConstraintsFromSetAdvanced_Ship_Notice_Reference($advanced_Ship_Notice_Reference))) {
            throw new \InvalidArgumentException($advanced_Ship_Notice_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Advanced_Ship_Notice_Reference = $advanced_Ship_Notice_Reference;
        return $this;
    }
    /**
     * Add item to Advanced_Ship_Notice_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_NoticeObjectType $item
     * @return \StructType\Advanced_Ship_Notice_Request_ReferencesType
     */
    public function addToAdvanced_Ship_Notice_Reference(\StructType\Advanced_Ship_NoticeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Advanced_Ship_NoticeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Advanced_Ship_Notice_Reference property can only contain items of type \StructType\Advanced_Ship_NoticeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Advanced_Ship_Notice_Reference[] = $item;
        return $this;
    }
}
