<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Asset_To_Different_Company_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data needed to transfer Asset to another Company.
 * @subpackage Structs
 */
class Transfer_Asset_To_Different_Company_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Transfer_Asset_To_Different_Company_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the items needed to Transfer an Asset to another Company.
     * - minOccurs: 0
     * @var \StructType\Transfer_Asset_To_Different_Company_DataType
     */
    public $Transfer_Asset_To_Different_Company_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Transfer_Asset_To_Different_Company_RequestType
     * @uses Transfer_Asset_To_Different_Company_RequestType::setBusiness_Process_Parameters()
     * @uses Transfer_Asset_To_Different_Company_RequestType::setTransfer_Asset_To_Different_Company_Data()
     * @uses Transfer_Asset_To_Different_Company_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Transfer_Asset_To_Different_Company_DataType $transfer_Asset_To_Different_Company_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Transfer_Asset_To_Different_Company_DataType $transfer_Asset_To_Different_Company_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setTransfer_Asset_To_Different_Company_Data($transfer_Asset_To_Different_Company_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Transfer_Asset_To_Different_Company_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Transfer_Asset_To_Different_Company_Data value
     * @return \StructType\Transfer_Asset_To_Different_Company_DataType|null
     */
    public function getTransfer_Asset_To_Different_Company_Data()
    {
        return $this->Transfer_Asset_To_Different_Company_Data;
    }
    /**
     * Set Transfer_Asset_To_Different_Company_Data value
     * @param \StructType\Transfer_Asset_To_Different_Company_DataType $transfer_Asset_To_Different_Company_Data
     * @return \StructType\Transfer_Asset_To_Different_Company_RequestType
     */
    public function setTransfer_Asset_To_Different_Company_Data(\StructType\Transfer_Asset_To_Different_Company_DataType $transfer_Asset_To_Different_Company_Data = null)
    {
        $this->Transfer_Asset_To_Different_Company_Data = $transfer_Asset_To_Different_Company_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Transfer_Asset_To_Different_Company_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
