<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Purchase_Order_Acknowledgement_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The Purchase Order Acknowledgement cannot be submitted in invalid status. | Purchase Order Acknowledgements cannot be submitted when the tenant is not set to use this feature. | The Purchase Order Acknowledgement cannot be submitted.
 * Acknowledgement is not in In Progress or Draft status. | The Web Service is set to Add Only; documents cannot be resubmitted. | Contains purchase order reference and all purchase order acknowledgement data items.
 * @subpackage Structs
 */
class Submit_Purchase_Order_Acknowledgement_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to an existing Purchase Order Acknowledgement for update only.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_AcknowledgementObjectType
     */
    public $Purchase_Order_Acknowledgement_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Purchase_Order_Acknowledgement_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains purchase order acknowledgement header and line data.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Acknowledgement_DataType
     */
    public $Purchase_Order_Acknowledgement_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Purchase_Order_Acknowledgement_RequestType
     * @uses Submit_Purchase_Order_Acknowledgement_RequestType::setPurchase_Order_Acknowledgement_Reference()
     * @uses Submit_Purchase_Order_Acknowledgement_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Purchase_Order_Acknowledgement_RequestType::setPurchase_Order_Acknowledgement_Data()
     * @uses Submit_Purchase_Order_Acknowledgement_RequestType::setAdd_Only()
     * @uses Submit_Purchase_Order_Acknowledgement_RequestType::setVersion()
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Purchase_Order_Acknowledgement_DataType $purchase_Order_Acknowledgement_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Purchase_Order_Acknowledgement_DataType $purchase_Order_Acknowledgement_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPurchase_Order_Acknowledgement_Data($purchase_Order_Acknowledgement_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Acknowledgement_Reference value
     * @return \StructType\Purchase_Order_AcknowledgementObjectType|null
     */
    public function getPurchase_Order_Acknowledgement_Reference()
    {
        return $this->Purchase_Order_Acknowledgement_Reference;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Reference value
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_RequestType
     */
    public function setPurchase_Order_Acknowledgement_Reference(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null)
    {
        $this->Purchase_Order_Acknowledgement_Reference = $purchase_Order_Acknowledgement_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Purchase_Order_Acknowledgement_Data value
     * @return \StructType\Purchase_Order_Acknowledgement_DataType|null
     */
    public function getPurchase_Order_Acknowledgement_Data()
    {
        return $this->Purchase_Order_Acknowledgement_Data;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Data value
     * @param \StructType\Purchase_Order_Acknowledgement_DataType $purchase_Order_Acknowledgement_Data
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_RequestType
     */
    public function setPurchase_Order_Acknowledgement_Data(\StructType\Purchase_Order_Acknowledgement_DataType $purchase_Order_Acknowledgement_Data = null)
    {
        $this->Purchase_Order_Acknowledgement_Data = $purchase_Order_Acknowledgement_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
