<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Participant_List_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the proposed suppliers for the Request for Quote at header level.
 * @subpackage Structs
 */
class Request_for_Quote_Participant_List_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier reference.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Issue Option for RFQ Participant.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Issue_Option_Reference;
    /**
     * The Override_Contact_Email_Reference
     * Meta information extracted from the WSDL
     * - documentation: Email address of RFQ Participant.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Override_Contact_Email_Reference;
    /**
     * Constructor method for Request_for_Quote_Participant_List_DataType
     * @uses Request_for_Quote_Participant_List_DataType::setSupplier_Reference()
     * @uses Request_for_Quote_Participant_List_DataType::setIssue_Option_Reference()
     * @uses Request_for_Quote_Participant_List_DataType::setOverride_Contact_Email_Reference()
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $override_Contact_Email_Reference
     */
    public function __construct(\StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null, array $override_Contact_Email_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setIssue_Option_Reference($issue_Option_Reference)
            ->setOverride_Contact_Email_Reference($override_Contact_Email_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Request_for_Quote_Participant_List_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getIssue_Option_Reference()
    {
        return $this->Issue_Option_Reference;
    }
    /**
     * Set Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @return \StructType\Request_for_Quote_Participant_List_DataType
     */
    public function setIssue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null)
    {
        $this->Issue_Option_Reference = $issue_Option_Reference;
        return $this;
    }
    /**
     * Get Override_Contact_Email_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getOverride_Contact_Email_Reference()
    {
        return $this->Override_Contact_Email_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOverride_Contact_Email_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOverride_Contact_Email_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOverride_Contact_Email_ReferenceForArrayConstraintsFromSetOverride_Contact_Email_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem) ? get_class($request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem), var_export($request_for_Quote_Participant_List_DataTypeOverride_Contact_Email_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Override_Contact_Email_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Override_Contact_Email_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $override_Contact_Email_Reference
     * @return \StructType\Request_for_Quote_Participant_List_DataType
     */
    public function setOverride_Contact_Email_Reference(array $override_Contact_Email_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($override_Contact_Email_ReferenceArrayErrorMessage = self::validateOverride_Contact_Email_ReferenceForArrayConstraintsFromSetOverride_Contact_Email_Reference($override_Contact_Email_Reference))) {
            throw new \InvalidArgumentException($override_Contact_Email_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Override_Contact_Email_Reference = $override_Contact_Email_Reference;
        return $this;
    }
    /**
     * Add item to Override_Contact_Email_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Request_for_Quote_Participant_List_DataType
     */
    public function addToOverride_Contact_Email_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Override_Contact_Email_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Override_Contact_Email_Reference[] = $item;
        return $this;
    }
}
