<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_External_Transaction_Source_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Put Request for External Transaction Source
 * @subpackage Structs
 */
class Put_External_Transaction_Source_RequestType extends AbstractStructBase
{
    /**
     * The External_Transaction_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for External Transaction Source
     * - minOccurs: 0
     * @var \StructType\External_Transaction_SourceObjectType
     */
    public $External_Transaction_Source_Reference;
    /**
     * The External_Transaction_Source_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for External Transaction Source
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source_DataType
     */
    public $External_Transaction_Source_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_External_Transaction_Source_RequestType
     * @uses Put_External_Transaction_Source_RequestType::setExternal_Transaction_Source_Reference()
     * @uses Put_External_Transaction_Source_RequestType::setExternal_Transaction_Source_Data()
     * @uses Put_External_Transaction_Source_RequestType::setAdd_Only()
     * @uses Put_External_Transaction_Source_RequestType::setVersion()
     * @param \StructType\External_Transaction_SourceObjectType $external_Transaction_Source_Reference
     * @param \StructType\External_Transaction_Source_DataType $external_Transaction_Source_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\External_Transaction_SourceObjectType $external_Transaction_Source_Reference = null, \StructType\External_Transaction_Source_DataType $external_Transaction_Source_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExternal_Transaction_Source_Reference($external_Transaction_Source_Reference)
            ->setExternal_Transaction_Source_Data($external_Transaction_Source_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get External_Transaction_Source_Reference value
     * @return \StructType\External_Transaction_SourceObjectType|null
     */
    public function getExternal_Transaction_Source_Reference()
    {
        return $this->External_Transaction_Source_Reference;
    }
    /**
     * Set External_Transaction_Source_Reference value
     * @param \StructType\External_Transaction_SourceObjectType $external_Transaction_Source_Reference
     * @return \StructType\Put_External_Transaction_Source_RequestType
     */
    public function setExternal_Transaction_Source_Reference(\StructType\External_Transaction_SourceObjectType $external_Transaction_Source_Reference = null)
    {
        $this->External_Transaction_Source_Reference = $external_Transaction_Source_Reference;
        return $this;
    }
    /**
     * Get External_Transaction_Source_Data value
     * @return \StructType\External_Transaction_Source_DataType|null
     */
    public function getExternal_Transaction_Source_Data()
    {
        return $this->External_Transaction_Source_Data;
    }
    /**
     * Set External_Transaction_Source_Data value
     * @param \StructType\External_Transaction_Source_DataType $external_Transaction_Source_Data
     * @return \StructType\Put_External_Transaction_Source_RequestType
     */
    public function setExternal_Transaction_Source_Data(\StructType\External_Transaction_Source_DataType $external_Transaction_Source_Data = null)
    {
        $this->External_Transaction_Source_Data = $external_Transaction_Source_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_External_Transaction_Source_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_External_Transaction_Source_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
