<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Resource_Requirement_Parameter_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Resource Requirement Parameter Data
 * @subpackage Structs
 */
class Project_Resource_Requirement_Parameter_DataType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Project_Resource_Requirement_Parameter_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Role Resource Plan Requirement Parameter ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Resource_Requirement_Parameter_ID;
    /**
     * The Requirement_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requirement category
     * - minOccurs: 0
     * @var \StructType\External_FieldObjectType
     */
    public $Requirement_Field_Reference;
    /**
     * The Requirement_Value_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requirement value
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InstanceObjectType[]
     */
    public $Requirement_Value_Reference;
    /**
     * Constructor method for Project_Resource_Requirement_Parameter_DataType
     * @uses Project_Resource_Requirement_Parameter_DataType::setDelete()
     * @uses Project_Resource_Requirement_Parameter_DataType::setProject_Resource_Requirement_Parameter_ID()
     * @uses Project_Resource_Requirement_Parameter_DataType::setRequirement_Field_Reference()
     * @uses Project_Resource_Requirement_Parameter_DataType::setRequirement_Value_Reference()
     * @param bool $delete
     * @param string $project_Resource_Requirement_Parameter_ID
     * @param \StructType\External_FieldObjectType $requirement_Field_Reference
     * @param \StructType\InstanceObjectType[] $requirement_Value_Reference
     */
    public function __construct($delete = null, $project_Resource_Requirement_Parameter_ID = null, \StructType\External_FieldObjectType $requirement_Field_Reference = null, array $requirement_Value_Reference = array())
    {
        $this
            ->setDelete($delete)
            ->setProject_Resource_Requirement_Parameter_ID($project_Resource_Requirement_Parameter_ID)
            ->setRequirement_Field_Reference($requirement_Field_Reference)
            ->setRequirement_Value_Reference($requirement_Value_Reference);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Project_Resource_Requirement_Parameter_ID value
     * @return string|null
     */
    public function getProject_Resource_Requirement_Parameter_ID()
    {
        return $this->Project_Resource_Requirement_Parameter_ID;
    }
    /**
     * Set Project_Resource_Requirement_Parameter_ID value
     * @param string $project_Resource_Requirement_Parameter_ID
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType
     */
    public function setProject_Resource_Requirement_Parameter_ID($project_Resource_Requirement_Parameter_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Resource_Requirement_Parameter_ID) && !is_string($project_Resource_Requirement_Parameter_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Resource_Requirement_Parameter_ID, true), gettype($project_Resource_Requirement_Parameter_ID)), __LINE__);
        }
        $this->Project_Resource_Requirement_Parameter_ID = $project_Resource_Requirement_Parameter_ID;
        return $this;
    }
    /**
     * Get Requirement_Field_Reference value
     * @return \StructType\External_FieldObjectType|null
     */
    public function getRequirement_Field_Reference()
    {
        return $this->Requirement_Field_Reference;
    }
    /**
     * Set Requirement_Field_Reference value
     * @param \StructType\External_FieldObjectType $requirement_Field_Reference
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType
     */
    public function setRequirement_Field_Reference(\StructType\External_FieldObjectType $requirement_Field_Reference = null)
    {
        $this->Requirement_Field_Reference = $requirement_Field_Reference;
        return $this;
    }
    /**
     * Get Requirement_Value_Reference value
     * @return \StructType\InstanceObjectType[]|null
     */
    public function getRequirement_Value_Reference()
    {
        return $this->Requirement_Value_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequirement_Value_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequirement_Value_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequirement_Value_ReferenceForArrayConstraintsFromSetRequirement_Value_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem instanceof \StructType\InstanceObjectType) {
                $invalidValues[] = is_object($project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) ? get_class($project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) : sprintf('%s(%s)', gettype($project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem), var_export($project_Resource_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requirement_Value_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requirement_Value_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType[] $requirement_Value_Reference
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType
     */
    public function setRequirement_Value_Reference(array $requirement_Value_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requirement_Value_ReferenceArrayErrorMessage = self::validateRequirement_Value_ReferenceForArrayConstraintsFromSetRequirement_Value_Reference($requirement_Value_Reference))) {
            throw new \InvalidArgumentException($requirement_Value_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requirement_Value_Reference = $requirement_Value_Reference;
        return $this;
    }
    /**
     * Add item to Requirement_Value_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType $item
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType
     */
    public function addToRequirement_Value_Reference(\StructType\InstanceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstanceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requirement_Value_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requirement_Value_Reference[] = $item;
        return $this;
    }
}
