<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Mass_Close_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the Procurement Mass Close Data.
 * @subpackage Structs
 */
class Procurement_Mass_Close_DataType extends AbstractStructBase
{
    /**
     * The Procurement_Mass_Close_ID
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Procurement_Mass_Close_ID;
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company or Company Hierarchy Reference
     * @var \StructType\OrganizationObjectType
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Procurement_Document_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Document Type Reference
     * @var \StructType\Procurement_Document_TypeObjectType
     */
    public $Procurement_Document_Type_Reference;
    /**
     * The Procurement_Mass_Close_Request_Name
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Request Name
     * - maxOccurs: 1
     * @var string
     */
    public $Procurement_Mass_Close_Request_Name;
    /**
     * The Accounting_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Accounting Date Override to be used by any liquidation journals created when mass closing documents.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Date_Override;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Procurement_Mass_Close_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Line Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Year_End_Request_Line_DataType[]
     */
    public $Procurement_Mass_Close_Line_Data;
    /**
     * Constructor method for Procurement_Mass_Close_DataType
     * @uses Procurement_Mass_Close_DataType::setProcurement_Mass_Close_ID()
     * @uses Procurement_Mass_Close_DataType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Procurement_Mass_Close_DataType::setProcurement_Document_Type_Reference()
     * @uses Procurement_Mass_Close_DataType::setProcurement_Mass_Close_Request_Name()
     * @uses Procurement_Mass_Close_DataType::setAccounting_Date_Override()
     * @uses Procurement_Mass_Close_DataType::setMemo()
     * @uses Procurement_Mass_Close_DataType::setProcurement_Mass_Close_Line_Data()
     * @param string $procurement_Mass_Close_ID
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @param string $procurement_Mass_Close_Request_Name
     * @param string $accounting_Date_Override
     * @param string $memo
     * @param \StructType\Procurement_Year_End_Request_Line_DataType[] $procurement_Mass_Close_Line_Data
     */
    public function __construct($procurement_Mass_Close_ID = null, \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null, \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null, $procurement_Mass_Close_Request_Name = null, $accounting_Date_Override = null, $memo = null, array $procurement_Mass_Close_Line_Data = array())
    {
        $this
            ->setProcurement_Mass_Close_ID($procurement_Mass_Close_ID)
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setProcurement_Document_Type_Reference($procurement_Document_Type_Reference)
            ->setProcurement_Mass_Close_Request_Name($procurement_Mass_Close_Request_Name)
            ->setAccounting_Date_Override($accounting_Date_Override)
            ->setMemo($memo)
            ->setProcurement_Mass_Close_Line_Data($procurement_Mass_Close_Line_Data);
    }
    /**
     * Get Procurement_Mass_Close_ID value
     * @return string|null
     */
    public function getProcurement_Mass_Close_ID()
    {
        return $this->Procurement_Mass_Close_ID;
    }
    /**
     * Set Procurement_Mass_Close_ID value
     * @param string $procurement_Mass_Close_ID
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setProcurement_Mass_Close_ID($procurement_Mass_Close_ID = null)
    {
        // validation for constraint: string
        if (!is_null($procurement_Mass_Close_ID) && !is_string($procurement_Mass_Close_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procurement_Mass_Close_ID, true), gettype($procurement_Mass_Close_ID)), __LINE__);
        }
        $this->Procurement_Mass_Close_ID = $procurement_Mass_Close_ID;
        return $this;
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null)
    {
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Procurement_Document_Type_Reference value
     * @return \StructType\Procurement_Document_TypeObjectType|null
     */
    public function getProcurement_Document_Type_Reference()
    {
        return $this->Procurement_Document_Type_Reference;
    }
    /**
     * Set Procurement_Document_Type_Reference value
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setProcurement_Document_Type_Reference(\StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null)
    {
        $this->Procurement_Document_Type_Reference = $procurement_Document_Type_Reference;
        return $this;
    }
    /**
     * Get Procurement_Mass_Close_Request_Name value
     * @return string|null
     */
    public function getProcurement_Mass_Close_Request_Name()
    {
        return $this->Procurement_Mass_Close_Request_Name;
    }
    /**
     * Set Procurement_Mass_Close_Request_Name value
     * @param string $procurement_Mass_Close_Request_Name
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setProcurement_Mass_Close_Request_Name($procurement_Mass_Close_Request_Name = null)
    {
        // validation for constraint: string
        if (!is_null($procurement_Mass_Close_Request_Name) && !is_string($procurement_Mass_Close_Request_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procurement_Mass_Close_Request_Name, true), gettype($procurement_Mass_Close_Request_Name)), __LINE__);
        }
        $this->Procurement_Mass_Close_Request_Name = $procurement_Mass_Close_Request_Name;
        return $this;
    }
    /**
     * Get Accounting_Date_Override value
     * @return string|null
     */
    public function getAccounting_Date_Override()
    {
        return $this->Accounting_Date_Override;
    }
    /**
     * Set Accounting_Date_Override value
     * @param string $accounting_Date_Override
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setAccounting_Date_Override($accounting_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date_Override) && !is_string($accounting_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date_Override, true), gettype($accounting_Date_Override)), __LINE__);
        }
        $this->Accounting_Date_Override = $accounting_Date_Override;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Procurement_Mass_Close_Line_Data value
     * @return \StructType\Procurement_Year_End_Request_Line_DataType[]|null
     */
    public function getProcurement_Mass_Close_Line_Data()
    {
        return $this->Procurement_Mass_Close_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Mass_Close_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Mass_Close_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Mass_Close_Line_DataForArrayConstraintsFromSetProcurement_Mass_Close_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem instanceof \StructType\Procurement_Year_End_Request_Line_DataType) {
                $invalidValues[] = is_object($procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem) ? get_class($procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem) : sprintf('%s(%s)', gettype($procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem), var_export($procurement_Mass_Close_DataTypeProcurement_Mass_Close_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Mass_Close_Line_Data property can only contain items of type \StructType\Procurement_Year_End_Request_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Mass_Close_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Year_End_Request_Line_DataType[] $procurement_Mass_Close_Line_Data
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function setProcurement_Mass_Close_Line_Data(array $procurement_Mass_Close_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Mass_Close_Line_DataArrayErrorMessage = self::validateProcurement_Mass_Close_Line_DataForArrayConstraintsFromSetProcurement_Mass_Close_Line_Data($procurement_Mass_Close_Line_Data))) {
            throw new \InvalidArgumentException($procurement_Mass_Close_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Mass_Close_Line_Data = $procurement_Mass_Close_Line_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Mass_Close_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Year_End_Request_Line_DataType $item
     * @return \StructType\Procurement_Mass_Close_DataType
     */
    public function addToProcurement_Mass_Close_Line_Data(\StructType\Procurement_Year_End_Request_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Year_End_Request_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Mass_Close_Line_Data property can only contain items of type \StructType\Procurement_Year_End_Request_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Mass_Close_Line_Data[] = $item;
        return $this;
    }
}
