<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Expense Credit Card Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Expense_Credit_Card_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Corporate_Credit_Card_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Corporate Credit Card Account Reference for a credit card.
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Credit_Card_Account_Reference;
    /**
     * The Cardholder_ID
     * Meta information extracted from the WSDL
     * - documentation: Cardholder ID for the Expense Credit Card
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardholder_ID;
    /**
     * The Last_4_Digits_of_Credit_Card_Number
     * Meta information extracted from the WSDL
     * - documentation: Last 4 Digits of Credit Card Number for the Expense Credit Card | Last four digits of the card number used for Travel Booking. | Expense Credit Card Number Last 4 Digits.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_4_Digits_of_Credit_Card_Number;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Document Status Reference for a credit card.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Credit_Card_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Category for a credit card.
     * - minOccurs: 0
     * @var \StructType\Credit_Card_CategoryObjectType
     */
    public $Credit_Card_Category_Reference;
    /**
     * The Credit_Card_Network_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Network for the Corporate Credit Card Billing Account for a credit card.
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TypeObjectType
     */
    public $Credit_Card_Network_Reference;
    /**
     * The Expense_Credit_Card_Token
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Token for Expense Credit Card
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Credit_Card_Token;
    /**
     * Constructor method for Expense_Credit_Card_Request_CriteriaType
     * @uses Expense_Credit_Card_Request_CriteriaType::setCorporate_Credit_Card_Account_Reference()
     * @uses Expense_Credit_Card_Request_CriteriaType::setCardholder_ID()
     * @uses Expense_Credit_Card_Request_CriteriaType::setLast_4_Digits_of_Credit_Card_Number()
     * @uses Expense_Credit_Card_Request_CriteriaType::setDocument_Status_Reference()
     * @uses Expense_Credit_Card_Request_CriteriaType::setCredit_Card_Category_Reference()
     * @uses Expense_Credit_Card_Request_CriteriaType::setCredit_Card_Network_Reference()
     * @uses Expense_Credit_Card_Request_CriteriaType::setExpense_Credit_Card_Token()
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @param string $cardholder_ID
     * @param string $last_4_Digits_of_Credit_Card_Number
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Network_Reference
     * @param string $expense_Credit_Card_Token
     */
    public function __construct(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null, $cardholder_ID = null, $last_4_Digits_of_Credit_Card_Number = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null, \StructType\Credit_Card_TypeObjectType $credit_Card_Network_Reference = null, $expense_Credit_Card_Token = null)
    {
        $this
            ->setCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference)
            ->setCardholder_ID($cardholder_ID)
            ->setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setCredit_Card_Category_Reference($credit_Card_Category_Reference)
            ->setCredit_Card_Network_Reference($credit_Card_Network_Reference)
            ->setExpense_Credit_Card_Token($expense_Credit_Card_Token);
    }
    /**
     * Get Corporate_Credit_Card_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Credit_Card_Account_Reference()
    {
        return $this->Corporate_Credit_Card_Account_Reference;
    }
    /**
     * Set Corporate_Credit_Card_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setCorporate_Credit_Card_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null)
    {
        $this->Corporate_Credit_Card_Account_Reference = $corporate_Credit_Card_Account_Reference;
        return $this;
    }
    /**
     * Get Cardholder_ID value
     * @return string|null
     */
    public function getCardholder_ID()
    {
        return $this->Cardholder_ID;
    }
    /**
     * Set Cardholder_ID value
     * @param string $cardholder_ID
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setCardholder_ID($cardholder_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cardholder_ID) && !is_string($cardholder_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardholder_ID, true), gettype($cardholder_ID)), __LINE__);
        }
        $this->Cardholder_ID = $cardholder_ID;
        return $this;
    }
    /**
     * Get last_Digits_of_Credit_Card_Number value
     * @return last_Digits_of_Credit_Card_Number
     */
    public function getLast_4_Digits_of_Credit_Card_Number()
    {
        return $this->Last_4_Digits_of_Credit_Card_Number;
    }
    /**
     * Set last_Digits_of_Credit_Card_Number value
     * @param last_Digits_of_Credit_Card_Number $last_Digits_of_Credit_Card_Number
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number = null)
    {
        // validation for constraint: string
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && !is_string($last_4_Digits_of_Credit_Card_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_4_Digits_of_Credit_Card_Number, true), gettype($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && mb_strlen($last_4_Digits_of_Credit_Card_Number) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        $this->Last_4_Digits_of_Credit_Card_Number = $last_4_Digits_of_Credit_Card_Number;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Category_Reference value
     * @return \StructType\Credit_Card_CategoryObjectType|null
     */
    public function getCredit_Card_Category_Reference()
    {
        return $this->Credit_Card_Category_Reference;
    }
    /**
     * Set Credit_Card_Category_Reference value
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setCredit_Card_Category_Reference(\StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null)
    {
        $this->Credit_Card_Category_Reference = $credit_Card_Category_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Network_Reference value
     * @return \StructType\Credit_Card_TypeObjectType|null
     */
    public function getCredit_Card_Network_Reference()
    {
        return $this->Credit_Card_Network_Reference;
    }
    /**
     * Set Credit_Card_Network_Reference value
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Network_Reference
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setCredit_Card_Network_Reference(\StructType\Credit_Card_TypeObjectType $credit_Card_Network_Reference = null)
    {
        $this->Credit_Card_Network_Reference = $credit_Card_Network_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Token value
     * @return string|null
     */
    public function getExpense_Credit_Card_Token()
    {
        return $this->Expense_Credit_Card_Token;
    }
    /**
     * Set Expense_Credit_Card_Token value
     * @param string $expense_Credit_Card_Token
     * @return \StructType\Expense_Credit_Card_Request_CriteriaType
     */
    public function setExpense_Credit_Card_Token($expense_Credit_Card_Token = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Credit_Card_Token) && !is_string($expense_Credit_Card_Token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Credit_Card_Token, true), gettype($expense_Credit_Card_Token)), __LINE__);
        }
        $this->Expense_Credit_Card_Token = $expense_Credit_Card_Token;
        return $this;
    }
}
