<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Requisition_Sourcing_Rule_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost element to create new or update existing requisition sourcing rules
 * @subpackage Structs
 */
class Put_Requisition_Sourcing_Rule_RequestType extends AbstractStructBase
{
    /**
     * The Requisition_Sourcing_Rule_Data
     * @var \StructType\Requisition_Sourcing_Rule_DataType
     */
    public $Requisition_Sourcing_Rule_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only. True if only new Requisition Sourcing Rules are allowed to be entered in the request.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Requisition_Sourcing_Rule_RequestType
     * @uses Put_Requisition_Sourcing_Rule_RequestType::setRequisition_Sourcing_Rule_Data()
     * @uses Put_Requisition_Sourcing_Rule_RequestType::setAdd_Only()
     * @uses Put_Requisition_Sourcing_Rule_RequestType::setVersion()
     * @param \StructType\Requisition_Sourcing_Rule_DataType $requisition_Sourcing_Rule_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Requisition_Sourcing_Rule_DataType $requisition_Sourcing_Rule_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRequisition_Sourcing_Rule_Data($requisition_Sourcing_Rule_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Requisition_Sourcing_Rule_Data value
     * @return \StructType\Requisition_Sourcing_Rule_DataType|null
     */
    public function getRequisition_Sourcing_Rule_Data()
    {
        return $this->Requisition_Sourcing_Rule_Data;
    }
    /**
     * Set Requisition_Sourcing_Rule_Data value
     * @param \StructType\Requisition_Sourcing_Rule_DataType $requisition_Sourcing_Rule_Data
     * @return \StructType\Put_Requisition_Sourcing_Rule_RequestType
     */
    public function setRequisition_Sourcing_Rule_Data(\StructType\Requisition_Sourcing_Rule_DataType $requisition_Sourcing_Rule_Data = null)
    {
        $this->Requisition_Sourcing_Rule_Data = $requisition_Sourcing_Rule_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Requisition_Sourcing_Rule_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Requisition_Sourcing_Rule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
