<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Task_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Task Name Data element must contain either a Task Name ID or Name. | Element containing task name data.
 * @subpackage Structs
 */
class Project_Task_Name_DataType extends AbstractStructBase
{
    /**
     * The Task_Name_ID
     * Meta information extracted from the WSDL
     * - documentation: Task Name ID. This is the task name unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Task_Name_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: This is the unique name of the task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Project_Task_Name_DataType
     * @uses Project_Task_Name_DataType::setTask_Name_ID()
     * @uses Project_Task_Name_DataType::setName()
     * @param string $task_Name_ID
     * @param string $name
     */
    public function __construct($task_Name_ID = null, $name = null)
    {
        $this
            ->setTask_Name_ID($task_Name_ID)
            ->setName($name);
    }
    /**
     * Get Task_Name_ID value
     * @return string|null
     */
    public function getTask_Name_ID()
    {
        return $this->Task_Name_ID;
    }
    /**
     * Set Task_Name_ID value
     * @param string $task_Name_ID
     * @return \StructType\Project_Task_Name_DataType
     */
    public function setTask_Name_ID($task_Name_ID = null)
    {
        // validation for constraint: string
        if (!is_null($task_Name_ID) && !is_string($task_Name_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($task_Name_ID, true), gettype($task_Name_ID)), __LINE__);
        }
        $this->Task_Name_ID = $task_Name_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Project_Task_Name_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
