<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for External_Transaction_SourceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that includes External Transaction Source Instance and Data
 * @subpackage Structs
 */
class External_Transaction_SourceType extends AbstractStructBase
{
    /**
     * The External_Transaction_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Transaction Source Reference
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_Transaction_Source_Reference;
    /**
     * The External_Transaction_Source_Data
     * Meta information extracted from the WSDL
     * - documentation: External Transaction Source Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source_DataType[]
     */
    public $External_Transaction_Source_Data;
    /**
     * Constructor method for External_Transaction_SourceType
     * @uses External_Transaction_SourceType::setExternal_Transaction_Source_Reference()
     * @uses External_Transaction_SourceType::setExternal_Transaction_Source_Data()
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Transaction_Source_Reference
     * @param \StructType\External_Transaction_Source_DataType[] $external_Transaction_Source_Data
     */
    public function __construct(\StructType\External_Transaction_Source__All_ObjectType $external_Transaction_Source_Reference = null, array $external_Transaction_Source_Data = array())
    {
        $this
            ->setExternal_Transaction_Source_Reference($external_Transaction_Source_Reference)
            ->setExternal_Transaction_Source_Data($external_Transaction_Source_Data);
    }
    /**
     * Get External_Transaction_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_Transaction_Source_Reference()
    {
        return $this->External_Transaction_Source_Reference;
    }
    /**
     * Set External_Transaction_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Transaction_Source_Reference
     * @return \StructType\External_Transaction_SourceType
     */
    public function setExternal_Transaction_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_Transaction_Source_Reference = null)
    {
        $this->External_Transaction_Source_Reference = $external_Transaction_Source_Reference;
        return $this;
    }
    /**
     * Get External_Transaction_Source_Data value
     * @return \StructType\External_Transaction_Source_DataType[]|null
     */
    public function getExternal_Transaction_Source_Data()
    {
        return $this->External_Transaction_Source_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Transaction_Source_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Transaction_Source_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Transaction_Source_DataForArrayConstraintsFromSetExternal_Transaction_Source_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $external_Transaction_SourceTypeExternal_Transaction_Source_DataItem) {
            // validation for constraint: itemType
            if (!$external_Transaction_SourceTypeExternal_Transaction_Source_DataItem instanceof \StructType\External_Transaction_Source_DataType) {
                $invalidValues[] = is_object($external_Transaction_SourceTypeExternal_Transaction_Source_DataItem) ? get_class($external_Transaction_SourceTypeExternal_Transaction_Source_DataItem) : sprintf('%s(%s)', gettype($external_Transaction_SourceTypeExternal_Transaction_Source_DataItem), var_export($external_Transaction_SourceTypeExternal_Transaction_Source_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Transaction_Source_Data property can only contain items of type \StructType\External_Transaction_Source_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Transaction_Source_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source_DataType[] $external_Transaction_Source_Data
     * @return \StructType\External_Transaction_SourceType
     */
    public function setExternal_Transaction_Source_Data(array $external_Transaction_Source_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Transaction_Source_DataArrayErrorMessage = self::validateExternal_Transaction_Source_DataForArrayConstraintsFromSetExternal_Transaction_Source_Data($external_Transaction_Source_Data))) {
            throw new \InvalidArgumentException($external_Transaction_Source_DataArrayErrorMessage, __LINE__);
        }
        $this->External_Transaction_Source_Data = $external_Transaction_Source_Data;
        return $this;
    }
    /**
     * Add item to External_Transaction_Source_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source_DataType $item
     * @return \StructType\External_Transaction_SourceType
     */
    public function addToExternal_Transaction_Source_Data(\StructType\External_Transaction_Source_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source_DataType) {
            throw new \InvalidArgumentException(sprintf('The External_Transaction_Source_Data property can only contain items of type \StructType\External_Transaction_Source_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Transaction_Source_Data[] = $item;
        return $this;
    }
}
