<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Expense Credit Card data.
 * @subpackage Structs
 */
class Credit_Card__HV__DataType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Credit Card for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Expense_Credit_Card_Reference;
    /**
     * The Expense_Credit_Card_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card ID. This is the Expense Credit Card unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Credit_Card_ID;
    /**
     * The Corporate_Credit_Card_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Corporate Credit Card Account Reference for the Expense Credit Card.
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Credit_Card_Account_Reference;
    /**
     * The Credit_Card_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Central Travel Card boolean for Worker Credit Card
     * - minOccurs: 0
     * @var \StructType\Credit_Card_CategoryObjectType
     */
    public $Credit_Card_Category_Reference;
    /**
     * The Cardholder_Reference
     * Meta information extracted from the WSDL
     * - documentation: Cardholder Reference for the Expense Credit Card.
     * - choice: Cardholder_Reference | Cardholder_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Cardholder_Reference;
    /**
     * The Cardholder_ID
     * Meta information extracted from the WSDL
     * - documentation: Cardholder ID for the Expense Credit Card. This will only be used by the Integrations Web Service for a standard card holder listing file where the reference to an Cardholder (Expense Payee) in Workday is not available.
     * - choice: Cardholder_Reference | Cardholder_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardholder_ID;
    /**
     * The Credit_Card_Organizations_Reference
     * Meta information extracted from the WSDL
     * - documentation: Organizations for Central Travel Card
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Credit_Card_Organizations_Reference;
    /**
     * The Credit_Card_Description
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Description;
    /**
     * The Last_4_Digits_of_Credit_Card_Number
     * Meta information extracted from the WSDL
     * - documentation: Last 4 Digits of Credit Card Number for the Expense Credit Card | Last four digits of the card number used for Travel Booking. | Expense Credit Card Number Last 4 Digits.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_4_Digits_of_Credit_Card_Number;
    /**
     * The Credit_Card_Expiration_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Expiration Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Expiration_Date;
    /**
     * The Monthly_Limit
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Monthly Limit.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Monthly_Limit;
    /**
     * The Transaction_Limit
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction Limit.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Transaction_Limit;
    /**
     * The Billing_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Billing Currency Reference for Expense Credit Card.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Billing_Currency_Reference;
    /**
     * The Cash_Access_Allowed
     * Meta information extracted from the WSDL
     * - documentation: Cash Access Allowed boolean for Expense Credit Card.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Cash_Access_Allowed;
    /**
     * The Cancel_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Cancel Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cancel_Date;
    /**
     * The Cardmember_Embossed_Name
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Cardmember Embossed Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardmember_Embossed_Name;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Document Status Reference for Expense Credit Card. The statuses are Error (this can occur if the standard card holder listing file does not provide all needed data), Active, Canceled, Deleted, and Suspended.
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Expense_Credit_Card_Token
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Token will only be set by the Integrations Web Service for PCI. This Token will be a unique identifier for each Expense Credit Card. It will be used to represent the Expense Credit Card Numbers. It will get
     * generated by Integrations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Credit_Card_Token;
    /**
     * The Alternate_Account_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Configure this field if you use remittance files. Provide the alternate account identifier from your financial institution's incoming credit card file. Workday uses this value in the Get Payments web service response, ensuring that
     * it's included in the remittance file that you send to your financial institution.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alternate_Account_Identifier;
    /**
     * The Reassignment_Enabled
     * Meta information extracted from the WSDL
     * - documentation: Manual Reassignment Allowed boolean for Expense Credit Card
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Reassignment_Enabled;
    /**
     * Constructor method for Credit_Card__HV__DataType
     * @uses Credit_Card__HV__DataType::setExpense_Credit_Card_Reference()
     * @uses Credit_Card__HV__DataType::setExpense_Credit_Card_ID()
     * @uses Credit_Card__HV__DataType::setCorporate_Credit_Card_Account_Reference()
     * @uses Credit_Card__HV__DataType::setCredit_Card_Category_Reference()
     * @uses Credit_Card__HV__DataType::setCardholder_Reference()
     * @uses Credit_Card__HV__DataType::setCardholder_ID()
     * @uses Credit_Card__HV__DataType::setCredit_Card_Organizations_Reference()
     * @uses Credit_Card__HV__DataType::setCredit_Card_Description()
     * @uses Credit_Card__HV__DataType::setLast_4_Digits_of_Credit_Card_Number()
     * @uses Credit_Card__HV__DataType::setCredit_Card_Expiration_Date()
     * @uses Credit_Card__HV__DataType::setMonthly_Limit()
     * @uses Credit_Card__HV__DataType::setTransaction_Limit()
     * @uses Credit_Card__HV__DataType::setBilling_Currency_Reference()
     * @uses Credit_Card__HV__DataType::setCash_Access_Allowed()
     * @uses Credit_Card__HV__DataType::setCancel_Date()
     * @uses Credit_Card__HV__DataType::setCardmember_Embossed_Name()
     * @uses Credit_Card__HV__DataType::setDocument_Status_Reference()
     * @uses Credit_Card__HV__DataType::setExpense_Credit_Card_Token()
     * @uses Credit_Card__HV__DataType::setAlternate_Account_Identifier()
     * @uses Credit_Card__HV__DataType::setReassignment_Enabled()
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @param string $expense_Credit_Card_ID
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @param \StructType\Expense_PayeeObjectType $cardholder_Reference
     * @param string $cardholder_ID
     * @param \StructType\OrganizationObjectType[] $credit_Card_Organizations_Reference
     * @param string $credit_Card_Description
     * @param string $last_4_Digits_of_Credit_Card_Number
     * @param string $credit_Card_Expiration_Date
     * @param float $monthly_Limit
     * @param float $transaction_Limit
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     * @param bool $cash_Access_Allowed
     * @param string $cancel_Date
     * @param string $cardmember_Embossed_Name
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param string $expense_Credit_Card_Token
     * @param string $alternate_Account_Identifier
     * @param bool $reassignment_Enabled
     */
    public function __construct(\StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null, $expense_Credit_Card_ID = null, \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null, \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null, \StructType\Expense_PayeeObjectType $cardholder_Reference = null, $cardholder_ID = null, array $credit_Card_Organizations_Reference = array(), $credit_Card_Description = null, $last_4_Digits_of_Credit_Card_Number = null, $credit_Card_Expiration_Date = null, $monthly_Limit = null, $transaction_Limit = null, \StructType\CurrencyObjectType $billing_Currency_Reference = null, $cash_Access_Allowed = null, $cancel_Date = null, $cardmember_Embossed_Name = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, $expense_Credit_Card_Token = null, $alternate_Account_Identifier = null, $reassignment_Enabled = null)
    {
        $this
            ->setExpense_Credit_Card_Reference($expense_Credit_Card_Reference)
            ->setExpense_Credit_Card_ID($expense_Credit_Card_ID)
            ->setCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference)
            ->setCredit_Card_Category_Reference($credit_Card_Category_Reference)
            ->setCardholder_Reference($cardholder_Reference)
            ->setCardholder_ID($cardholder_ID)
            ->setCredit_Card_Organizations_Reference($credit_Card_Organizations_Reference)
            ->setCredit_Card_Description($credit_Card_Description)
            ->setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number)
            ->setCredit_Card_Expiration_Date($credit_Card_Expiration_Date)
            ->setMonthly_Limit($monthly_Limit)
            ->setTransaction_Limit($transaction_Limit)
            ->setBilling_Currency_Reference($billing_Currency_Reference)
            ->setCash_Access_Allowed($cash_Access_Allowed)
            ->setCancel_Date($cancel_Date)
            ->setCardmember_Embossed_Name($cardmember_Embossed_Name)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setExpense_Credit_Card_Token($expense_Credit_Card_Token)
            ->setAlternate_Account_Identifier($alternate_Account_Identifier)
            ->setReassignment_Enabled($reassignment_Enabled);
    }
    /**
     * Get Expense_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getExpense_Credit_Card_Reference()
    {
        return $this->Expense_Credit_Card_Reference;
    }
    /**
     * Set Expense_Credit_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setExpense_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null)
    {
        $this->Expense_Credit_Card_Reference = $expense_Credit_Card_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_ID value
     * @return string|null
     */
    public function getExpense_Credit_Card_ID()
    {
        return $this->Expense_Credit_Card_ID;
    }
    /**
     * Set Expense_Credit_Card_ID value
     * @param string $expense_Credit_Card_ID
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setExpense_Credit_Card_ID($expense_Credit_Card_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Credit_Card_ID) && !is_string($expense_Credit_Card_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Credit_Card_ID, true), gettype($expense_Credit_Card_ID)), __LINE__);
        }
        $this->Expense_Credit_Card_ID = $expense_Credit_Card_ID;
        return $this;
    }
    /**
     * Get Corporate_Credit_Card_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Credit_Card_Account_Reference()
    {
        return $this->Corporate_Credit_Card_Account_Reference;
    }
    /**
     * Set Corporate_Credit_Card_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCorporate_Credit_Card_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null)
    {
        $this->Corporate_Credit_Card_Account_Reference = $corporate_Credit_Card_Account_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Category_Reference value
     * @return \StructType\Credit_Card_CategoryObjectType|null
     */
    public function getCredit_Card_Category_Reference()
    {
        return $this->Credit_Card_Category_Reference;
    }
    /**
     * Set Credit_Card_Category_Reference value
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCredit_Card_Category_Reference(\StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null)
    {
        $this->Credit_Card_Category_Reference = $credit_Card_Category_Reference;
        return $this;
    }
    /**
     * Get Cardholder_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getCardholder_Reference()
    {
        return isset($this->Cardholder_Reference) ? $this->Cardholder_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardholder_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardholder_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardholder_ReferenceForChoiceConstraintsFromSetCardholder_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Cardholder_ID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Cardholder_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Cardholder_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Cardholder_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $cardholder_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCardholder_Reference(\StructType\Expense_PayeeObjectType $cardholder_Reference = null)
    {
        // validation for constraint: choice(Cardholder_Reference, Cardholder_ID)
        if ('' !== ($cardholder_ReferenceChoiceErrorMessage = self::validateCardholder_ReferenceForChoiceConstraintsFromSetCardholder_Reference($cardholder_Reference))) {
            throw new \InvalidArgumentException($cardholder_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardholder_Reference) || (is_array($cardholder_Reference) && empty($cardholder_Reference))) {
            unset($this->Cardholder_Reference);
        } else {
            $this->Cardholder_Reference = $cardholder_Reference;
        }
        return $this;
    }
    /**
     * Get Cardholder_ID value
     * @return string|null
     */
    public function getCardholder_ID()
    {
        return isset($this->Cardholder_ID) ? $this->Cardholder_ID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardholder_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardholder_ID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardholder_IDForChoiceConstraintsFromSetCardholder_ID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Cardholder_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Cardholder_ID can\'t be set as the property %s is already set. Only one property must be set among these properties: Cardholder_ID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Cardholder_ID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $cardholder_ID
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCardholder_ID($cardholder_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cardholder_ID) && !is_string($cardholder_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardholder_ID, true), gettype($cardholder_ID)), __LINE__);
        }
        // validation for constraint: choice(Cardholder_Reference, Cardholder_ID)
        if ('' !== ($cardholder_IDChoiceErrorMessage = self::validateCardholder_IDForChoiceConstraintsFromSetCardholder_ID($cardholder_ID))) {
            throw new \InvalidArgumentException($cardholder_IDChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardholder_ID) || (is_array($cardholder_ID) && empty($cardholder_ID))) {
            unset($this->Cardholder_ID);
        } else {
            $this->Cardholder_ID = $cardholder_ID;
        }
        return $this;
    }
    /**
     * Get Credit_Card_Organizations_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCredit_Card_Organizations_Reference()
    {
        return $this->Credit_Card_Organizations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit_Card_Organizations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit_Card_Organizations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCredit_Card_Organizations_ReferenceForArrayConstraintsFromSetCredit_Card_Organizations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem) ? get_class($credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem) : sprintf('%s(%s)', gettype($credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem), var_export($credit_Card_HV_DataTypeCredit_Card_Organizations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Credit_Card_Organizations_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Credit_Card_Organizations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $credit_Card_Organizations_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCredit_Card_Organizations_Reference(array $credit_Card_Organizations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($credit_Card_Organizations_ReferenceArrayErrorMessage = self::validateCredit_Card_Organizations_ReferenceForArrayConstraintsFromSetCredit_Card_Organizations_Reference($credit_Card_Organizations_Reference))) {
            throw new \InvalidArgumentException($credit_Card_Organizations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Credit_Card_Organizations_Reference = $credit_Card_Organizations_Reference;
        return $this;
    }
    /**
     * Add item to Credit_Card_Organizations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function addToCredit_Card_Organizations_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Credit_Card_Organizations_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Credit_Card_Organizations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Credit_Card_Description value
     * @return string|null
     */
    public function getCredit_Card_Description()
    {
        return $this->Credit_Card_Description;
    }
    /**
     * Set Credit_Card_Description value
     * @param string $credit_Card_Description
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCredit_Card_Description($credit_Card_Description = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Description) && !is_string($credit_Card_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Description, true), gettype($credit_Card_Description)), __LINE__);
        }
        $this->Credit_Card_Description = $credit_Card_Description;
        return $this;
    }
    /**
     * Get last_Digits_of_Credit_Card_Number value
     * @return last_Digits_of_Credit_Card_Number
     */
    public function getLast_4_Digits_of_Credit_Card_Number()
    {
        return $this->Last_4_Digits_of_Credit_Card_Number;
    }
    /**
     * Set last_Digits_of_Credit_Card_Number value
     * @param last_Digits_of_Credit_Card_Number $last_Digits_of_Credit_Card_Number
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number = null)
    {
        // validation for constraint: string
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && !is_string($last_4_Digits_of_Credit_Card_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_4_Digits_of_Credit_Card_Number, true), gettype($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && mb_strlen($last_4_Digits_of_Credit_Card_Number) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        $this->Last_4_Digits_of_Credit_Card_Number = $last_4_Digits_of_Credit_Card_Number;
        return $this;
    }
    /**
     * Get Credit_Card_Expiration_Date value
     * @return string|null
     */
    public function getCredit_Card_Expiration_Date()
    {
        return $this->Credit_Card_Expiration_Date;
    }
    /**
     * Set Credit_Card_Expiration_Date value
     * @param string $credit_Card_Expiration_Date
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCredit_Card_Expiration_Date($credit_Card_Expiration_Date = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Expiration_Date) && !is_string($credit_Card_Expiration_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Expiration_Date, true), gettype($credit_Card_Expiration_Date)), __LINE__);
        }
        $this->Credit_Card_Expiration_Date = $credit_Card_Expiration_Date;
        return $this;
    }
    /**
     * Get Monthly_Limit value
     * @return float|null
     */
    public function getMonthly_Limit()
    {
        return $this->Monthly_Limit;
    }
    /**
     * Set Monthly_Limit value
     * @param float $monthly_Limit
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setMonthly_Limit($monthly_Limit = null)
    {
        // validation for constraint: float
        if (!is_null($monthly_Limit) && !(is_float($monthly_Limit) || is_numeric($monthly_Limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monthly_Limit, true), gettype($monthly_Limit)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($monthly_Limit) && mb_strlen(mb_substr($monthly_Limit, false !== mb_strpos($monthly_Limit, '.') ? mb_strpos($monthly_Limit, '.') + 1 : mb_strlen($monthly_Limit))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($monthly_Limit, true), mb_strlen(mb_substr($monthly_Limit, mb_strpos($monthly_Limit, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($monthly_Limit) && $monthly_Limit < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($monthly_Limit, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($monthly_Limit) && mb_strlen(preg_replace('/(\D)/', '', $monthly_Limit)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($monthly_Limit, true), mb_strlen(preg_replace('/(\D)/', '', $monthly_Limit))), __LINE__);
        }
        $this->Monthly_Limit = $monthly_Limit;
        return $this;
    }
    /**
     * Get Transaction_Limit value
     * @return float|null
     */
    public function getTransaction_Limit()
    {
        return $this->Transaction_Limit;
    }
    /**
     * Set Transaction_Limit value
     * @param float $transaction_Limit
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setTransaction_Limit($transaction_Limit = null)
    {
        // validation for constraint: float
        if (!is_null($transaction_Limit) && !(is_float($transaction_Limit) || is_numeric($transaction_Limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transaction_Limit, true), gettype($transaction_Limit)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($transaction_Limit) && mb_strlen(mb_substr($transaction_Limit, false !== mb_strpos($transaction_Limit, '.') ? mb_strpos($transaction_Limit, '.') + 1 : mb_strlen($transaction_Limit))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($transaction_Limit, true), mb_strlen(mb_substr($transaction_Limit, mb_strpos($transaction_Limit, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($transaction_Limit) && $transaction_Limit < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($transaction_Limit, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($transaction_Limit) && mb_strlen(preg_replace('/(\D)/', '', $transaction_Limit)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($transaction_Limit, true), mb_strlen(preg_replace('/(\D)/', '', $transaction_Limit))), __LINE__);
        }
        $this->Transaction_Limit = $transaction_Limit;
        return $this;
    }
    /**
     * Get Billing_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getBilling_Currency_Reference()
    {
        return $this->Billing_Currency_Reference;
    }
    /**
     * Set Billing_Currency_Reference value
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setBilling_Currency_Reference(\StructType\CurrencyObjectType $billing_Currency_Reference = null)
    {
        $this->Billing_Currency_Reference = $billing_Currency_Reference;
        return $this;
    }
    /**
     * Get Cash_Access_Allowed value
     * @return bool|null
     */
    public function getCash_Access_Allowed()
    {
        return $this->Cash_Access_Allowed;
    }
    /**
     * Set Cash_Access_Allowed value
     * @param bool $cash_Access_Allowed
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCash_Access_Allowed($cash_Access_Allowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($cash_Access_Allowed) && !is_bool($cash_Access_Allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cash_Access_Allowed, true), gettype($cash_Access_Allowed)), __LINE__);
        }
        $this->Cash_Access_Allowed = $cash_Access_Allowed;
        return $this;
    }
    /**
     * Get Cancel_Date value
     * @return string|null
     */
    public function getCancel_Date()
    {
        return $this->Cancel_Date;
    }
    /**
     * Set Cancel_Date value
     * @param string $cancel_Date
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCancel_Date($cancel_Date = null)
    {
        // validation for constraint: string
        if (!is_null($cancel_Date) && !is_string($cancel_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancel_Date, true), gettype($cancel_Date)), __LINE__);
        }
        $this->Cancel_Date = $cancel_Date;
        return $this;
    }
    /**
     * Get Cardmember_Embossed_Name value
     * @return string|null
     */
    public function getCardmember_Embossed_Name()
    {
        return $this->Cardmember_Embossed_Name;
    }
    /**
     * Set Cardmember_Embossed_Name value
     * @param string $cardmember_Embossed_Name
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setCardmember_Embossed_Name($cardmember_Embossed_Name = null)
    {
        // validation for constraint: string
        if (!is_null($cardmember_Embossed_Name) && !is_string($cardmember_Embossed_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardmember_Embossed_Name, true), gettype($cardmember_Embossed_Name)), __LINE__);
        }
        $this->Cardmember_Embossed_Name = $cardmember_Embossed_Name;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Token value
     * @return string|null
     */
    public function getExpense_Credit_Card_Token()
    {
        return $this->Expense_Credit_Card_Token;
    }
    /**
     * Set Expense_Credit_Card_Token value
     * @param string $expense_Credit_Card_Token
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setExpense_Credit_Card_Token($expense_Credit_Card_Token = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Credit_Card_Token) && !is_string($expense_Credit_Card_Token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Credit_Card_Token, true), gettype($expense_Credit_Card_Token)), __LINE__);
        }
        $this->Expense_Credit_Card_Token = $expense_Credit_Card_Token;
        return $this;
    }
    /**
     * Get Alternate_Account_Identifier value
     * @return string|null
     */
    public function getAlternate_Account_Identifier()
    {
        return $this->Alternate_Account_Identifier;
    }
    /**
     * Set Alternate_Account_Identifier value
     * @param string $alternate_Account_Identifier
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setAlternate_Account_Identifier($alternate_Account_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Account_Identifier) && !is_string($alternate_Account_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Account_Identifier, true), gettype($alternate_Account_Identifier)), __LINE__);
        }
        $this->Alternate_Account_Identifier = $alternate_Account_Identifier;
        return $this;
    }
    /**
     * Get Reassignment_Enabled value
     * @return bool|null
     */
    public function getReassignment_Enabled()
    {
        return $this->Reassignment_Enabled;
    }
    /**
     * Set Reassignment_Enabled value
     * @param bool $reassignment_Enabled
     * @return \StructType\Credit_Card__HV__DataType
     */
    public function setReassignment_Enabled($reassignment_Enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($reassignment_Enabled) && !is_bool($reassignment_Enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reassignment_Enabled, true), gettype($reassignment_Enabled)), __LINE__);
        }
        $this->Reassignment_Enabled = $reassignment_Enabled;
        return $this;
    }
}
