<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_File__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Credit Card Transaction File data
 * @subpackage Structs
 */
class Credit_Card_Transaction_File__HV__DataType extends AbstractStructBase
{
    /**
     * The File_Number
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction File Number. This is the Expense Credit Card Transaction File unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Number;
    /**
     * The File_Name
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction File Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Name;
    /**
     * The Report_Create_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction File Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Report_Create_Date;
    /**
     * The Credit_Card_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Type Reference for Expense Credit Card Transaction File
     * @var \StructType\Credit_Card_TypeObjectType
     */
    public $Credit_Card_Type_Reference;
    /**
     * The Report_Version_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction File Report Version Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Report_Version_Date;
    /**
     * The Report_Version
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction File Report Version
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Report_Version;
    /**
     * The Expense_Credit_Card_Transaction_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction__HV__DataType[]
     */
    public $Expense_Credit_Card_Transaction_Data;
    /**
     * Constructor method for Credit_Card_Transaction_File__HV__DataType
     * @uses Credit_Card_Transaction_File__HV__DataType::setFile_Number()
     * @uses Credit_Card_Transaction_File__HV__DataType::setFile_Name()
     * @uses Credit_Card_Transaction_File__HV__DataType::setReport_Create_Date()
     * @uses Credit_Card_Transaction_File__HV__DataType::setCredit_Card_Type_Reference()
     * @uses Credit_Card_Transaction_File__HV__DataType::setReport_Version_Date()
     * @uses Credit_Card_Transaction_File__HV__DataType::setReport_Version()
     * @uses Credit_Card_Transaction_File__HV__DataType::setExpense_Credit_Card_Transaction_Data()
     * @param string $file_Number
     * @param string $file_Name
     * @param string $report_Create_Date
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference
     * @param string $report_Version_Date
     * @param string $report_Version
     * @param \StructType\Credit_Card_Transaction__HV__DataType[] $expense_Credit_Card_Transaction_Data
     */
    public function __construct($file_Number = null, $file_Name = null, $report_Create_Date = null, \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference = null, $report_Version_Date = null, $report_Version = null, array $expense_Credit_Card_Transaction_Data = array())
    {
        $this
            ->setFile_Number($file_Number)
            ->setFile_Name($file_Name)
            ->setReport_Create_Date($report_Create_Date)
            ->setCredit_Card_Type_Reference($credit_Card_Type_Reference)
            ->setReport_Version_Date($report_Version_Date)
            ->setReport_Version($report_Version)
            ->setExpense_Credit_Card_Transaction_Data($expense_Credit_Card_Transaction_Data);
    }
    /**
     * Get File_Number value
     * @return string|null
     */
    public function getFile_Number()
    {
        return $this->File_Number;
    }
    /**
     * Set File_Number value
     * @param string $file_Number
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setFile_Number($file_Number = null)
    {
        // validation for constraint: string
        if (!is_null($file_Number) && !is_string($file_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Number, true), gettype($file_Number)), __LINE__);
        }
        $this->File_Number = $file_Number;
        return $this;
    }
    /**
     * Get File_Name value
     * @return string|null
     */
    public function getFile_Name()
    {
        return $this->File_Name;
    }
    /**
     * Set File_Name value
     * @param string $file_Name
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setFile_Name($file_Name = null)
    {
        // validation for constraint: string
        if (!is_null($file_Name) && !is_string($file_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Name, true), gettype($file_Name)), __LINE__);
        }
        $this->File_Name = $file_Name;
        return $this;
    }
    /**
     * Get Report_Create_Date value
     * @return string|null
     */
    public function getReport_Create_Date()
    {
        return $this->Report_Create_Date;
    }
    /**
     * Set Report_Create_Date value
     * @param string $report_Create_Date
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setReport_Create_Date($report_Create_Date = null)
    {
        // validation for constraint: string
        if (!is_null($report_Create_Date) && !is_string($report_Create_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($report_Create_Date, true), gettype($report_Create_Date)), __LINE__);
        }
        $this->Report_Create_Date = $report_Create_Date;
        return $this;
    }
    /**
     * Get Credit_Card_Type_Reference value
     * @return \StructType\Credit_Card_TypeObjectType|null
     */
    public function getCredit_Card_Type_Reference()
    {
        return $this->Credit_Card_Type_Reference;
    }
    /**
     * Set Credit_Card_Type_Reference value
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setCredit_Card_Type_Reference(\StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference = null)
    {
        $this->Credit_Card_Type_Reference = $credit_Card_Type_Reference;
        return $this;
    }
    /**
     * Get Report_Version_Date value
     * @return string|null
     */
    public function getReport_Version_Date()
    {
        return $this->Report_Version_Date;
    }
    /**
     * Set Report_Version_Date value
     * @param string $report_Version_Date
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setReport_Version_Date($report_Version_Date = null)
    {
        // validation for constraint: string
        if (!is_null($report_Version_Date) && !is_string($report_Version_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($report_Version_Date, true), gettype($report_Version_Date)), __LINE__);
        }
        $this->Report_Version_Date = $report_Version_Date;
        return $this;
    }
    /**
     * Get Report_Version value
     * @return string|null
     */
    public function getReport_Version()
    {
        return $this->Report_Version;
    }
    /**
     * Set Report_Version value
     * @param string $report_Version
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setReport_Version($report_Version = null)
    {
        // validation for constraint: string
        if (!is_null($report_Version) && !is_string($report_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($report_Version, true), gettype($report_Version)), __LINE__);
        }
        $this->Report_Version = $report_Version;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_Data value
     * @return \StructType\Credit_Card_Transaction__HV__DataType[]|null
     */
    public function getExpense_Credit_Card_Transaction_Data()
    {
        return $this->Expense_Credit_Card_Transaction_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card_Transaction_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Transaction_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_Card_Transaction_DataForArrayConstraintsFromSetExpense_Credit_Card_Transaction_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem instanceof \StructType\Credit_Card_Transaction__HV__DataType) {
                $invalidValues[] = is_object($credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem) ? get_class($credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem), var_export($credit_Card_Transaction_File_HV_DataTypeExpense_Credit_Card_Transaction_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card_Transaction_Data property can only contain items of type \StructType\Credit_Card_Transaction__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction__HV__DataType[] $expense_Credit_Card_Transaction_Data
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function setExpense_Credit_Card_Transaction_Data(array $expense_Credit_Card_Transaction_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_Card_Transaction_DataArrayErrorMessage = self::validateExpense_Credit_Card_Transaction_DataForArrayConstraintsFromSetExpense_Credit_Card_Transaction_Data($expense_Credit_Card_Transaction_Data))) {
            throw new \InvalidArgumentException($expense_Credit_Card_Transaction_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_Data = $expense_Credit_Card_Transaction_Data;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card_Transaction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction__HV__DataType $item
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public function addToExpense_Credit_Card_Transaction_Data(\StructType\Credit_Card_Transaction__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Transaction__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card_Transaction_Data property can only contain items of type \StructType\Credit_Card_Transaction__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_Data[] = $item;
        return $this;
    }
}
