<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Car_Rental_Agency_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Car Rental Agency Object
 * @subpackage Structs
 */
class Car_Rental_Agency_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Car Rental Agency Object
     * - maxOccurs: unbounded
     * @var \StructType\Car_Rental_AgencyObjectType[]
     */
    public $Car_Rental_Agency_Reference;
    /**
     * Constructor method for Car_Rental_Agency_Request_ReferencesType
     * @uses Car_Rental_Agency_Request_ReferencesType::setCar_Rental_Agency_Reference()
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     */
    public function __construct(array $car_Rental_Agency_Reference = array())
    {
        $this
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference);
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType[]|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCar_Rental_Agency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar_Rental_Agency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem instanceof \StructType\Car_Rental_AgencyObjectType) {
                $invalidValues[] = is_object($car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem) ? get_class($car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem) : sprintf('%s(%s)', gettype($car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem), var_export($car_Rental_Agency_Request_ReferencesTypeCar_Rental_Agency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @return \StructType\Car_Rental_Agency_Request_ReferencesType
     */
    public function setCar_Rental_Agency_Reference(array $car_Rental_Agency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($car_Rental_Agency_ReferenceArrayErrorMessage = self::validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference($car_Rental_Agency_Reference))) {
            throw new \InvalidArgumentException($car_Rental_Agency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Add item to Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType $item
     * @return \StructType\Car_Rental_Agency_Request_ReferencesType
     */
    public function addToCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car_Rental_AgencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car_Rental_Agency_Reference[] = $item;
        return $this;
    }
}
