<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_Sheet_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the reference that identifies the transfer pricing rate sheet to retrieve. Specify either the WID or the Transfer_Pricing_Rate_Sheet_ID.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_Sheet_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Transfer_Pricing_Rate_Sheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains transfer pricing rate sheet instances.
     * - maxOccurs: unbounded
     * @var \StructType\Transfer_Pricing_Rate_SheetObjectType[]
     */
    public $Transfer_Pricing_Rate_Sheet_Reference;
    /**
     * Constructor method for Transfer_Pricing_Rate_Sheet_Request_ReferencesType
     * @uses Transfer_Pricing_Rate_Sheet_Request_ReferencesType::setTransfer_Pricing_Rate_Sheet_Reference()
     * @param \StructType\Transfer_Pricing_Rate_SheetObjectType[] $transfer_Pricing_Rate_Sheet_Reference
     */
    public function __construct(array $transfer_Pricing_Rate_Sheet_Reference = array())
    {
        $this
            ->setTransfer_Pricing_Rate_Sheet_Reference($transfer_Pricing_Rate_Sheet_Reference);
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Reference value
     * @return \StructType\Transfer_Pricing_Rate_SheetObjectType[]|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Reference()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Pricing_Rate_Sheet_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Pricing_Rate_Sheet_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Pricing_Rate_Sheet_ReferenceForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem) {
            // validation for constraint: itemType
            if (!$transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem instanceof \StructType\Transfer_Pricing_Rate_SheetObjectType) {
                $invalidValues[] = is_object($transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem) ? get_class($transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem) : sprintf('%s(%s)', gettype($transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem), var_export($transfer_Pricing_Rate_Sheet_Request_ReferencesTypeTransfer_Pricing_Rate_Sheet_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Pricing_Rate_Sheet_Reference property can only contain items of type \StructType\Transfer_Pricing_Rate_SheetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_SheetObjectType[] $transfer_Pricing_Rate_Sheet_Reference
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Request_ReferencesType
     */
    public function setTransfer_Pricing_Rate_Sheet_Reference(array $transfer_Pricing_Rate_Sheet_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Pricing_Rate_Sheet_ReferenceArrayErrorMessage = self::validateTransfer_Pricing_Rate_Sheet_ReferenceForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Reference($transfer_Pricing_Rate_Sheet_Reference))) {
            throw new \InvalidArgumentException($transfer_Pricing_Rate_Sheet_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Reference = $transfer_Pricing_Rate_Sheet_Reference;
        return $this;
    }
    /**
     * Add item to Transfer_Pricing_Rate_Sheet_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_SheetObjectType $item
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Request_ReferencesType
     */
    public function addToTransfer_Pricing_Rate_Sheet_Reference(\StructType\Transfer_Pricing_Rate_SheetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Pricing_Rate_SheetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Pricing_Rate_Sheet_Reference property can only contain items of type \StructType\Transfer_Pricing_Rate_SheetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Reference[] = $item;
        return $this;
    }
}
