<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Line_Replacement__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Remove the value on the Spend Category field or submit a value that matches the item spend category. When there's no value for Spend Category, Workday populates the field from the item. | You can't submit Tax Data when Company has a
 * third party tax integration enabled for Supplier Invoices. | You can't submit Tax Rate Data when Company has a third party tax integration enabled for Supplier Invoices. | You can't specify a third party tax code in the transaction tax code
 * reference. | You can't change these fields for an invoice associated to a purchase order of type Bill and Replace: Purchase Item, Ship-To Address, Spend Category, UOM, Quantity, Retention Amount, Payment Amount and Prepaid. | You can't change
 * worktags on an invoice with enabled balancing worktags, or an invoice associated to a purchase order of type Bill and Replace. | You can't add splits for an invoice associated to a purchase order of type Bill and Replace. | You can't associate
 * invoices to Consignment type Contracts. | Catalog Item is invalid for the combination of Customer, Supplier, Supplier Contract and Document Date. Supplier Invoices and Recurring Supplier Invoices require Catalog Items from Supplier Contracts allowing
 * Manual Invoicing. Supplier Invoice Adjustments and Ad Hoc Payments also accepts Supplier Contracts allowing Scheduled Invoicing. | Purchase Item is Inactive and is not on the Purchase Order Line. | The Purchase Order Line is for an item whose
 * Supplier Contract does not allow Manual Invoicing. | The distribution method for the provided purchase order line is 'Amount,' but the sum of the line split quantities is greater than 0. Modify the line splits or change the purchase order line
 * reference. | The distribution method for the provided purchase order line is 'Quantity,' but the sum of the line split quantities is 0. Modify the line splits or change the purchase order line reference. | The Procurement Item must match the
 * Procurement Item on the Supplier Contract Line. | If both Supplier Contract Line and Purchase Order Line are entered, the Purchase Order Line must be for the same Supplier Contract Line. The Supplier Contract Line for the Purchase Order Line does not
 * match the Supplier Contract Line for this Invoice Line. | The Supplier Contract Line must have the same Company or Intercompany Affiliate as the Supplier Invoice Line. | The Supplier Contract Line has been Canceled and cannot be used. | The Supplier
 * Contract Line supplier is On Hold and may not be used. | The Supplier Invoice requires at least a Procurement item or a Spend Category. If a Procurement Item is provided, the Spend Category will be defaulted from the Purchase Item Spend Category. If
 * a Purchase Order Line Reference is provided, then the Procurement Item and Spend Categories will be copied from the Purchase Order Line if not provided. | Only one worktag for each type is allowed for each document line. | Spend Category must match
 * the Spend Category for the Procurement Item. | If Quantity or Unit Cost do not equal zero, the Extended Amount must equal Quantity * Unit Cost | Any associated Purchase Order Line must have the same Company or Intercompany Affiliate as the Invoice
 * Line. This validation only applies if you are associating a Workday known PO Line with a Supplier Invoice Line.It does not apply to Supplier Invoice Lines which are part of a Supplier Invoice Contract or Ad Hoc Payment. This is because Purchase Order
 * Line references are not allowed for these business documents. | Any associated Purchase Order Line must have the same Supplier as the Invoice. This validation only applies if you are associating a Workday known PO Line with a Supplier Invoice Line.It
 * does not apply to Supplier Invoice Lines which are part of a Supplier Invoice Contract or Ad Hoc Payment. This is because Purchase Order Line references are not allowed for these business documents. | Purchase Order Line must be from an issued Order.
 * | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Purchase Order Line References are not allowed for Invoice Lines for Ad Hoc Payments, Supplier Invoice Contracts, and Supplier Invoice Adjustments.
 * | Encapsulating element containing Supplier Invoice Line data.
 * @subpackage Structs
 */
class Supplier_Invoice_Line_Replacement__HV__DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Setting of Supplier Invoice Line Reference ID is not allowed for add-only service requests | The Supplier Invoice Document for the referenced Supplier Invoice Line must be equal to the Supplier Invoice Document in this request |
     * Supplier Invoice Line Reference ID. This is the Supplier Invoice Line unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Line_ID;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Optional line order. If specified, lines will be sorted by this value when displayed and when invoice is printed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Intercompany_Affiliate_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the Company.If this is blank, Workday will default the company from the invoice header. If a value is provided that is different from the invoice header, workday validates that there is an
     * appropriate intercompany relationship configured.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Intercompany_Affiliate_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only Purchase Item and Catalog Item can be referenced in a supplier invoice. | Reference to an existing Purchase Item. Purchase items are goods and services that are purchased from suppliers.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: An optional description of the item, especially useful if only a Spend Category is selected for this line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Order Line referenced is from a PO that is Closed or Pending Close. | The Purchase Order Line referenced is verified on a Procurement Card Transaction Verification report and can not be invoiced. | An optional reference
     * to an existing Purchase Order Line in the Workday system. This is used to link the Supplier Invoice Line with a Purchase Order Line. If the invoice line is for an external Purchase Order (not available within Workday), leave this blank.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: An optional reference to an existing Supplier Contract Line in the Workday system. This is used to link the Supplier Invoice Line with a Supplier Contract Line. Is not allowed for Ad Hoc Requests, Supplier Contract Adjustments, or
     * Supplier Invoice Contracts (Recurring Supplier Invoices).
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Customer_Invoice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: An optional reference to an existing Customer Invoice Line in the Workday system. This is used to link the Supplier Invoice Line with a Customer Invoice for Direct Intercompany Invoices.
     * - minOccurs: 0
     * @var \StructType\Customer_Invoice_LineObjectType
     */
    public $Customer_Invoice_Line_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Commodity Code for the invoice line. This field populates from the related purchase order, it's read-only, and will be ignored on the Import Supplier Invoice and Submit Supplier Invoice web services.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference instance or a Address Reference ID for an existing address
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the accounting treatment of a trackable item line derived from business asset accounting rules.
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Trackable_Item
     * Meta information extracted from the WSDL
     * - documentation: This is the track items attribute on Spend Category, at the time the supplier invoice was submitted. As spend categories can change over time, this value is persisted for reporting purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Trackable_Item;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference is required if Tax Code Reference is provided. | This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability
     * from the sales item. If the invoice line has a tax code then tax applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Code on the line is only allowed if the Tax Option is Calculate Tax Due to Supplier or Calculate Use Tax. | You can't submit a Tax Code at the line when the Company has a third party tax integration enabled for Supplier Invoices.
     * | This is the reference id value of the tax code.If this is blank, Workday will default in the default tax code from the invoice header if there is one. If the invoice line has a tax applicability value, Workday will validate that the invoice line
     * also has a tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Withholding_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the withholding tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Withholding_Tax_Code_Reference;
    /**
     * The Tax_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Widget_DataType
     */
    public $Tax_Data;
    /**
     * The Tax_Rate_Options_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Options_Data;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invalid unit of measure for catalog item. Unit of measure is not a defined ordering unit of measure or is not the same as the source document line unit of measure. | Invalid unit of measure for purchase item. Unit of measure must be
     * the same as the source document line. | Unit of Measure for the Supplier Invoice Line to be imported.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Retention_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount to retain from the scheduled supplier invoice installment. | The amount to retain from this invoice line.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Retention_Amount;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date from the supplier invoice header.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: The Prepaid flag cannot be checked for a Tax Only Invoice Type. | Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Invoice line. This is free form text.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplied Supplier Contract is Closed or Pending Close. | You selected an invalid supplier contract for this supplier invoice line. Select a supplier contract that's valid for the company, supplier, and document date; not
     * undergoing an amendment; and supports manual supplier invoices. | The Supplier Contract field on the Invoice line is required if there is a Contract Line referenced. | The Supplier Contract provided cannot be used because it is referenced on a
     * Procurement Card Verification. | The Supplier Contract selected must be for the Supplier on the invoice. | This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier
     * Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags are not allowed when there are split lines. | For supplier invoice lines tagged with a capital project worktag, the company of the invoice line must equal the company on the capital project. | Reference to existing worktags.
     * Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Clear the prepaid or billable option for the line when Deferred Project Cost Accounting is configured. Only 1 of these options can apply to the supplier invoice line. | The supplier invoice line can't be marked as Billable if the
     * selected Worktag is not for a project plan,phase, or task from a billable project | Billable Flag at Invoice Line Level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Worktag_Split_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Allocation Template for Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_TemplateObjectType
     */
    public $Worktag_Split_Template_Reference;
    /**
     * The Supplier_Invoice_Split_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Split_DataType[]
     */
    public $Supplier_Invoice_Split_Line_Data;
    /**
     * Constructor method for Supplier_Invoice_Line_Replacement__HV__DataType
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setSupplier_Invoice_Line_ID()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setLine_Order()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setIntercompany_Affiliate_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setPurchase_Item_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setItem_Description()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setPurchase_Order_Line_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setSupplier_Contract_Line_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setCustomer_Invoice_Line_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setSpend_Category_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setCommodity_Code_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setShip_To_Address_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setShip_To_Contact_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setAccounting_Treatment_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setTrackable_Item()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setTax_Applicability_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setTax_Code_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setWithholding_Tax_Code_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setTax_Data()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setTax_Rate_Options_Data()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setQuantity()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setUnit_of_Measure_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setUnit_Cost()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setExtended_Amount()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setRetention_Amount()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setBudget_Date()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setPrepaid()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setMemo()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setWorktags_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setBillable()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setWorktag_Split_Template_Reference()
     * @uses Supplier_Invoice_Line_Replacement__HV__DataType::setSupplier_Invoice_Split_Line_Data()
     * @param string $supplier_Invoice_Line_ID
     * @param string $line_Order
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @param \StructType\Procurement_ItemObjectType $purchase_Item_Reference
     * @param string $item_Description
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\Customer_Invoice_LineObjectType $customer_Invoice_Line_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param bool $trackable_Item
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference
     * @param \StructType\Tax_Widget_DataType $tax_Data
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param float $retention_Amount
     * @param string $budget_Date
     * @param bool $prepaid
     * @param string $memo
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param bool $billable
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @param \StructType\Supplier_Invoice_Line_Split_DataType[] $supplier_Invoice_Split_Line_Data
     */
    public function __construct($supplier_Invoice_Line_ID = null, $line_Order = null, \StructType\CompanyObjectType $intercompany_Affiliate_Reference = null, \StructType\Procurement_ItemObjectType $purchase_Item_Reference = null, $item_Description = null, \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\Customer_Invoice_LineObjectType $customer_Invoice_Line_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, $trackable_Item = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference = null, \StructType\Tax_Widget_DataType $tax_Data = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, $retention_Amount = null, $budget_Date = null, $prepaid = null, $memo = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $worktags_Reference = array(), $billable = null, \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null, array $supplier_Invoice_Split_Line_Data = array())
    {
        $this
            ->setSupplier_Invoice_Line_ID($supplier_Invoice_Line_ID)
            ->setLine_Order($line_Order)
            ->setIntercompany_Affiliate_Reference($intercompany_Affiliate_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setItem_Description($item_Description)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setCustomer_Invoice_Line_Reference($customer_Invoice_Line_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setTrackable_Item($trackable_Item)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setWithholding_Tax_Code_Reference($withholding_Tax_Code_Reference)
            ->setTax_Data($tax_Data)
            ->setTax_Rate_Options_Data($tax_Rate_Options_Data)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setRetention_Amount($retention_Amount)
            ->setBudget_Date($budget_Date)
            ->setPrepaid($prepaid)
            ->setMemo($memo)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setBillable($billable)
            ->setWorktag_Split_Template_Reference($worktag_Split_Template_Reference)
            ->setSupplier_Invoice_Split_Line_Data($supplier_Invoice_Split_Line_Data);
    }
    /**
     * Get Supplier_Invoice_Line_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Line_ID()
    {
        return $this->Supplier_Invoice_Line_ID;
    }
    /**
     * Set Supplier_Invoice_Line_ID value
     * @param string $supplier_Invoice_Line_ID
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setSupplier_Invoice_Line_ID($supplier_Invoice_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Line_ID) && !is_string($supplier_Invoice_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Line_ID, true), gettype($supplier_Invoice_Line_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Line_ID = $supplier_Invoice_Line_ID;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Intercompany_Affiliate_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getIntercompany_Affiliate_Reference()
    {
        return $this->Intercompany_Affiliate_Reference;
    }
    /**
     * Set Intercompany_Affiliate_Reference value
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setIntercompany_Affiliate_Reference(\StructType\CompanyObjectType $intercompany_Affiliate_Reference = null)
    {
        $this->Intercompany_Affiliate_Reference = $intercompany_Affiliate_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setPurchase_Item_Reference(\StructType\Procurement_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Customer_Invoice_Line_Reference value
     * @return \StructType\Customer_Invoice_LineObjectType|null
     */
    public function getCustomer_Invoice_Line_Reference()
    {
        return $this->Customer_Invoice_Line_Reference;
    }
    /**
     * Set Customer_Invoice_Line_Reference value
     * @param \StructType\Customer_Invoice_LineObjectType $customer_Invoice_Line_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setCustomer_Invoice_Line_Reference(\StructType\Customer_Invoice_LineObjectType $customer_Invoice_Line_Reference = null)
    {
        $this->Customer_Invoice_Line_Reference = $customer_Invoice_Line_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Trackable_Item value
     * @return bool|null
     */
    public function getTrackable_Item()
    {
        return $this->Trackable_Item;
    }
    /**
     * Set Trackable_Item value
     * @param bool $trackable_Item
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setTrackable_Item($trackable_Item = null)
    {
        // validation for constraint: boolean
        if (!is_null($trackable_Item) && !is_bool($trackable_Item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trackable_Item, true), gettype($trackable_Item)), __LINE__);
        }
        $this->Trackable_Item = $trackable_Item;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Withholding_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getWithholding_Tax_Code_Reference()
    {
        return $this->Withholding_Tax_Code_Reference;
    }
    /**
     * Set Withholding_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setWithholding_Tax_Code_Reference(\StructType\Tax_CodeObjectType $withholding_Tax_Code_Reference = null)
    {
        $this->Withholding_Tax_Code_Reference = $withholding_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Data value
     * @return \StructType\Tax_Widget_DataType|null
     */
    public function getTax_Data()
    {
        return $this->Tax_Data;
    }
    /**
     * Set Tax_Data value
     * @param \StructType\Tax_Widget_DataType $tax_Data
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setTax_Data(\StructType\Tax_Widget_DataType $tax_Data = null)
    {
        $this->Tax_Data = $tax_Data;
        return $this;
    }
    /**
     * Get Tax_Rate_Options_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Options_Data()
    {
        return $this->Tax_Rate_Options_Data;
    }
    /**
     * Set Tax_Rate_Options_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setTax_Rate_Options_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null)
    {
        $this->Tax_Rate_Options_Data = $tax_Rate_Options_Data;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Retention_Amount value
     * @return float|null
     */
    public function getRetention_Amount()
    {
        return $this->Retention_Amount;
    }
    /**
     * Set Retention_Amount value
     * @param float $retention_Amount
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setRetention_Amount($retention_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($retention_Amount) && !(is_float($retention_Amount) || is_numeric($retention_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retention_Amount, true), gettype($retention_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($retention_Amount) && mb_strlen(mb_substr($retention_Amount, false !== mb_strpos($retention_Amount, '.') ? mb_strpos($retention_Amount, '.') + 1 : mb_strlen($retention_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($retention_Amount, true), mb_strlen(mb_substr($retention_Amount, mb_strpos($retention_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($retention_Amount) && $retention_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($retention_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($retention_Amount) && mb_strlen(preg_replace('/(\D)/', '', $retention_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($retention_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $retention_Amount))), __LINE__);
        }
        $this->Retention_Amount = $retention_Amount;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem) ? get_class($supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem), var_export($supplier_Invoice_Line_Replacement_HV_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Reference value
     * @return \StructType\Worktag_Split_TemplateObjectType|null
     */
    public function getWorktag_Split_Template_Reference()
    {
        return $this->Worktag_Split_Template_Reference;
    }
    /**
     * Set Worktag_Split_Template_Reference value
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setWorktag_Split_Template_Reference(\StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null)
    {
        $this->Worktag_Split_Template_Reference = $worktag_Split_Template_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Split_Line_Data value
     * @return \StructType\Supplier_Invoice_Line_Split_DataType[]|null
     */
    public function getSupplier_Invoice_Split_Line_Data()
    {
        return $this->Supplier_Invoice_Split_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Split_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Split_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Split_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Split_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem instanceof \StructType\Supplier_Invoice_Line_Split_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem) ? get_class($supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem), var_export($supplier_Invoice_Line_Replacement_HV_DataTypeSupplier_Invoice_Split_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Split_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Split_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Split_DataType[] $supplier_Invoice_Split_Line_Data
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function setSupplier_Invoice_Split_Line_Data(array $supplier_Invoice_Split_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Split_Line_DataArrayErrorMessage = self::validateSupplier_Invoice_Split_Line_DataForArrayConstraintsFromSetSupplier_Invoice_Split_Line_Data($supplier_Invoice_Split_Line_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Split_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Split_Line_Data = $supplier_Invoice_Split_Line_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Split_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Split_DataType $item
     * @return \StructType\Supplier_Invoice_Line_Replacement__HV__DataType
     */
    public function addToSupplier_Invoice_Split_Line_Data(\StructType\Supplier_Invoice_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Split_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Split_Line_Data[] = $item;
        return $this;
    }
}
