<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recurring_Supplier_Invoice_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't submit Taxable Code Application Data when Company has a third party tax integration enabled for Supplier Invoices. | End Date can't be earlier than First Invoice Date. | End Date can't be earlier than Effective Date. | End
 * Date can't be earlier than an Invoice Creation Date. | First Invoice Date can't be earlier than Effective Date. | Total Amount and/or End Date must be selected. | Effective Date can't be in the past. | Please enter at least one invoice line. |
 * Recurring Supplier Invoice Data
 * @subpackage Structs
 */
class Recurring_Supplier_Invoice_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: Recurring Supplier Invoice Contract ID. This is the Recurring Supplier Invoice unique identifier. Supplier Invoice Contract was renamed to Recurring Supplier Invoice and refer to the same business object.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Contract_ID;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Contract Name
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Name;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Supplier for this Recurring Supplier Invoice is inactive. Please activate the Supplier before correcting this Recurring Supplier Invoice. | Reference to an existing Supplier
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Use_Default_Supplier_Connection
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the default supplier connection will be derived.
     * - choice: Use_Default_Supplier_Connection | Supplier_Connection_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Default_Supplier_Connection;
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - choice: Use_Default_Supplier_Connection | Supplier_Connection_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Free form text field to provide a Supplier Reference memo. The Supplier Reference is not a Workday Reference ID, but a text field for providing additional information about the Supplier Invoice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that supplier invoice is for. This is the reference id value of the company.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency must be specified or Company must have a default Currency | Currency entered is not listed as an Accepted Currency by Supplier. | This is the reference id of the Currency on the Supplier Invoice Contract.
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Statutory_Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type for Submit Invoice Contracts.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Statutory_Invoice_Type_Reference;
    /**
     * The Contract_Overview
     * Meta information extracted from the WSDL
     * - documentation: Contract Overview
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Overview;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id of the payment terms for the Supplier Invoice Contract. Payment Terms are the rules for establishing when a invoice payment is due and whether discounts are eligible to be taken or given for early payment.
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Fixed_Contract
     * Meta information extracted from the WSDL
     * - documentation: Set to true if the supplier invoice contract is a Fixed contract.This option cannot be selected along with Variable Contract.
     * - choice: Fixed_Contract | Variable_Contract
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Fixed_Contract;
    /**
     * The Variable_Contract
     * Meta information extracted from the WSDL
     * - documentation: Set to true if the supplier invoice contract is a variable contract.This option cannot be selected along with Fixed Contract.
     * - choice: Fixed_Contract | Variable_Contract
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Variable_Contract;
    /**
     * The Frequency_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the Frequency at which invoices will be created.
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Type_Reference;
    /**
     * The Default_Tax_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the tax option for the recurring supplier invoice.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Default_Tax_Option_Reference;
    /**
     * The Default_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't submit a Tax Code at the header when the Company has a third party tax integration enabled for Supplier Invoices. | This is the default tax code for the recurring supplier invoice.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Tax_Code_Reference;
    /**
     * The Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Start_Date;
    /**
     * The First_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: This date is used as the Invoice Date for the initial invoice generated off of the contract. That invoice date may be different from the contract start term.
     * - maxOccurs: 1
     * @var string
     */
    public $First_Invoice_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Total_Contract_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Contract Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Contract_Amount;
    /**
     * The Supplier_Invoice_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Contract Line Data. A Supplier Invoice Contract may have multiple lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Replacement_DataType[]
     */
    public $Supplier_Invoice_Line_Replacement_Data;
    /**
     * The Currency_Rate_Type_Override_Reference
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this allows you to override the default Rate Type used to look up the currency conversion rate.
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_TypeObjectType
     */
    public $Currency_Rate_Type_Override_Reference;
    /**
     * The Currency_Rate_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this allows you to override the date used to look up the currency conversion rate. The default date is normally the same as the invoice date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency_Rate_Date_Override;
    /**
     * The Currency_Rate_Manual_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this allows you to directly override the currency conversion rate that will be used. | Currency rate manual override.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Currency_Rate_Manual_Override;
    /**
     * The Document_Currency_Conversion_Rate
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the currency conversion rate for the accounting document ledger.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Supplier refund
     * currency conversion rate
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Document_Currency_Conversion_Rate;
    /**
     * The Rate_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is an indicator for whether the currency exchange rate has been overwritten or not.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Rate_Override;
    /**
     * The Currency_Rate_Lookup_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is currency exchange rate derived based on the currency rate type override or currency rate date override.This information is for outbound purposes only and is not processed on inbound Workday Web
     * Services requests. | Currency rate lookup override.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Currency_Rate_Lookup_Override;
    /**
     * The Manual_Override_Percent
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the percentage of the currency rate manual override against the default currency rate.This information is for outbound purposes only and is not processed on inbound Workday Web Services
     * requests. | Manual override percent.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Manual_Override_Percent;
    /**
     * The Default_Rate_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the default currency rate type.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_TypeObjectType[]
     */
    public $Default_Rate_Type_Reference;
    /**
     * The Rate_Basis_Date
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the basis date used to derive the of the currency exchange rate.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rate_Basis_Date;
    /**
     * The Default_Currency_Rate
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the default currency rate.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Default currency rate.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 27
     * @var float
     */
    public $Default_Currency_Rate;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Taxable_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Tax Data by Tax Authority and Tax Code. For Customer Invoice Documents and Cash Sales tax data will always be calculated from the line data regardless of what is populated in Tax Rate Application Data. For Purchase Orders, Supplier
     * Invoice Documents and Ad hoc Payments, if data is in Tax Rate Application Data, then that will be the tax information that is saved. Otherwise, the tax will be calculated from the lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Taxable_Code_Application_DataType[]
     */
    public $Taxable_Code_Data;
    /**
     * The Withholding_Tax_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Withholding Tax Data by Tax Authority and Withholding Tax Code. For Customer Invoice Documents and Cash Sales tax data will always be calculated from the line data regardless of what is populated in Tax Rate Application Data. For
     * Purchase Orders, Supplier Invoice Documents and Ad hoc Payments, if data is in Tax Rate Application Data, then that will be the tax information that is saved. Otherwise, the tax will be calculated from the lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Withholding_Tax_Code_Application_DataType[]
     */
    public $Withholding_Tax_Code_Data;
    /**
     * Constructor method for Recurring_Supplier_Invoice_DataType
     * @uses Recurring_Supplier_Invoice_DataType::setSupplier_Invoice_Contract_ID()
     * @uses Recurring_Supplier_Invoice_DataType::setContract_Name()
     * @uses Recurring_Supplier_Invoice_DataType::setSupplier_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setUse_Default_Supplier_Connection()
     * @uses Recurring_Supplier_Invoice_DataType::setSupplier_Connection_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setSupplier_Reference_Number()
     * @uses Recurring_Supplier_Invoice_DataType::setCompany_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setCurrency_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setStatutory_Invoice_Type_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setContract_Overview()
     * @uses Recurring_Supplier_Invoice_DataType::setPayment_Terms_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setFixed_Contract()
     * @uses Recurring_Supplier_Invoice_DataType::setVariable_Contract()
     * @uses Recurring_Supplier_Invoice_DataType::setFrequency_Type_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setDefault_Tax_Option_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setDefault_Tax_Code_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setContract_Start_Date()
     * @uses Recurring_Supplier_Invoice_DataType::setFirst_Invoice_Date()
     * @uses Recurring_Supplier_Invoice_DataType::setContract_End_Date()
     * @uses Recurring_Supplier_Invoice_DataType::setTotal_Contract_Amount()
     * @uses Recurring_Supplier_Invoice_DataType::setSupplier_Invoice_Line_Replacement_Data()
     * @uses Recurring_Supplier_Invoice_DataType::setCurrency_Rate_Type_Override_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setCurrency_Rate_Date_Override()
     * @uses Recurring_Supplier_Invoice_DataType::setCurrency_Rate_Manual_Override()
     * @uses Recurring_Supplier_Invoice_DataType::setDocument_Currency_Conversion_Rate()
     * @uses Recurring_Supplier_Invoice_DataType::setRate_Override()
     * @uses Recurring_Supplier_Invoice_DataType::setCurrency_Rate_Lookup_Override()
     * @uses Recurring_Supplier_Invoice_DataType::setManual_Override_Percent()
     * @uses Recurring_Supplier_Invoice_DataType::setDefault_Rate_Type_Reference()
     * @uses Recurring_Supplier_Invoice_DataType::setRate_Basis_Date()
     * @uses Recurring_Supplier_Invoice_DataType::setDefault_Currency_Rate()
     * @uses Recurring_Supplier_Invoice_DataType::setAttachment_Data()
     * @uses Recurring_Supplier_Invoice_DataType::setTaxable_Code_Data()
     * @uses Recurring_Supplier_Invoice_DataType::setWithholding_Tax_Code_Data()
     * @param string $supplier_Invoice_Contract_ID
     * @param string $contract_Name
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param bool $use_Default_Supplier_Connection
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param string $supplier_Reference_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @param string $contract_Overview
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param bool $fixed_Contract
     * @param bool $variable_Contract
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Type_Reference
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @param string $contract_Start_Date
     * @param string $first_Invoice_Date
     * @param string $contract_End_Date
     * @param float $total_Contract_Amount
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $supplier_Invoice_Line_Replacement_Data
     * @param \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference
     * @param string $currency_Rate_Date_Override
     * @param float $currency_Rate_Manual_Override
     * @param float $document_Currency_Conversion_Rate
     * @param bool $rate_Override
     * @param float $currency_Rate_Lookup_Override
     * @param float $manual_Override_Percent
     * @param \StructType\Currency_Rate_TypeObjectType[] $default_Rate_Type_Reference
     * @param string $rate_Basis_Date
     * @param float $default_Currency_Rate
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Taxable_Code_Application_DataType[] $taxable_Code_Data
     * @param \StructType\Withholding_Tax_Code_Application_DataType[] $withholding_Tax_Code_Data
     */
    public function __construct($supplier_Invoice_Contract_ID = null, $contract_Name = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $use_Default_Supplier_Connection = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $supplier_Reference_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null, $contract_Overview = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, $fixed_Contract = null, $variable_Contract = null, \StructType\Frequency_BehaviorObjectType $frequency_Type_Reference = null, \StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null, \StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null, $contract_Start_Date = null, $first_Invoice_Date = null, $contract_End_Date = null, $total_Contract_Amount = null, array $supplier_Invoice_Line_Replacement_Data = array(), \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference = null, $currency_Rate_Date_Override = null, $currency_Rate_Manual_Override = null, $document_Currency_Conversion_Rate = null, $rate_Override = null, $currency_Rate_Lookup_Override = null, $manual_Override_Percent = null, array $default_Rate_Type_Reference = array(), $rate_Basis_Date = null, $default_Currency_Rate = null, array $attachment_Data = array(), array $taxable_Code_Data = array(), array $withholding_Tax_Code_Data = array())
    {
        $this
            ->setSupplier_Invoice_Contract_ID($supplier_Invoice_Contract_ID)
            ->setContract_Name($contract_Name)
            ->setSupplier_Reference($supplier_Reference)
            ->setUse_Default_Supplier_Connection($use_Default_Supplier_Connection)
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setStatutory_Invoice_Type_Reference($statutory_Invoice_Type_Reference)
            ->setContract_Overview($contract_Overview)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setFixed_Contract($fixed_Contract)
            ->setVariable_Contract($variable_Contract)
            ->setFrequency_Type_Reference($frequency_Type_Reference)
            ->setDefault_Tax_Option_Reference($default_Tax_Option_Reference)
            ->setDefault_Tax_Code_Reference($default_Tax_Code_Reference)
            ->setContract_Start_Date($contract_Start_Date)
            ->setFirst_Invoice_Date($first_Invoice_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setTotal_Contract_Amount($total_Contract_Amount)
            ->setSupplier_Invoice_Line_Replacement_Data($supplier_Invoice_Line_Replacement_Data)
            ->setCurrency_Rate_Type_Override_Reference($currency_Rate_Type_Override_Reference)
            ->setCurrency_Rate_Date_Override($currency_Rate_Date_Override)
            ->setCurrency_Rate_Manual_Override($currency_Rate_Manual_Override)
            ->setDocument_Currency_Conversion_Rate($document_Currency_Conversion_Rate)
            ->setRate_Override($rate_Override)
            ->setCurrency_Rate_Lookup_Override($currency_Rate_Lookup_Override)
            ->setManual_Override_Percent($manual_Override_Percent)
            ->setDefault_Rate_Type_Reference($default_Rate_Type_Reference)
            ->setRate_Basis_Date($rate_Basis_Date)
            ->setDefault_Currency_Rate($default_Currency_Rate)
            ->setAttachment_Data($attachment_Data)
            ->setTaxable_Code_Data($taxable_Code_Data)
            ->setWithholding_Tax_Code_Data($withholding_Tax_Code_Data);
    }
    /**
     * Get Supplier_Invoice_Contract_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Contract_ID()
    {
        return $this->Supplier_Invoice_Contract_ID;
    }
    /**
     * Set Supplier_Invoice_Contract_ID value
     * @param string $supplier_Invoice_Contract_ID
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_Contract_ID($supplier_Invoice_Contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Contract_ID) && !is_string($supplier_Invoice_Contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Contract_ID, true), gettype($supplier_Invoice_Contract_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Contract_ID = $supplier_Invoice_Contract_ID;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Use_Default_Supplier_Connection value
     * @return bool|null
     */
    public function getUse_Default_Supplier_Connection()
    {
        return isset($this->Use_Default_Supplier_Connection) ? $this->Use_Default_Supplier_Connection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Default_Supplier_Connection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Default_Supplier_Connection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Connection_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Default_Supplier_Connection can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Default_Supplier_Connection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Default_Supplier_Connection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Default_Supplier_Connection
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setUse_Default_Supplier_Connection($use_Default_Supplier_Connection = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Default_Supplier_Connection) && !is_bool($use_Default_Supplier_Connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Default_Supplier_Connection, true), gettype($use_Default_Supplier_Connection)), __LINE__);
        }
        // validation for constraint: choice(Use_Default_Supplier_Connection, Supplier_Connection_Reference)
        if ('' !== ($use_Default_Supplier_ConnectionChoiceErrorMessage = self::validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($use_Default_Supplier_Connection))) {
            throw new \InvalidArgumentException($use_Default_Supplier_ConnectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Default_Supplier_Connection) || (is_array($use_Default_Supplier_Connection) && empty($use_Default_Supplier_Connection))) {
            unset($this->Use_Default_Supplier_Connection);
        } else {
            $this->Use_Default_Supplier_Connection = $use_Default_Supplier_Connection;
        }
        return $this;
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return isset($this->Supplier_Connection_Reference) ? $this->Supplier_Connection_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Connection_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Default_Supplier_Connection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Connection_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Connection_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Connection_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        // validation for constraint: choice(Use_Default_Supplier_Connection, Supplier_Connection_Reference)
        if ('' !== ($supplier_Connection_ReferenceChoiceErrorMessage = self::validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($supplier_Connection_Reference))) {
            throw new \InvalidArgumentException($supplier_Connection_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Connection_Reference) || (is_array($supplier_Connection_Reference) && empty($supplier_Connection_Reference))) {
            unset($this->Supplier_Connection_Reference);
        } else {
            $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Statutory_Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getStatutory_Invoice_Type_Reference()
    {
        return $this->Statutory_Invoice_Type_Reference;
    }
    /**
     * Set Statutory_Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setStatutory_Invoice_Type_Reference(\StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null)
    {
        $this->Statutory_Invoice_Type_Reference = $statutory_Invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Contract_Overview value
     * @return string|null
     */
    public function getContract_Overview()
    {
        return $this->Contract_Overview;
    }
    /**
     * Set Contract_Overview value
     * @param string $contract_Overview
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setContract_Overview($contract_Overview = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Overview) && !is_string($contract_Overview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Overview, true), gettype($contract_Overview)), __LINE__);
        }
        $this->Contract_Overview = $contract_Overview;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Fixed_Contract value
     * @return bool|null
     */
    public function getFixed_Contract()
    {
        return isset($this->Fixed_Contract) ? $this->Fixed_Contract : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFixed_Contract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFixed_Contract method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFixed_ContractForChoiceConstraintsFromSetFixed_Contract($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Variable_Contract',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Fixed_Contract can\'t be set as the property %s is already set. Only one property must be set among these properties: Fixed_Contract, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Fixed_Contract value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $fixed_Contract
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setFixed_Contract($fixed_Contract = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_Contract) && !is_bool($fixed_Contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_Contract, true), gettype($fixed_Contract)), __LINE__);
        }
        // validation for constraint: choice(Fixed_Contract, Variable_Contract)
        if ('' !== ($fixed_ContractChoiceErrorMessage = self::validateFixed_ContractForChoiceConstraintsFromSetFixed_Contract($fixed_Contract))) {
            throw new \InvalidArgumentException($fixed_ContractChoiceErrorMessage, __LINE__);
        }
        if (is_null($fixed_Contract) || (is_array($fixed_Contract) && empty($fixed_Contract))) {
            unset($this->Fixed_Contract);
        } else {
            $this->Fixed_Contract = $fixed_Contract;
        }
        return $this;
    }
    /**
     * Get Variable_Contract value
     * @return bool|null
     */
    public function getVariable_Contract()
    {
        return isset($this->Variable_Contract) ? $this->Variable_Contract : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVariable_Contract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariable_Contract method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVariable_ContractForChoiceConstraintsFromSetVariable_Contract($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Fixed_Contract',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Variable_Contract can\'t be set as the property %s is already set. Only one property must be set among these properties: Variable_Contract, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Variable_Contract value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $variable_Contract
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setVariable_Contract($variable_Contract = null)
    {
        // validation for constraint: boolean
        if (!is_null($variable_Contract) && !is_bool($variable_Contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($variable_Contract, true), gettype($variable_Contract)), __LINE__);
        }
        // validation for constraint: choice(Fixed_Contract, Variable_Contract)
        if ('' !== ($variable_ContractChoiceErrorMessage = self::validateVariable_ContractForChoiceConstraintsFromSetVariable_Contract($variable_Contract))) {
            throw new \InvalidArgumentException($variable_ContractChoiceErrorMessage, __LINE__);
        }
        if (is_null($variable_Contract) || (is_array($variable_Contract) && empty($variable_Contract))) {
            unset($this->Variable_Contract);
        } else {
            $this->Variable_Contract = $variable_Contract;
        }
        return $this;
    }
    /**
     * Get Frequency_Type_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Type_Reference()
    {
        return $this->Frequency_Type_Reference;
    }
    /**
     * Set Frequency_Type_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Type_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setFrequency_Type_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Type_Reference = null)
    {
        $this->Frequency_Type_Reference = $frequency_Type_Reference;
        return $this;
    }
    /**
     * Get Default_Tax_Option_Reference value
     * @return \StructType\Tax_OptionObjectType|null
     */
    public function getDefault_Tax_Option_Reference()
    {
        return $this->Default_Tax_Option_Reference;
    }
    /**
     * Set Default_Tax_Option_Reference value
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setDefault_Tax_Option_Reference(\StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null)
    {
        $this->Default_Tax_Option_Reference = $default_Tax_Option_Reference;
        return $this;
    }
    /**
     * Get Default_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Tax_Code_Reference()
    {
        return $this->Default_Tax_Code_Reference;
    }
    /**
     * Set Default_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setDefault_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null)
    {
        $this->Default_Tax_Code_Reference = $default_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Contract_Start_Date value
     * @return string|null
     */
    public function getContract_Start_Date()
    {
        return $this->Contract_Start_Date;
    }
    /**
     * Set Contract_Start_Date value
     * @param string $contract_Start_Date
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setContract_Start_Date($contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date) && !is_string($contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date, true), gettype($contract_Start_Date)), __LINE__);
        }
        $this->Contract_Start_Date = $contract_Start_Date;
        return $this;
    }
    /**
     * Get First_Invoice_Date value
     * @return string|null
     */
    public function getFirst_Invoice_Date()
    {
        return $this->First_Invoice_Date;
    }
    /**
     * Set First_Invoice_Date value
     * @param string $first_Invoice_Date
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setFirst_Invoice_Date($first_Invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($first_Invoice_Date) && !is_string($first_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Invoice_Date, true), gettype($first_Invoice_Date)), __LINE__);
        }
        $this->First_Invoice_Date = $first_Invoice_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Total_Contract_Amount value
     * @return float|null
     */
    public function getTotal_Contract_Amount()
    {
        return $this->Total_Contract_Amount;
    }
    /**
     * Set Total_Contract_Amount value
     * @param float $total_Contract_Amount
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setTotal_Contract_Amount($total_Contract_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Contract_Amount) && !(is_float($total_Contract_Amount) || is_numeric($total_Contract_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Contract_Amount, true), gettype($total_Contract_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Contract_Amount) && mb_strlen(mb_substr($total_Contract_Amount, false !== mb_strpos($total_Contract_Amount, '.') ? mb_strpos($total_Contract_Amount, '.') + 1 : mb_strlen($total_Contract_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Contract_Amount, true), mb_strlen(mb_substr($total_Contract_Amount, mb_strpos($total_Contract_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Contract_Amount) && $total_Contract_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Contract_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Contract_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Contract_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount))), __LINE__);
        }
        $this->Total_Contract_Amount = $total_Contract_Amount;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Replacement_Data value
     * @return \StructType\Supplier_Invoice_Line_Replacement_DataType[]|null
     */
    public function getSupplier_Invoice_Line_Replacement_Data()
    {
        return $this->Supplier_Invoice_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Line_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
                $invalidValues[] = is_object($recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem) ? get_class($recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem), var_export($recurring_Supplier_Invoice_DataTypeSupplier_Invoice_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $supplier_Invoice_Line_Replacement_Data
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_Line_Replacement_Data(array $supplier_Invoice_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Line_Replacement_DataArrayErrorMessage = self::validateSupplier_Invoice_Line_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Replacement_Data($supplier_Invoice_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line_Replacement_Data = $supplier_Invoice_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType $item
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function addToSupplier_Invoice_Line_Replacement_Data(\StructType\Supplier_Invoice_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Currency_Rate_Type_Override_Reference value
     * @return \StructType\Currency_Rate_TypeObjectType|null
     */
    public function getCurrency_Rate_Type_Override_Reference()
    {
        return $this->Currency_Rate_Type_Override_Reference;
    }
    /**
     * Set Currency_Rate_Type_Override_Reference value
     * @param \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCurrency_Rate_Type_Override_Reference(\StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference = null)
    {
        $this->Currency_Rate_Type_Override_Reference = $currency_Rate_Type_Override_Reference;
        return $this;
    }
    /**
     * Get Currency_Rate_Date_Override value
     * @return string|null
     */
    public function getCurrency_Rate_Date_Override()
    {
        return $this->Currency_Rate_Date_Override;
    }
    /**
     * Set Currency_Rate_Date_Override value
     * @param string $currency_Rate_Date_Override
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCurrency_Rate_Date_Override($currency_Rate_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($currency_Rate_Date_Override) && !is_string($currency_Rate_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_Rate_Date_Override, true), gettype($currency_Rate_Date_Override)), __LINE__);
        }
        $this->Currency_Rate_Date_Override = $currency_Rate_Date_Override;
        return $this;
    }
    /**
     * Get Currency_Rate_Manual_Override value
     * @return float|null
     */
    public function getCurrency_Rate_Manual_Override()
    {
        return $this->Currency_Rate_Manual_Override;
    }
    /**
     * Set Currency_Rate_Manual_Override value
     * @param float $currency_Rate_Manual_Override
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCurrency_Rate_Manual_Override($currency_Rate_Manual_Override = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Rate_Manual_Override) && !(is_float($currency_Rate_Manual_Override) || is_numeric($currency_Rate_Manual_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Rate_Manual_Override, true), gettype($currency_Rate_Manual_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Rate_Manual_Override) && mb_strlen(mb_substr($currency_Rate_Manual_Override, false !== mb_strpos($currency_Rate_Manual_Override, '.') ? mb_strpos($currency_Rate_Manual_Override, '.') + 1 : mb_strlen($currency_Rate_Manual_Override))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Rate_Manual_Override, true), mb_strlen(mb_substr($currency_Rate_Manual_Override, mb_strpos($currency_Rate_Manual_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($currency_Rate_Manual_Override) && mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Manual_Override)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($currency_Rate_Manual_Override, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Manual_Override))), __LINE__);
        }
        $this->Currency_Rate_Manual_Override = $currency_Rate_Manual_Override;
        return $this;
    }
    /**
     * Get Document_Currency_Conversion_Rate value
     * @return float|null
     */
    public function getDocument_Currency_Conversion_Rate()
    {
        return $this->Document_Currency_Conversion_Rate;
    }
    /**
     * Set Document_Currency_Conversion_Rate value
     * @param float $document_Currency_Conversion_Rate
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setDocument_Currency_Conversion_Rate($document_Currency_Conversion_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($document_Currency_Conversion_Rate) && !(is_float($document_Currency_Conversion_Rate) || is_numeric($document_Currency_Conversion_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($document_Currency_Conversion_Rate, true), gettype($document_Currency_Conversion_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($document_Currency_Conversion_Rate) && mb_strlen(mb_substr($document_Currency_Conversion_Rate, false !== mb_strpos($document_Currency_Conversion_Rate, '.') ? mb_strpos($document_Currency_Conversion_Rate, '.') + 1 : mb_strlen($document_Currency_Conversion_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($document_Currency_Conversion_Rate, true), mb_strlen(mb_substr($document_Currency_Conversion_Rate, mb_strpos($document_Currency_Conversion_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($document_Currency_Conversion_Rate) && mb_strlen(preg_replace('/(\D)/', '', $document_Currency_Conversion_Rate)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($document_Currency_Conversion_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $document_Currency_Conversion_Rate))), __LINE__);
        }
        $this->Document_Currency_Conversion_Rate = $document_Currency_Conversion_Rate;
        return $this;
    }
    /**
     * Get Rate_Override value
     * @return bool|null
     */
    public function getRate_Override()
    {
        return $this->Rate_Override;
    }
    /**
     * Set Rate_Override value
     * @param bool $rate_Override
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setRate_Override($rate_Override = null)
    {
        // validation for constraint: boolean
        if (!is_null($rate_Override) && !is_bool($rate_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rate_Override, true), gettype($rate_Override)), __LINE__);
        }
        $this->Rate_Override = $rate_Override;
        return $this;
    }
    /**
     * Get Currency_Rate_Lookup_Override value
     * @return float|null
     */
    public function getCurrency_Rate_Lookup_Override()
    {
        return $this->Currency_Rate_Lookup_Override;
    }
    /**
     * Set Currency_Rate_Lookup_Override value
     * @param float $currency_Rate_Lookup_Override
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setCurrency_Rate_Lookup_Override($currency_Rate_Lookup_Override = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Rate_Lookup_Override) && !(is_float($currency_Rate_Lookup_Override) || is_numeric($currency_Rate_Lookup_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Rate_Lookup_Override, true), gettype($currency_Rate_Lookup_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Rate_Lookup_Override) && mb_strlen(mb_substr($currency_Rate_Lookup_Override, false !== mb_strpos($currency_Rate_Lookup_Override, '.') ? mb_strpos($currency_Rate_Lookup_Override, '.') + 1 : mb_strlen($currency_Rate_Lookup_Override))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Rate_Lookup_Override, true), mb_strlen(mb_substr($currency_Rate_Lookup_Override, mb_strpos($currency_Rate_Lookup_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($currency_Rate_Lookup_Override) && mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Lookup_Override)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($currency_Rate_Lookup_Override, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Lookup_Override))), __LINE__);
        }
        $this->Currency_Rate_Lookup_Override = $currency_Rate_Lookup_Override;
        return $this;
    }
    /**
     * Get Manual_Override_Percent value
     * @return float|null
     */
    public function getManual_Override_Percent()
    {
        return $this->Manual_Override_Percent;
    }
    /**
     * Set Manual_Override_Percent value
     * @param float $manual_Override_Percent
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setManual_Override_Percent($manual_Override_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($manual_Override_Percent) && !(is_float($manual_Override_Percent) || is_numeric($manual_Override_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manual_Override_Percent, true), gettype($manual_Override_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($manual_Override_Percent) && mb_strlen(mb_substr($manual_Override_Percent, false !== mb_strpos($manual_Override_Percent, '.') ? mb_strpos($manual_Override_Percent, '.') + 1 : mb_strlen($manual_Override_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($manual_Override_Percent, true), mb_strlen(mb_substr($manual_Override_Percent, mb_strpos($manual_Override_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($manual_Override_Percent) && mb_strlen(preg_replace('/(\D)/', '', $manual_Override_Percent)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($manual_Override_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $manual_Override_Percent))), __LINE__);
        }
        $this->Manual_Override_Percent = $manual_Override_Percent;
        return $this;
    }
    /**
     * Get Default_Rate_Type_Reference value
     * @return \StructType\Currency_Rate_TypeObjectType[]|null
     */
    public function getDefault_Rate_Type_Reference()
    {
        return $this->Default_Rate_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault_Rate_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault_Rate_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefault_Rate_Type_ReferenceForArrayConstraintsFromSetDefault_Rate_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem instanceof \StructType\Currency_Rate_TypeObjectType) {
                $invalidValues[] = is_object($recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem) ? get_class($recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem) : sprintf('%s(%s)', gettype($recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem), var_export($recurring_Supplier_Invoice_DataTypeDefault_Rate_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Default_Rate_Type_Reference property can only contain items of type \StructType\Currency_Rate_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Default_Rate_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_TypeObjectType[] $default_Rate_Type_Reference
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setDefault_Rate_Type_Reference(array $default_Rate_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($default_Rate_Type_ReferenceArrayErrorMessage = self::validateDefault_Rate_Type_ReferenceForArrayConstraintsFromSetDefault_Rate_Type_Reference($default_Rate_Type_Reference))) {
            throw new \InvalidArgumentException($default_Rate_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Default_Rate_Type_Reference = $default_Rate_Type_Reference;
        return $this;
    }
    /**
     * Add item to Default_Rate_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_TypeObjectType $item
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function addToDefault_Rate_Type_Reference(\StructType\Currency_Rate_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency_Rate_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Default_Rate_Type_Reference property can only contain items of type \StructType\Currency_Rate_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Default_Rate_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Rate_Basis_Date value
     * @return string|null
     */
    public function getRate_Basis_Date()
    {
        return $this->Rate_Basis_Date;
    }
    /**
     * Set Rate_Basis_Date value
     * @param string $rate_Basis_Date
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setRate_Basis_Date($rate_Basis_Date = null)
    {
        // validation for constraint: string
        if (!is_null($rate_Basis_Date) && !is_string($rate_Basis_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate_Basis_Date, true), gettype($rate_Basis_Date)), __LINE__);
        }
        $this->Rate_Basis_Date = $rate_Basis_Date;
        return $this;
    }
    /**
     * Get Default_Currency_Rate value
     * @return float|null
     */
    public function getDefault_Currency_Rate()
    {
        return $this->Default_Currency_Rate;
    }
    /**
     * Set Default_Currency_Rate value
     * @param float $default_Currency_Rate
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setDefault_Currency_Rate($default_Currency_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($default_Currency_Rate) && !(is_float($default_Currency_Rate) || is_numeric($default_Currency_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Currency_Rate, true), gettype($default_Currency_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($default_Currency_Rate) && mb_strlen(mb_substr($default_Currency_Rate, false !== mb_strpos($default_Currency_Rate, '.') ? mb_strpos($default_Currency_Rate, '.') + 1 : mb_strlen($default_Currency_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($default_Currency_Rate, true), mb_strlen(mb_substr($default_Currency_Rate, mb_strpos($default_Currency_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Currency_Rate) && $default_Currency_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Currency_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(27)
        if (!is_null($default_Currency_Rate) && mb_strlen(preg_replace('/(\D)/', '', $default_Currency_Rate)) > 27) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 27 digits, "%d" given', var_export($default_Currency_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $default_Currency_Rate))), __LINE__);
        }
        $this->Default_Currency_Rate = $default_Currency_Rate;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurring_Supplier_Invoice_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$recurring_Supplier_Invoice_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($recurring_Supplier_Invoice_DataTypeAttachment_DataItem) ? get_class($recurring_Supplier_Invoice_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($recurring_Supplier_Invoice_DataTypeAttachment_DataItem), var_export($recurring_Supplier_Invoice_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Taxable_Code_Data value
     * @return \StructType\Taxable_Code_Application_DataType[]|null
     */
    public function getTaxable_Code_Data()
    {
        return $this->Taxable_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxable_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxable_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxable_Code_DataForArrayConstraintsFromSetTaxable_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem) {
            // validation for constraint: itemType
            if (!$recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem instanceof \StructType\Taxable_Code_Application_DataType) {
                $invalidValues[] = is_object($recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem) ? get_class($recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem) : sprintf('%s(%s)', gettype($recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem), var_export($recurring_Supplier_Invoice_DataTypeTaxable_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Taxable_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Taxable_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType[] $taxable_Code_Data
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setTaxable_Code_Data(array $taxable_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($taxable_Code_DataArrayErrorMessage = self::validateTaxable_Code_DataForArrayConstraintsFromSetTaxable_Code_Data($taxable_Code_Data))) {
            throw new \InvalidArgumentException($taxable_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Taxable_Code_Data = $taxable_Code_Data;
        return $this;
    }
    /**
     * Add item to Taxable_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType $item
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function addToTaxable_Code_Data(\StructType\Taxable_Code_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Taxable_Code_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Taxable_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Taxable_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get Withholding_Tax_Code_Data value
     * @return \StructType\Withholding_Tax_Code_Application_DataType[]|null
     */
    public function getWithholding_Tax_Code_Data()
    {
        return $this->Withholding_Tax_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholding_Tax_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholding_Tax_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholding_Tax_Code_DataForArrayConstraintsFromSetWithholding_Tax_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) {
            // validation for constraint: itemType
            if (!$recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem instanceof \StructType\Withholding_Tax_Code_Application_DataType) {
                $invalidValues[] = is_object($recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) ? get_class($recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) : sprintf('%s(%s)', gettype($recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem), var_export($recurring_Supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Withholding_Tax_Code_Data property can only contain items of type \StructType\Withholding_Tax_Code_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Withholding_Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Withholding_Tax_Code_Application_DataType[] $withholding_Tax_Code_Data
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function setWithholding_Tax_Code_Data(array $withholding_Tax_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($withholding_Tax_Code_DataArrayErrorMessage = self::validateWithholding_Tax_Code_DataForArrayConstraintsFromSetWithholding_Tax_Code_Data($withholding_Tax_Code_Data))) {
            throw new \InvalidArgumentException($withholding_Tax_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Withholding_Tax_Code_Data = $withholding_Tax_Code_Data;
        return $this;
    }
    /**
     * Add item to Withholding_Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Withholding_Tax_Code_Application_DataType $item
     * @return \StructType\Recurring_Supplier_Invoice_DataType
     */
    public function addToWithholding_Tax_Code_Data(\StructType\Withholding_Tax_Code_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Withholding_Tax_Code_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Withholding_Tax_Code_Data property can only contain items of type \StructType\Withholding_Tax_Code_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Withholding_Tax_Code_Data[] = $item;
        return $this;
    }
}
